/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import org.moddingx.libx.network.PacketHandler;
import org.moddingx.libx.network.PacketSerializer;

public record MagnetImmunityMessage(int entityId, boolean immune, double x, double y, double z) {

    public static class Handler
    implements PacketHandler<MagnetImmunityMessage> {
        public PacketHandler.Target target() {
            return PacketHandler.Target.MAIN_THREAD;
        }

        public boolean handle(MagnetImmunityMessage msg, Supplier<NetworkEvent.Context> ctx) {
            Entity entity;
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level != null && (entity = level.m_6815_(msg.entityId())) != null) {
                entity.getPersistentData().m_128379_("PreventRemoteMovement", msg.immune());
                entity.m_6034_(msg.x(), msg.y(), msg.z());
            }
            return true;
        }
    }

    public static class Serializer
    implements PacketSerializer<MagnetImmunityMessage> {
        public Class<MagnetImmunityMessage> messageClass() {
            return MagnetImmunityMessage.class;
        }

        public void encode(MagnetImmunityMessage msg, FriendlyByteBuf buffer) {
            buffer.writeInt(msg.entityId());
            buffer.writeBoolean(msg.immune());
            buffer.writeDouble(msg.x());
            buffer.writeDouble(msg.y());
            buffer.writeDouble(msg.z());
        }

        public MagnetImmunityMessage decode(FriendlyByteBuf buffer) {
            int entityId = buffer.readInt();
            boolean immune = buffer.readBoolean();
            int x = buffer.readInt();
            int y = buffer.readInt();
            int z = buffer.readInt();
            return new MagnetImmunityMessage(entityId, immune, x, y, z);
        }
    }
}

