/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.api.render.IVisualizable;
import de.ellpeck.naturesaura.blocks.BlockContainerImpl;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityOakGenerator;
import de.ellpeck.naturesaura.data.BlockStateGenerator;
import de.ellpeck.naturesaura.reg.ICustomBlockState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.SaplingGrowTreeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BlockOakGenerator
extends BlockContainerImpl
implements IVisualizable,
ICustomBlockState {
    public BlockOakGenerator() {
        super("oak_generator", BlockEntityOakGenerator.class, BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60978_(2.0f).m_60918_(SoundType.f_56736_));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onTreeGrow(SaplingGrowTreeEvent event) {
        LevelAccessor level = event.getLevel();
        BlockPos pos = event.getPos();
        if (level instanceof Level && !level.m_5776_() && IAuraType.forLevel((Level)level).isSimilar(NaturesAuraAPI.TYPE_OVERWORLD) && level.m_8055_(pos).m_60734_() instanceof SaplingBlock) {
            Helper.getBlockEntitiesInArea(level, pos, 10, tile -> {
                if (!(tile instanceof BlockEntityOakGenerator)) {
                    return false;
                }
                BlockEntityOakGenerator oak = (BlockEntityOakGenerator)tile;
                Holder<? extends ConfiguredFeature<?, ?>> replacement = BlockOakGenerator.getReplacement(event.getFeature());
                if (replacement != null) {
                    oak.scheduledBigTrees.add(pos);
                    event.setFeature(replacement);
                }
                return true;
            });
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public AABB getVisualizationBounds(Level level, BlockPos pos) {
        return new AABB(pos).m_82400_(10.0);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getVisualizationColor(Level level, BlockPos pos) {
        return 3045905;
    }

    @Override
    public void generateCustomBlockState(BlockStateGenerator generator) {
        generator.simpleBlock((Block)this, (ModelFile)generator.models().cubeBottomTop(this.getBaseName(), generator.modLoc("block/" + this.getBaseName()), generator.modLoc("block/" + this.getBaseName() + "_bottom"), generator.modLoc("block/" + this.getBaseName() + "_top")));
    }

    private static Holder<? extends ConfiguredFeature<?, ?>> getReplacement(Holder<? extends ConfiguredFeature<?, ?>> feature) {
        if (feature == TreeFeatures.f_195130_ || feature == TreeFeatures.f_195112_) {
            return TreeFeatures.f_195123_;
        }
        if (feature == TreeFeatures.f_195110_) {
            return TreeFeatures.f_195141_;
        }
        if (feature == TreeFeatures.f_195109_) {
            return TreeFeatures.f_195140_;
        }
        if (feature == TreeFeatures.f_195111_) {
            return TreeFeatures.f_195142_;
        }
        return null;
    }
}

