/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.items.tools;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.NaturesAura;
import de.ellpeck.naturesaura.data.ItemModelGenerator;
import de.ellpeck.naturesaura.items.ModItems;
import de.ellpeck.naturesaura.reg.ICustomItemModel;
import de.ellpeck.naturesaura.reg.IModItem;
import de.ellpeck.naturesaura.reg.ModRegistry;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ItemShovel
extends ShovelItem
implements IModItem,
ICustomItemModel {
    private final String baseName;

    public ItemShovel(String baseName, Tier material, float damage, float speed) {
        super(material, damage, speed, new Item.Properties().m_41491_(NaturesAura.CREATIVE_TAB));
        this.baseName = baseName;
        ModRegistry.ALL_ITEMS.add(this);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        ItemStack stack = player.m_21120_(context.m_43724_());
        BlockPos pos = context.m_8083_();
        BlockState state = level.m_8055_(pos);
        if (!(this != ModItems.INFUSED_IRON_SHOVEL && this != ModItems.DEPTH_SHOVEL || state.m_60734_() != Blocks.f_50493_ && state.m_60734_() != Blocks.f_50195_ || level.m_8055_(pos.m_7494_()).m_60767_() != Material.f_76296_)) {
            level.m_46597_(pos, Blocks.f_50440_.m_49966_());
            float damage = 5.0f;
            if (this == ModItems.DEPTH_SHOVEL && !level.f_46443_) {
                ArrayList<BlockPos> possible = new ArrayList<BlockPos>();
                for (int x = -5; x <= 5; ++x) {
                    for (int z = -5; z <= 5; ++z) {
                        for (int y = -1; y <= 1; ++y) {
                            BlockPos offset = pos.m_7918_(x, y, z);
                            BlockState offState = level.m_8055_(offset);
                            if (offState.m_60734_() != Blocks.f_50493_ && offState.m_60734_() != Blocks.f_50195_ || level.m_8055_(offset.m_7494_()).m_60767_() != Material.f_76296_) continue;
                            possible.add(offset);
                        }
                    }
                }
                for (int i = 0; i < 63 && !possible.isEmpty(); ++i) {
                    level.m_46597_((BlockPos)possible.get(level.f_46441_.m_188503_(possible.size())), Blocks.f_50440_.m_49966_());
                    damage += 0.25f;
                }
            }
            level.m_5594_(player, pos, SoundEvents.f_11991_, SoundSource.BLOCKS, 1.0f, 1.0f);
            stack.m_41622_(Mth.m_14167_((float)damage), (LivingEntity)player, p -> p.m_21190_(context.m_43724_()));
            return InteractionResult.SUCCESS;
        }
        if (this == ModItems.INFUSED_IRON_SHOVEL) {
            boolean flattened = false;
            int range = player.m_6144_() ? 0 : 1;
            for (int x = -range; x <= range; ++x) {
                for (int y = -range; y <= range; ++y) {
                    Direction facing;
                    BlockPos actualPos = pos.m_7918_(x, 0, y);
                    if (!player.m_36204_(actualPos.m_121945_(facing = context.m_43719_()), facing, stack) || facing == Direction.DOWN || level.m_8055_(actualPos.m_7494_()).m_60767_() != Material.f_76296_ || level.m_8055_(actualPos).m_60734_() != Blocks.f_50440_) continue;
                    if (!level.f_46443_) {
                        level.m_7731_(actualPos, Blocks.f_152481_.m_49966_(), 11);
                    }
                    flattened = true;
                }
            }
            if (flattened) {
                level.m_5594_(player, pos, SoundEvents.f_12406_, SoundSource.BLOCKS, 1.0f, 1.0f);
                stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(context.m_43724_()));
                return InteractionResult.SUCCESS;
            }
        }
        if (this == ModItems.SKY_SHOVEL) {
            if (this.m_8102_(stack, state) <= 1.0f) {
                return super.m_6225_(context);
            }
            InteractionHand otherHand = context.m_43724_() == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
            ItemStack other = player.m_21120_(otherHand);
            if (other.m_41619_() || !(other.m_41720_() instanceof BlockItem)) {
                return super.m_6225_(context);
            }
            level.m_7471_(pos, false);
            BlockEntity tile = state.m_155947_() ? level.m_7702_(pos) : null;
            Block.m_49881_((BlockState)state, (Level)level, (BlockPos)pos, (BlockEntity)tile, null, (ItemStack)ItemStack.f_41583_);
            UseOnContext newContext = new UseOnContext(player, otherHand, new BlockHitResult(context.m_43720_(), context.m_43719_(), context.m_8083_(), context.m_43721_()));
            other.m_41661_(newContext);
            stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(context.m_43724_()));
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(context);
    }

    @Override
    public String getBaseName() {
        return this.baseName;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return Helper.makeRechargeProvider(stack, true);
    }

    @Override
    public void generateCustomItemModel(ItemModelGenerator generator) {
        ((ItemModelBuilder)generator.withExistingParent(this.getBaseName(), "item/handheld")).texture("layer0", "item/" + this.getBaseName());
    }
}

