/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.misc;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.ForgeRegistries;

public final class ColoredBlockHelper {
    public static final List<Block> WOOL = ColoredBlockHelper.collectBlocks("wool");
    public static final List<Block> TERRACOTTA = ColoredBlockHelper.collectBlocks("terracotta");
    public static final List<Block> CONCRETE_POWDER = ColoredBlockHelper.collectBlocks("concrete_powder");
    public static final List<Block> CONCRETE = ColoredBlockHelper.collectBlocks("concrete");
    public static final List<Block> GLASS = ColoredBlockHelper.collectBlocks("stained_glass");
    public static final List<Block> GLASS_PANE = ColoredBlockHelper.collectBlocks("stained_glass_pane");
    public static final List<Block> CARPET = ColoredBlockHelper.collectBlocks("carpet");
    public static final List<List<Block>> LISTS = Arrays.asList(WOOL, TERRACOTTA, CONCRETE_POWDER, CONCRETE, GLASS, GLASS_PANE, CARPET);

    private static List<Block> collectBlocks(String name) {
        return Arrays.stream(DyeColor.values()).sorted(Comparator.comparingInt(DyeColor::m_41060_)).map(c -> {
            ResourceLocation loc = new ResourceLocation(c.m_41065_() + "_" + name);
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(loc);
            if (block == null || block == Blocks.f_50016_) {
                throw new IllegalStateException("Couldn't find block with name " + loc);
            }
            return block;
        }).toList();
    }

    public static List<Block> getBlocksContaining(Block block) {
        for (List<Block> list : LISTS) {
            if (!list.contains(block)) continue;
            return list;
        }
        return null;
    }
}

