/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.packet;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.blocks.multi.Multiblocks;
import de.ellpeck.naturesaura.entities.EntityStructureFinder;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.network.NetworkEvent;

public class PacketParticles {
    private float posX;
    private float posY;
    private float posZ;
    private Type type;
    private int[] data;

    public PacketParticles(float posX, float posY, float posZ, Type type, int ... data) {
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.type = type;
        this.data = data;
    }

    private PacketParticles() {
    }

    public static PacketParticles fromBytes(FriendlyByteBuf buf) {
        PacketParticles packet = new PacketParticles();
        packet.posX = buf.readFloat();
        packet.posY = buf.readFloat();
        packet.posZ = buf.readFloat();
        packet.type = Type.values()[buf.readByte()];
        packet.data = new int[buf.readByte()];
        for (int i = 0; i < packet.data.length; ++i) {
            packet.data[i] = buf.readInt();
        }
        return packet;
    }

    public static void toBytes(PacketParticles packet, FriendlyByteBuf buf) {
        buf.writeFloat(packet.posX);
        buf.writeFloat(packet.posY);
        buf.writeFloat(packet.posZ);
        buf.writeByte(packet.type.ordinal());
        buf.writeByte(packet.data.length);
        for (int i : packet.data) {
            buf.writeInt(i);
        }
    }

    public static void onMessage(final PacketParticles message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(new Runnable(){

            @Override
            public void run() {
                ClientLevel level = Minecraft.m_91087_().f_91073_;
                if (level != null) {
                    message.type.action.accept(message, (Level)level);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static enum Type {
        TR_GOLD_POWDER((message, level) -> {
            BlockPos pos = new BlockPos((double)message.posX, (double)message.posY, (double)message.posZ);
            Multiblocks.TREE_RITUAL.forEach(pos, 'G', (dustPos, matcher) -> {
                BlockState state = level.m_8055_(dustPos);
                AABB box = state.m_60808_((BlockGetter)level, dustPos).m_83215_();
                NaturesAuraAPI.instance().spawnMagicParticle((double)dustPos.m_123341_() + box.f_82288_ + (box.f_82291_ - box.f_82288_) * (double)level.f_46441_.m_188501_(), (float)dustPos.m_123342_() + 0.1f, (double)dustPos.m_123343_() + box.f_82290_ + (box.f_82293_ - box.f_82290_) * (double)level.f_46441_.m_188501_(), (float)level.f_46441_.m_188583_() * 0.02f, level.f_46441_.m_188501_() * 0.01f + 0.02f, (float)level.f_46441_.m_188583_() * 0.02f, 16042818, 2.0f, 50, 0.0f, false, true);
                return true;
            });
        }),
        TR_CONSUME_ITEM((message, level) -> {
            for (int i = level.f_46441_.m_188503_(20) + 10; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(message.posX + 0.5f, message.posY + 0.9f, message.posZ + 0.5f, (float)level.f_46441_.m_188583_() * 0.04f, level.f_46441_.m_188501_() * 0.04f, (float)level.f_46441_.m_188583_() * 0.04f, 9030711, 1.5f, 25, 0.0f, false, true);
            }
        }),
        TR_DISAPPEAR((message, level) -> {
            for (int i = level.f_46441_.m_188503_(5) + 3; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(message.posX + level.f_46441_.m_188501_(), message.posY + level.f_46441_.m_188501_(), message.posZ + level.f_46441_.m_188501_(), 0.0, 0.0, 0.0, 0x33FF33, 1.0f, 50, 0.0f, false, true);
            }
        }),
        TR_SPAWN_RESULT((message, level) -> {
            for (int i = level.f_46441_.m_188503_(10) + 10; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(message.posX, message.posY, message.posZ, level.f_46441_.m_188583_() * (double)0.1f, level.f_46441_.m_188583_() * (double)0.1f, level.f_46441_.m_188583_() * (double)0.1f, 9030711, 2.0f, 100, 0.0f, true, true);
            }
        }),
        ALTAR_CONVERSION((message, level) -> {
            int color = message.data[0];
            for (int i = level.f_46441_.m_188503_(5) + 2; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(message.posX + 0.25f + level.f_46441_.m_188501_() * 0.5f, message.posY + 0.9f + 0.25f * level.f_46441_.m_188501_(), message.posZ + 0.25f + level.f_46441_.m_188501_() * 0.5f, level.f_46441_.m_188583_() * (double)0.02f, level.f_46441_.m_188501_() * 0.02f, level.f_46441_.m_188583_() * (double)0.02f, color, level.f_46441_.m_188501_() * 1.5f + 0.75f, 20, 0.0f, false, true);
            }
        }),
        POTION_GEN((message, level) -> {
            int color = message.data[0];
            boolean releaseAura = message.data[1] > 0;
            for (int i = level.f_46441_.m_188503_(5) + 5; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(message.posX + level.f_46441_.m_188501_(), message.posY + 1.1f, message.posZ + level.f_46441_.m_188501_(), level.f_46441_.m_188583_() * (double)0.01f, level.f_46441_.m_188501_() * 0.1f, level.f_46441_.m_188583_() * (double)0.01f, color, 2.0f + level.f_46441_.m_188501_(), 40, 0.0f, true, true);
                if (!releaseAura) continue;
                for (int x = -1; x <= 1; x += 2) {
                    for (int z = -1; z <= 1; z += 2) {
                        NaturesAuraAPI.instance().spawnMagicParticle(message.posX + (float)(x * 3) + 0.5f, (double)message.posY + 2.5, message.posZ + (float)(z * 3) + 0.5f, level.f_46441_.m_188583_() * (double)0.02f, level.f_46441_.m_188501_() * 0.04f, level.f_46441_.m_188583_() * (double)0.02f, 14038028, 1.0f + level.f_46441_.m_188501_() * 2.0f, 75, 0.0f, true, true);
                    }
                }
            }
        }),
        PLANT_BOOST((message, level) -> {
            for (int i = level.f_46441_.m_188503_(20) + 15; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(message.posX + level.f_46441_.m_188501_(), message.posY + 0.25f + level.f_46441_.m_188501_() * 0.5f, message.posZ + level.f_46441_.m_188501_(), 0.0, level.f_46441_.m_188501_() * 0.02f, 0.0, 6081584, 1.0f + level.f_46441_.m_188501_() * 2.0f, 50, 0.0f, false, true);
            }
        }),
        FLOWER_GEN_CONSUME((message, level) -> {
            int color = message.data[0];
            for (int i = level.f_46441_.m_188503_(10) + 10; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(message.posX + 0.25f + level.f_46441_.m_188501_() * 0.5f, message.posY + 0.25f + level.f_46441_.m_188501_() * 0.5f, message.posZ + 0.25f + level.f_46441_.m_188501_() * 0.5f, level.f_46441_.m_188583_() * (double)0.02f, level.f_46441_.m_188583_() * (double)0.02f, level.f_46441_.m_188583_() * (double)0.02f, color, level.f_46441_.m_188501_() * 2.0f + 1.0f, 25, 0.0f, false, true);
            }
        }),
        FLOWER_GEN_AURA_CREATION((message, level) -> {
            for (int i = level.f_46441_.m_188503_(10) + 5; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(message.posX + 0.25f + level.f_46441_.m_188501_() * 0.5f, message.posY + 1.01f, message.posZ + 0.25f + level.f_46441_.m_188501_() * 0.5f, level.f_46441_.m_188583_() * (double)0.01f, level.f_46441_.m_188501_() * 0.04f + 0.02f, level.f_46441_.m_188583_() * (double)0.01f, 6081584, 1.0f + level.f_46441_.m_188501_() * 1.5f, 40, 0.0f, false, true);
            }
        }),
        PLACER_PLACING((message, level) -> {
            for (int i = level.f_46441_.m_188503_(20) + 20; i >= 0; --i) {
                float x;
                boolean side = level.f_46441_.m_188499_();
                float f = side ? level.f_46441_.m_188501_() : (x = level.f_46441_.m_188499_() ? 1.1f : -0.1f);
                float z = !side ? level.f_46441_.m_188501_() : (level.f_46441_.m_188499_() ? 1.1f : -0.1f);
                NaturesAuraAPI.instance().spawnMagicParticle(message.posX + x, message.posY + 0.1f + level.f_46441_.m_188501_() * 0.98f, message.posZ + z, 0.0, 0.0, 0.0, 11369015, level.f_46441_.m_188501_() + 1.0f, 50, 0.0f, true, true);
            }
        }),
        HOPPER_UPGRADE((message, level) -> {
            for (int i = level.f_46441_.m_188503_(20) + 10; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(message.posX, message.posY + 0.45f, message.posZ, level.f_46441_.m_188583_() * (double)0.015f, level.f_46441_.m_188583_() * (double)0.015f, level.f_46441_.m_188583_() * (double)0.015f, 14542847, level.f_46441_.m_188501_() + 1.0f, 30, -0.06f, true, true);
            }
        }),
        SHOCKWAVE_CREATOR((message, level) -> {
            for (int i = 0; i < 360; i += 2) {
                double rad = Math.toRadians(i);
                NaturesAuraAPI.instance().spawnMagicParticle(message.posX, message.posY + 0.01f, message.posZ, (float)Math.sin(rad) * 0.65f, 0.0, (float)Math.cos(rad) * 0.65f, 9509639, 3.0f, 10, 0.0f, false, true);
            }
        }),
        OAK_GENERATOR((message, level) -> {
            int i;
            int sapX = message.data[0];
            int sapY = message.data[1];
            int sapZ = message.data[2];
            boolean releaseAura = message.data[3] > 0;
            for (i = level.f_46441_.m_188503_(20) + 10; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnParticleStream((float)sapX + 0.5f + (float)level.f_46441_.m_188583_() * 3.0f, (float)sapY + 0.5f + level.f_46441_.m_188501_() * 4.0f, (float)sapZ + 0.5f + (float)level.f_46441_.m_188583_() * 3.0f, message.posX + 0.5f, message.posY + 0.5f, message.posZ + 0.5f, 0.6f, BiomeColors.m_108793_((BlockAndTintGetter)level, (BlockPos)new BlockPos(sapX, sapY, sapZ)), 1.5f);
            }
            if (releaseAura) {
                for (i = level.f_46441_.m_188503_(10) + 10; i >= 0; --i) {
                    NaturesAuraAPI.instance().spawnMagicParticle(message.posX + 0.25f + level.f_46441_.m_188501_() * 0.5f, message.posY + 1.01f, message.posZ + 0.25f + level.f_46441_.m_188501_() * 0.5f, level.f_46441_.m_188583_() * (double)0.03f, level.f_46441_.m_188501_() * 0.04f + 0.04f, level.f_46441_.m_188583_() * (double)0.03f, 6081584, 1.0f + level.f_46441_.m_188501_() * 1.5f, 60, 0.0f, false, true);
                }
            }
        }),
        OFFERING_TABLE((message, level) -> {
            int i;
            int genX = message.data[0];
            int genY = message.data[1];
            int genZ = message.data[2];
            for (i = level.f_46441_.m_188503_(20) + 10; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(message.posX, message.posY + 0.5f, message.posZ, level.f_46441_.m_188583_() * (double)0.02f, level.f_46441_.m_188501_() * 0.25f, level.f_46441_.m_188583_() * (double)0.02f, 0xFFADFD, 1.5f, 40, 0.0f, false, true);
            }
            for (i = level.f_46441_.m_188503_(50) + 30; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle((double)((float)genX + 0.5f) + level.f_46441_.m_188583_() * 2.5, (float)genY + 0.1f, (double)((float)genZ + 0.5f) + level.f_46441_.m_188583_() * 2.5, level.f_46441_.m_188583_() * (double)0.01f, level.f_46441_.m_188501_() * 0.01f, level.f_46441_.m_188583_() * (double)0.01f, 13886719, 1.5f, 150, 0.0f, false, true);
            }
        }),
        PICKUP_STOPPER((message, level) -> NaturesAuraAPI.instance().spawnMagicParticle(message.posX, message.posY + 0.4f, message.posZ, level.f_46441_.m_188583_() * (double)0.005f, level.f_46441_.m_188501_() * 0.005f, level.f_46441_.m_188583_() * (double)0.005f, 13381910, 1.5f, 40, 0.0f, false, true)),
        SPAWN_LAMP((message, level) -> {
            for (int i = level.f_46441_.m_188503_(5) + 5; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(message.posX + 0.3f + level.f_46441_.m_188501_() * 0.4f, message.posY + 0.15f + level.f_46441_.m_188501_() * 0.5f, message.posZ + 0.3f + level.f_46441_.m_188501_() * 0.4f, 0.0, 0.0, 0.0, 16032066, 1.0f, 30, 0.0f, false, true);
            }
        }),
        ANIMAL_GEN_CREATE((message, level) -> {
            for (int i = level.f_46441_.m_188503_(5) + 5; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(message.posX + 0.25f + level.f_46441_.m_188501_() * 0.5f, message.posY + 1.01f, message.posZ + 0.25f + level.f_46441_.m_188501_() * 0.5f, level.f_46441_.m_188583_() * (double)0.01f, level.f_46441_.m_188501_() * 0.04f + 0.02f, level.f_46441_.m_188583_() * (double)0.01f, 13710088, 1.0f + level.f_46441_.m_188501_() * 1.5f, 40, 0.0f, false, true);
            }
        }),
        ANIMAL_GEN_CONSUME((message, level) -> {
            int i;
            boolean child = message.data[0] > 0;
            float height = (float)message.data[1] / 10.0f;
            int genX = message.data[2];
            int genY = message.data[3];
            int genZ = message.data[4];
            int n = i = child ? level.f_46441_.m_188503_(10) + 10 : level.f_46441_.m_188503_(20) + 20;
            while (i >= 0) {
                NaturesAuraAPI.instance().spawnMagicParticle((double)message.posX + level.f_46441_.m_188583_() * 0.25, (double)(message.posY + height * 0.75f) + level.f_46441_.m_188583_() * 0.25, (double)message.posZ + level.f_46441_.m_188583_() * 0.25, level.f_46441_.m_188583_() * (double)0.01f, level.f_46441_.m_188501_() * 0.01f, level.f_46441_.m_188583_() * (double)0.01f, 4388040, level.f_46441_.m_188501_() * (child ? 0.5f : 2.0f) + 1.0f, level.f_46441_.m_188503_(30) + 40, 0.0f, true, true);
                --i;
            }
            NaturesAuraAPI.instance().spawnParticleStream(message.posX, message.posY + height * 0.75f, message.posZ, (float)genX + 0.5f, (float)genY + 0.5f, (float)genZ + 0.5f, 0.15f, 4310260, child ? 1.5f : 3.0f);
        }),
        END_FLOWER_DECAY((message, level) -> {
            int color = message.data[0];
            for (int i = level.f_46441_.m_188503_(10) + 20; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(message.posX + level.f_46441_.m_188501_(), message.posY + level.f_46441_.m_188501_(), message.posZ + level.f_46441_.m_188501_(), level.f_46441_.m_188583_() * (double)0.01f, level.f_46441_.m_188501_() * 0.01f, level.f_46441_.m_188583_() * (double)0.01f, color, 1.5f, 80, 0.0f, true, true);
            }
        }),
        ANIMAL_SPAWNER((message, level) -> {
            for (int i = level.f_46441_.m_188503_(20) + 10; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(message.posX, message.posY + 0.5f, message.posZ, level.f_46441_.m_188583_() * (double)0.02f, level.f_46441_.m_188501_() * 0.02f, level.f_46441_.m_188583_() * (double)0.02f, 1488818, 1.5f, 40, 0.0f, false, true);
            }
        }),
        RF_CONVERTER((message, level) -> {
            for (int i = level.f_46441_.m_188503_(5) + 2; i >= 0; --i) {
                Multiblocks.RF_CONVERTER.forEach(new BlockPos((double)message.posX, (double)message.posY, (double)message.posZ), 'R', (blockPos, matcher) -> {
                    if (level.f_46441_.m_188501_() < 0.35f) {
                        NaturesAuraAPI.instance().spawnParticleStream((float)blockPos.m_123341_() + level.f_46441_.m_188501_(), (float)blockPos.m_123342_() + level.f_46441_.m_188501_(), (float)blockPos.m_123343_() + level.f_46441_.m_188501_(), message.posX + level.f_46441_.m_188501_(), message.posY + level.f_46441_.m_188501_(), message.posZ + level.f_46441_.m_188501_(), 0.05f, 16718341, 1.5f);
                    }
                    return true;
                });
            }
        }),
        END_FLOWER_CONSUME((message, level) -> {
            int color = message.data[0];
            for (int i = level.f_46441_.m_188503_(20) + 10; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(message.posX, message.posY + 0.5f, message.posZ, level.f_46441_.m_188583_() * (double)0.01f, level.f_46441_.m_188501_() * 0.01f, level.f_46441_.m_188583_() * (double)0.01f, color, 1.5f, 40, 0.0f, false, true);
            }
        }),
        MOVER_CART((message, level) -> {
            float motionX = (float)message.data[0] / 100.0f;
            float motionY = (float)message.data[1] / 100.0f;
            float motionZ = (float)message.data[2] / 100.0f;
            for (int i = level.f_46441_.m_188503_(60) + 30; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle((double)message.posX + level.f_46441_.m_188583_() * 10.0, (double)message.posY + level.f_46441_.m_188583_() * 10.0, (double)message.posZ + level.f_46441_.m_188583_() * 10.0, motionX * 0.2f, motionY * 0.2f, motionZ * 0.2f, IAuraType.forLevel(level).getColor(), 2.0f, 30, 0.0f, false, true);
            }
        }),
        MOSS_GENERATOR((message, level) -> {
            int i;
            for (i = level.f_46441_.m_188503_(30) + 30; i >= 0; --i) {
                float y;
                float x;
                int side = level.f_46441_.m_188503_(3);
                float f = side != 0 ? level.f_46441_.m_188501_() : (x = level.f_46441_.m_188499_() ? 1.1f : -0.1f);
                float f2 = side != 1 ? level.f_46441_.m_188501_() : (y = level.f_46441_.m_188499_() ? 1.1f : -0.1f);
                float z = side != 2 ? level.f_46441_.m_188501_() : (level.f_46441_.m_188499_() ? 1.1f : -0.1f);
                NaturesAuraAPI.instance().spawnMagicParticle(message.posX + x, message.posY + y, message.posZ + z, 0.0, 0.0, 0.0, 1592333, level.f_46441_.m_188501_() + 1.0f, 30, 0.0f, true, true);
            }
            for (i = level.f_46441_.m_188503_(20) + 10; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(message.posX + level.f_46441_.m_188501_(), message.posY + 1.0f, message.posZ + level.f_46441_.m_188501_(), level.f_46441_.m_188583_() * (double)0.01f, level.f_46441_.m_188501_() * 0.04f + 0.02f, level.f_46441_.m_188583_() * (double)0.01f, 6081584, 1.0f + level.f_46441_.m_188501_() * 1.5f, 40, 0.0f, true, true);
            }
        }),
        FIREWORK_GEN((message, level) -> {
            int goalX = message.data[0];
            int goalY = message.data[1];
            int goalZ = message.data[2];
            NaturesAuraAPI.instance().setParticleSpawnRange(64);
            for (int i = level.f_46441_.m_188503_(30) + 30; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnParticleStream(message.posX + (float)level.f_46441_.m_188583_(), message.posY + (float)level.f_46441_.m_188583_(), message.posZ + (float)level.f_46441_.m_188583_(), (float)goalX + 0.25f + level.f_46441_.m_188501_() * 0.5f, (float)goalY + 0.25f + level.f_46441_.m_188501_() * 0.5f, (float)goalZ + 0.25f + level.f_46441_.m_188501_() * 0.5f, 0.65f, message.data[3 + level.f_46441_.m_188503_(message.data.length - 3)], 1.0f);
            }
            NaturesAuraAPI.instance().setParticleSpawnRange(32);
        }),
        DIMENSION_RAIL((message, level) -> {
            float width = (float)message.data[0] / 100.0f;
            float height = (float)message.data[1] / 100.0f;
            float depth = (float)message.data[2] / 100.0f;
            for (int i = level.f_46441_.m_188503_(100) + 50; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(message.posX + level.f_46441_.m_188501_() * width, message.posY + level.f_46441_.m_188501_() * height, message.posZ + level.f_46441_.m_188501_() * depth, 0.0, 0.0, 0.0, 14028031, 1.0f + level.f_46441_.m_188501_(), 60, 0.0f, false, true);
            }
        }),
        PROJECTILE_GEN((message, level) -> {
            int i;
            int x = message.data[0];
            int y = message.data[1];
            int z = message.data[2];
            for (i = level.f_46441_.m_188503_(10) + 5; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle((float)x + 0.25f + level.f_46441_.m_188501_() * 0.5f, (float)y + 1.01f, (float)z + 0.25f + level.f_46441_.m_188501_() * 0.5f, level.f_46441_.m_188583_() * (double)0.01f, level.f_46441_.m_188501_() * 0.04f + 0.02f, level.f_46441_.m_188583_() * (double)0.01f, 6081584, 1.0f + level.f_46441_.m_188501_() * 1.5f, 40, 0.0f, false, true);
            }
            for (i = level.f_46441_.m_188503_(10) + 10; i >= 0; --i) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123815_, (double)message.posX, (double)message.posY, (double)message.posZ, level.f_46441_.m_188583_() * (double)0.03f, level.f_46441_.m_188583_() * (double)0.03f, level.f_46441_.m_188583_() * (double)0.03f);
            }
        }),
        BLAST_FURNACE_BOOSTER((message, level) -> {
            boolean worked = message.data[0] > 0;
            for (int i = level.f_46441_.m_188503_(10) + 5; i >= 0; --i) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123777_, (double)(message.posX + 0.3125f + (float)level.f_46441_.m_188503_(6) / 16.0f), (double)(message.posY + 0.6f), (double)(message.posZ + 0.3125f + (float)level.f_46441_.m_188503_(6) / 16.0f), level.f_46441_.m_188583_() * (double)0.005f, (double)(level.f_46441_.m_188501_() * 0.02f + 0.01f), level.f_46441_.m_188583_() * (double)0.005f);
            }
            if (worked) {
                BlockPos pos = new BlockPos((double)message.posX, (double)message.posY, (double)message.posZ);
                int color = IAuraChunk.getAuraChunk(level, pos).getType().getColor();
                for (int i = level.f_46441_.m_188503_(10) + 10; i >= 0; --i) {
                    NaturesAuraAPI.instance().spawnParticleStream(message.posX + (float)level.f_46441_.m_188583_() * 5.0f, message.posY + level.f_46441_.m_188501_() * 5.0f, message.posZ + (float)level.f_46441_.m_188583_() * 5.0f, message.posX + 0.5f, message.posY + 0.5f, message.posZ + 0.5f, 0.25f, color, 0.5f + level.f_46441_.m_188501_());
                }
            }
        }),
        ANIMAL_CONTAINER((message, level) -> {
            for (int i = level.f_46441_.m_188503_(2) + 1; i > 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle((double)message.posX + level.f_46441_.m_188583_() * (double)0.15f, message.posY - level.f_46441_.m_188501_() * 0.5f, (double)message.posZ + level.f_46441_.m_188583_() * (double)0.15f, 0.0, 0.0, 0.0, 4385269, 1.0f + level.f_46441_.m_188501_() * 2.0f, 40, 0.0f, false, true);
            }
        }),
        SNOW_CREATOR((message, level) -> {
            BlockPos pos = new BlockPos((double)message.posX, (double)message.posY, (double)message.posZ);
            int color = IAuraChunk.getAuraChunk(level, pos).getType().getColor();
            for (int i = level.f_46441_.m_188503_(3) + 1; i > 0; --i) {
                NaturesAuraAPI.instance().spawnParticleStream(message.posX + (float)level.f_46441_.m_188583_() * 5.0f, message.posY + level.f_46441_.m_188501_() * 5.0f, message.posZ + (float)level.f_46441_.m_188583_() * 5.0f, message.posX + 0.5f, message.posY + 0.5f, message.posZ + 0.5f, 0.25f, color, 0.5f + level.f_46441_.m_188501_());
            }
        }),
        CHORUS_GENERATOR((message, level) -> {
            int i;
            int chorusX = message.data[0];
            int chorusY = message.data[1];
            int chorusZ = message.data[2];
            for (i = level.f_46441_.m_188503_(5) + 3; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle((float)chorusX + level.f_46441_.m_188501_(), (float)chorusY + level.f_46441_.m_188501_(), (float)chorusZ + level.f_46441_.m_188501_(), 0.0, 0.0, 0.0, 12258275, 1.0f + level.f_46441_.m_188501_(), 50, 0.0f, false, true);
            }
            for (i = level.f_46441_.m_188503_(5) + 5; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(message.posX + 0.25f + level.f_46441_.m_188501_() * 0.5f, message.posY + 1.01f, message.posZ + 0.25f + level.f_46441_.m_188501_() * 0.5f, level.f_46441_.m_188583_() * (double)0.01f, level.f_46441_.m_188501_() * 0.04f + 0.02f, level.f_46441_.m_188583_() * (double)0.01f, IAuraType.forLevel(level).getColor(), 1.0f + level.f_46441_.m_188501_() * 1.5f, 40, 0.0f, false, true);
            }
        }),
        TIMER_RESET((message, level) -> {
            int color = message.data[0];
            for (int i = level.f_46441_.m_188503_(10) + 15; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(message.posX + 0.3125f + level.f_46441_.m_188501_() * 6.0f / 16.0f, message.posY + 0.125f + level.f_46441_.m_188501_() * 8.0f / 16.0f, message.posZ + 0.3125f + level.f_46441_.m_188501_() * 6.0f / 16.0f, 0.0, 0.0, 0.0, color, 2.0f, 40 + level.f_46441_.m_188503_(20), 0.0f, false, true);
            }
        }),
        STRUCTURE_FINDER((message, level) -> {
            EntityStructureFinder entity = (EntityStructureFinder)level.m_6815_(message.data[0]);
            LevelRenderer renderer = Minecraft.m_91087_().f_91060_;
            double d0 = (double)message.posX + 0.5;
            double d13 = message.posY;
            double d18 = (double)message.posZ + 0.5;
            for (int j2 = 0; j2 < 8; ++j2) {
                renderer.m_109743_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, entity.m_7846_()), false, d0, d13, d18, level.f_46441_.m_188583_() * 0.15, level.f_46441_.m_188500_() * 0.2, level.f_46441_.m_188583_() * 0.15);
            }
            int color = (Integer)entity.m_20088_().m_135370_(EntityStructureFinder.COLOR);
            for (double d24 = 0.0; d24 < Math.PI * 2; d24 += 0.15707963267948966) {
                NaturesAuraAPI.instance().spawnMagicParticle(d0 + Math.cos(d24) * 5.0, d13 - 0.4, d18 + Math.sin(d24) * 5.0, Math.cos(d24) * -2.0, 0.0, Math.sin(d24) * -2.0, color, 2.0f, 60, 0.0f, false, true);
                NaturesAuraAPI.instance().spawnMagicParticle(d0 + Math.cos(d24) * 5.0, d13 - 0.4, d18 + Math.sin(d24) * 5.0, Math.cos(d24) * -2.5, 0.0, Math.sin(d24) * -2.5, color, 2.0f, 60, 0.0f, false, true);
            }
        }),
        SLIME_SPLIT_GEN_CREATE((message, level) -> {
            for (int i = level.f_46441_.m_188503_(5) + 5; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(message.posX + 0.25f + level.f_46441_.m_188501_() * 0.5f, message.posY + 1.01f, message.posZ + 0.25f + level.f_46441_.m_188501_() * 0.5f, level.f_46441_.m_188583_() * (double)0.01f, level.f_46441_.m_188501_() * 0.04f + 0.02f, level.f_46441_.m_188583_() * (double)0.01f, message.data[0], 1.0f + level.f_46441_.m_188501_() * 1.5f, 40, 0.0f, false, true);
            }
        }),
        SLIME_SPLIT_GEN_START((message, level) -> {
            int i;
            int x = message.data[0];
            int y = message.data[1];
            int z = message.data[2];
            int color = message.data[3];
            for (i = level.f_46441_.m_188503_(10) + 5; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(message.posX + (float)level.f_46441_.m_188583_() * 0.5f, message.posY + (float)level.f_46441_.m_188583_() * 0.5f, message.posZ + (float)level.f_46441_.m_188583_() * 0.5f, level.f_46441_.m_188583_() * (double)0.02f, level.f_46441_.m_188501_() * 0.04f + 0.02f, level.f_46441_.m_188583_() * (double)0.02f, color, level.f_46441_.m_188501_() + 1.0f, level.f_46441_.m_188503_(20) + 20, 0.0f, false, true);
            }
            for (i = level.f_46441_.m_188503_(10) + 5; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnParticleStream(message.posX + (float)level.f_46441_.m_188583_() * 0.5f, message.posY + (float)level.f_46441_.m_188583_() * 0.5f, message.posZ + (float)level.f_46441_.m_188583_() * 0.5f, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, 0.2f, color, level.f_46441_.m_188501_() + 1.0f);
            }
        }),
        PET_REVIVER((message, level) -> {
            for (int i = level.f_46441_.m_188503_(50) + 150; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(message.posX + (float)level.f_46441_.m_188583_() * 0.4f, message.posY + (float)level.f_46441_.m_188583_() * 0.4f, message.posZ + (float)level.f_46441_.m_188583_() * 0.4f, level.f_46441_.m_188583_() * (double)0.002f, level.f_46441_.m_188501_() * 0.001f + 0.002f, level.f_46441_.m_188583_() * (double)0.002f, message.data[0], level.f_46441_.m_188501_() * 2.0f + 1.0f, level.f_46441_.m_188503_(50) + 50, 0.0f, false, true);
            }
        });

        public final BiConsumer<PacketParticles, Level> action;

        private Type(BiConsumer<PacketParticles, Level> action) {
            this.action = action;
        }
    }
}

