/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.nochatreports.config;

import com.aizistral.nochatreports.NoChatReports;
import com.aizistral.nochatreports.config.JSONConfig;
import com.aizistral.nochatreports.config.NCRConfigClient;
import com.aizistral.nochatreports.config.NCRConfigCommon;
import com.aizistral.nochatreports.config.NCRConfigEncryption;
import com.aizistral.nochatreports.config.NCRServerWhitelist;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.Supplier;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLEnvironment;

public final class NCRConfig {
    private static NCRConfigCommon common = null;
    private static NCRConfigClient client = null;
    private static NCRServerWhitelist whitelist = null;
    private static NCRConfigEncryption encryption = null;

    private NCRConfig() {
        throw new IllegalStateException("Can't touch this");
    }

    public static NCRConfigCommon getCommon() {
        return NCRConfig.checkLoaded(() -> common);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static NCRConfigClient getClient() {
        return NCRConfig.checkLoaded(() -> client);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static NCRServerWhitelist getServerWhitelist() {
        return NCRConfig.checkLoaded(() -> whitelist);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static NCRConfigEncryption getEncryption() {
        return NCRConfig.checkLoaded(() -> encryption);
    }

    private static <T extends JSONConfig> T checkLoaded(Supplier<T> config) {
        if (config.get() == null) {
            NCRConfig.load();
        }
        return (T)((JSONConfig)config.get());
    }

    public static void load() {
        common = JSONConfig.loadConfig(NCRConfigCommon.class, NCRConfigCommon::new, "NoChatReports/NCR-Common.json");
        if (FMLEnvironment.dist == Dist.CLIENT) {
            client = JSONConfig.loadConfig(NCRConfigClient.class, NCRConfigClient::new, "NoChatReports/NCR-Client.json");
            whitelist = JSONConfig.loadConfig(NCRServerWhitelist.class, NCRServerWhitelist::new, "NoChatReports/NCR-ServerWhitelist.json");
            encryption = JSONConfig.loadConfig(NCRConfigEncryption.class, NCRConfigEncryption::new, "NoChatReports/NCR-Encryption.json");
        }
        NCRConfig.save();
    }

    public static void save() {
        NCRConfig.checkLoaded(() -> common).saveFile();
        if (FMLEnvironment.dist == Dist.CLIENT) {
            NCRConfig.checkLoaded(() -> client).saveFile();
            NCRConfig.checkLoaded(() -> whitelist).saveFile();
            NCRConfig.checkLoaded(() -> encryption).saveFile();
        }
        Path readme = JSONConfig.CONFIG_DIR.resolve("NoChatReports/README.md");
        try {
            Files.writeString(readme, (CharSequence)"# No Chat Reports\nYou can find updated documentation of configuration files on the wiki:\nhttps://github.com/Aizistral-Studios/No-Chat-Reports/wiki/Configuration-Files\n", StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (Exception ex) {
            NoChatReports.LOGGER.fatal("Could not write README file: {}", (Object)readme);
            throw new RuntimeException(ex);
        }
    }
}

