/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.nochatreports.config;

import com.aizistral.nochatreports.config.JSONConfig;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.multiplayer.resolver.ServerAddress;

public final class NCRConfigClient
extends JSONConfig {
    protected static final String FILE_NAME = "NoChatReports/NCR-Client.json";
    protected boolean demandOnServer = false;
    protected boolean showServerSafety = true;
    protected boolean hideRedChatIndicators = true;
    protected boolean hideYellowChatIndicators = true;
    protected boolean hideGrayChatIndicators = true;
    protected boolean hideWarningToast = true;
    protected boolean alwaysHideReportButton = false;
    protected boolean disableTelemetry = true;
    protected boolean showReloadButton = true;
    protected boolean whitelistAllServers = false;
    protected boolean verifiedIconEnabled = true;
    protected boolean showNCRButton = true;
    protected boolean enableMod = true;
    protected boolean skipRealmsWarning = false;
    protected int verifiedIconOffsetX = 0;
    protected int verifiedIconOffsetY = 0;
    protected int reconnectAwaitSeconds = 4;
    protected int postDisconnectAwaitSeconds = 10;
    protected int signingCheckDelaySeconds = 43200;
    protected Map<String, Long> serverSigningChecks = new HashMap<String, Long>();

    protected NCRConfigClient() {
        super(FILE_NAME);
    }

    @Override
    public NCRConfigClient getDefault() {
        return new NCRConfigClient();
    }

    public void toggleMod() {
        this.enableMod = !this.enableMod;
    }

    public boolean demandOnServer() {
        return this.demandOnServer;
    }

    public boolean showServerSafety() {
        return this.showServerSafety;
    }

    public boolean hideRedChatIndicators() {
        return this.hideRedChatIndicators;
    }

    public boolean hideYellowChatIndicators() {
        return this.hideYellowChatIndicators;
    }

    public boolean hideGrayChatIndicators() {
        return this.hideGrayChatIndicators;
    }

    public boolean hideWarningToast() {
        return this.hideWarningToast;
    }

    public boolean alwaysHideReportButton() {
        return this.alwaysHideReportButton;
    }

    public boolean disableTelemetry() {
        return this.disableTelemetry;
    }

    public boolean showReloadButton() {
        return this.showReloadButton;
    }

    public boolean whitelistAllServers() {
        return this.whitelistAllServers;
    }

    public boolean verifiedIconEnabled() {
        return this.verifiedIconEnabled;
    }

    public int getVerifiedIconOffsetX() {
        return 16 + this.verifiedIconOffsetX;
    }

    public int getVerifiedIconOffsetY() {
        return 12 + this.verifiedIconOffsetY;
    }

    public boolean showNCRButton() {
        return this.showNCRButton;
    }

    public boolean enableMod() {
        return this.enableMod;
    }

    public int getReconnectAwaitSeconds() {
        return this.reconnectAwaitSeconds;
    }

    public int getPostDisconnectAwaitSeconds() {
        return this.postDisconnectAwaitSeconds;
    }

    public boolean skipRealmsWarning() {
        return this.skipRealmsWarning;
    }

    public void setSkipRealmsWarning(boolean skipRealmsWarning) {
        this.skipRealmsWarning = skipRealmsWarning;
    }

    public boolean doSigningCheck(ServerAddress serverAddress) {
        String server = serverAddress.m_171863_() + ":" + serverAddress.m_171866_();
        if (!this.serverSigningChecks.containsKey(server)) {
            return true;
        }
        return Instant.now().getEpochSecond() - this.serverSigningChecks.get(server) >= (long)this.signingCheckDelaySeconds;
    }

    public void updateSigningCheck(ServerAddress serverAddress) {
        String server = serverAddress.m_171863_() + ":" + serverAddress.m_171866_();
        this.serverSigningChecks.put(server, Instant.now().getEpochSecond());
        this.saveFile();
    }
}

