/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.nochatreports.mixins.client;

import com.aizistral.nochatreports.config.NCRConfig;
import com.aizistral.nochatreports.core.ServerSafetyState;
import com.mojang.authlib.yggdrasil.response.KeyPairResponse;
import java.util.Optional;
import net.minecraft.client.multiplayer.ProfileKeyPairManager;
import net.minecraft.util.Signer;
import net.minecraft.world.entity.player.ProfilePublicKey;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Group;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ProfileKeyPairManager.class})
public class MixinProfileKeyPairManager {
    @Inject(method={"profilePublicKey"}, at={@At(value="HEAD")}, cancellable=true)
    private void onProfilePublicKey(CallbackInfoReturnable<Optional<ProfilePublicKey>> info) {
        if (!NCRConfig.getClient().enableMod()) {
            return;
        }
        if (!ServerSafetyState.allowsUnsafeServer()) {
            info.setReturnValue(Optional.empty());
        }
    }

    @Inject(method={"parsePublicKey"}, at={@At(value="HEAD")}, cancellable=true)
    @Group(min=1, max=2)
    private static void onParsePublicKey(KeyPairResponse response, CallbackInfoReturnable<ProfilePublicKey.Data> info) {
        if (!NCRConfig.getClient().enableMod()) {
            return;
        }
        if (!ServerSafetyState.allowsUnsafeServer()) {
            info.setReturnValue(null);
        }
    }

    @Inject(method={"profilePublicKeyData", "method_43784"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    @Group(min=1, max=2)
    private void onProfilePublicKeyData(CallbackInfoReturnable<Optional<ProfilePublicKey.Data>> info) {
        if (!NCRConfig.getClient().enableMod()) {
            return;
        }
        if (!ServerSafetyState.allowsUnsafeServer()) {
            info.setReturnValue(Optional.empty());
        }
    }

    @Inject(method={"signer"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSigner(CallbackInfoReturnable<Optional<Signer>> info) {
        if (!NCRConfig.getClient().enableMod()) {
            return;
        }
        if (!ServerSafetyState.allowsUnsafeServer()) {
            info.setReturnValue(null);
        }
    }
}

