/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.nochatreports.mixins.server;

import com.aizistral.nochatreports.NoChatReports;
import com.aizistral.nochatreports.config.NCRConfig;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerChatHeaderPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerChatPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.server.network.ServerPlayerConnection;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerGamePacketListenerImpl.class})
public abstract class MixinServerGamePacketListenerImpl
implements ServerPlayerConnection {
    @Shadow
    public ServerPlayer f_9743_;

    @Inject(method={"send(Lnet/minecraft/network/protocol/Packet;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSend(Packet<?> packet, CallbackInfo info) {
        ClientboundPlayerChatPacket chat;
        if (NCRConfig.getCommon().enableDebugLog() && packet instanceof ClientboundPlayerChatPacket) {
            chat = (ClientboundPlayerChatPacket)packet;
            NoChatReports.LOGGER.info("Sending message: {}", (Object)chat.f_240869_().m_237220_());
        }
        if (NCRConfig.getCommon().convertToGameMessage()) {
            if (packet instanceof ClientboundPlayerChatHeaderPacket) {
                info.cancel();
            } else if (packet instanceof ClientboundPlayerChatPacket) {
                chat = (ClientboundPlayerChatPacket)packet;
                packet = new ClientboundSystemChatPacket(((ChatType.Bound)chat.f_240897_().m_242652_(this.f_9743_.f_19853_.m_5962_()).get()).m_240977_(chat.f_240869_().m_237220_()), false);
                info.cancel();
                this.m_9829_((Packet)packet);
            }
        }
    }

    @Inject(method={"send(Lnet/minecraft/network/protocol/Packet;Lnet/minecraft/network/PacketSendListener;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSend(Packet<?> packet, @Nullable PacketSendListener packetSendListener, CallbackInfo info) {
        ClientboundPlayerChatPacket chat;
        if (NCRConfig.getCommon().enableDebugLog() && packet instanceof ClientboundPlayerChatPacket) {
            chat = (ClientboundPlayerChatPacket)packet;
            NoChatReports.LOGGER.info("Sending message: {}", (Object)chat.f_240869_().m_237220_());
        }
        if (NCRConfig.getCommon().convertToGameMessage()) {
            if (packet instanceof ClientboundPlayerChatHeaderPacket) {
                info.cancel();
            } else if (packet instanceof ClientboundPlayerChatPacket) {
                chat = (ClientboundPlayerChatPacket)packet;
                if (packetSendListener != null) {
                    info.cancel();
                    ((ServerGamePacketListenerImpl)this).m_9829_((Packet)chat);
                }
            }
        }
    }
}

