/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.coupling.coupler;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.railwayteam.railways.content.coupling.CustomTrackOverlayRendering;
import com.railwayteam.railways.content.coupling.coupler.TrackCoupler;
import com.railwayteam.railways.content.coupling.coupler.TrackCouplerBlockEntity;
import com.railwayteam.railways.registry.CRBlockPartials;
import com.simibubi.create.content.trains.graph.TrackEdge;
import com.simibubi.create.content.trains.graph.TrackGraphLocation;
import com.simibubi.create.content.trains.graph.TrackNodeLocation;
import com.simibubi.create.content.trains.signal.TrackEdgePoint;
import com.simibubi.create.content.trains.track.ITrackBlock;
import com.simibubi.create.content.trains.track.TrackTargetingBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class TrackCouplerRenderer
extends SmartBlockEntityRenderer<TrackCouplerBlockEntity> {
    public TrackCouplerRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(TrackCouplerBlockEntity te, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        super.renderSafe((SmartBlockEntity)te, partialTicks, ms, buffer, light, overlay);
        this.renderEdgePoint(te, ms, buffer, light, overlay, te.edgePoint);
        this.renderEdgePoint(te, ms, buffer, light, overlay, te.secondEdgePoint);
    }

    private void renderEdgePoint(TrackCouplerBlockEntity te, PoseStack ms, MultiBufferSource buffer, int light, int overlay, TrackTargetingBehaviour<TrackCoupler> target) {
        BlockPos pos = te.m_58899_();
        boolean offsetToSide = false;
        try {
            TrackGraphLocation graphLocation = target.determineGraphLocation();
            TrackEdge edge = (TrackEdge)graphLocation.graph.getConnectionsFrom(graphLocation.graph.locateNode((TrackNodeLocation)graphLocation.edge.getFirst())).get(graphLocation.graph.locateNode((TrackNodeLocation)graphLocation.edge.getSecond()));
            for (TrackEdgePoint edgePoint : edge.getEdgeData().getPoints()) {
                try {
                    double d = edgePoint.getLocationOn(edge);
                    double d2 = target.getEdgePoint() != null ? ((TrackCoupler)target.getEdgePoint()).getLocationOn(edge) : graphLocation.position;
                    if (!(Math.abs(d - d2) < 0.75) || edgePoint == target.getEdgePoint()) continue;
                    offsetToSide = true;
                    break;
                }
                catch (Exception exception) {
                }
            }
        }
        catch (Exception graphLocation) {
            // empty catch block
        }
        BlockPos targetPosition = target.getGlobalPosition();
        Level level = te.m_58904_();
        BlockState trackState = level.m_8055_(targetPosition);
        Block block = trackState.m_60734_();
        if (!(block instanceof ITrackBlock)) {
            return;
        }
        ms.m_85836_();
        TransformStack.cast((PoseStack)ms).translate((Vec3i)targetPosition.m_121996_((Vec3i)pos));
        CustomTrackOverlayRendering.renderOverlay((LevelAccessor)level, targetPosition, target.getTargetDirection(), target.getTargetBezier(), ms, buffer, light, overlay, te.areEdgePointsOk() ? CustomTrackOverlayRendering.getCouplerOverlayModel(te.getAllowedOperationMode().canCouple, te.getAllowedOperationMode().canDecouple) : CRBlockPartials.COUPLER_NONE, 1.0f, offsetToSide);
        ms.m_85849_();
    }
}

