/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.gui.screen;

import ca.teamdman.sfm.common.Constants;
import ca.teamdman.sfm.common.net.ServerboundLabelGunClearPacket;
import ca.teamdman.sfm.common.net.ServerboundLabelGunPrunePacket;
import ca.teamdman.sfm.common.net.ServerboundLabelGunUpdatePacket;
import ca.teamdman.sfm.common.program.LabelHolder;
import ca.teamdman.sfm.common.registry.SFMPackets;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;

public class LabelGunScreen
extends Screen {
    private final InteractionHand HAND;
    private final LabelHolder LABEL_HOLDER;
    private EditBox labelField;
    private boolean shouldRebuildWidgets = false;

    public LabelGunScreen(ItemStack labelGunStack, InteractionHand hand) {
        super((Component)Constants.LocalizationKeys.LABEL_GUN_GUI_TITLE.getComponent());
        this.LABEL_HOLDER = LabelHolder.from(labelGunStack);
        this.HAND = hand;
    }

    protected void m_7856_() {
        super.m_7856_();
        assert (this.f_96541_ != null);
        this.f_96541_.f_91068_.m_90926_(true);
        this.labelField = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.f_96543_ / 2 - 150, 50, 300, 20, (Component)Constants.LocalizationKeys.LABEL_GUN_GUI_LABEL_PLACEHOLDER.getComponent()));
        this.m_94718_((GuiEventListener)this.labelField);
        this.m_7522_((GuiEventListener)this.labelField);
        this.labelField.m_94178_(true);
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 210, 50, 50, 20, (Component)Constants.LocalizationKeys.LABEL_GUN_GUI_CLEAR_BUTTON.getComponent(), btn -> {
            SFMPackets.LABEL_GUN_ITEM_CHANNEL.sendToServer((Object)new ServerboundLabelGunClearPacket(this.HAND));
            this.LABEL_HOLDER.clear();
            this.shouldRebuildWidgets = true;
        }));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 160, 50, 50, 20, (Component)Constants.LocalizationKeys.LABEL_GUN_GUI_PRUNE_BUTTON.getComponent(), btn -> {
            SFMPackets.LABEL_GUN_ITEM_CHANNEL.sendToServer((Object)new ServerboundLabelGunPrunePacket(this.HAND));
            this.LABEL_HOLDER.prune();
            this.shouldRebuildWidgets = true;
        }));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 2 - 150, this.f_96544_ - 50, 300, 20, CommonComponents.f_130655_, p_97691_ -> this.onDone()));
        List labels = this.LABEL_HOLDER.get().keySet().stream().sorted(Comparator.naturalOrder()).toList();
        int i = 0;
        int buttonWidth = this.LABEL_HOLDER.get().entrySet().stream().map(entry -> Constants.LocalizationKeys.LABEL_GUN_GUI_LABEL_BUTTON.getComponent(entry.getKey(), ((List)entry.getValue()).size()).getString()).mapToInt(arg_0 -> ((Font)this.f_96547_).m_92895_(arg_0)).max().orElse(50) + 10;
        int buttonHeight = 20;
        int paddingX = 5;
        int paddingY = 5;
        int buttonsPerRow = this.f_96543_ / (buttonWidth + paddingX);
        for (String label : labels) {
            int x = (this.f_96543_ - (buttonWidth + paddingX) * Math.min(buttonsPerRow, labels.size())) / 2 + paddingX + i % buttonsPerRow * (buttonWidth + paddingX);
            int y = 80 + i / buttonsPerRow * (buttonHeight + paddingY);
            int count = this.LABEL_HOLDER.getPositions(label).size();
            this.m_142416_((GuiEventListener)new Button(x, y, buttonWidth, buttonHeight, (Component)Constants.LocalizationKeys.LABEL_GUN_GUI_LABEL_BUTTON.getComponent(label, count), btn -> {
                this.labelField.m_94144_(label);
                this.onDone();
            }));
            ++i;
        }
    }

    public boolean m_7933_(int key, int mod1, int mod2) {
        if (super.m_7933_(key, mod1, mod2)) {
            return true;
        }
        if (key != 257 && key != 335) {
            return false;
        }
        this.onDone();
        return true;
    }

    public void onDone() {
        SFMPackets.LABEL_GUN_ITEM_CHANNEL.sendToServer((Object)new ServerboundLabelGunUpdatePacket(this.labelField.m_94155_(), this.HAND));
        this.m_7379_();
    }

    public void m_6574_(Minecraft mc, int x, int y) {
        String prev = this.labelField.m_94155_();
        this.m_6575_(mc, x, y);
        super.m_6574_(mc, x, y);
        this.labelField.m_94144_(prev);
    }

    public void m_6305_(PoseStack poseStack, int mx, int my, float partialTicks) {
        if (this.shouldRebuildWidgets) {
            this.shouldRebuildWidgets = false;
            this.m_232761_();
        }
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mx, my, partialTicks);
    }
}

