/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.handler;

import ca.teamdman.sfm.client.ClientStuff;
import ca.teamdman.sfm.client.registry.SFMKeyMappings;
import ca.teamdman.sfm.common.Constants;
import ca.teamdman.sfm.common.net.ServerboundContainerExportsInspectionRequestPacket;
import ca.teamdman.sfm.common.registry.SFMPackets;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.gui.widget.ExtendedButton;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="sfm", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ContainerScreenInspectorHandler {
    private static boolean visible = false;
    @Nullable
    private static AbstractContainerScreen<?> lastScreen = null;
    private static final ExtendedButton exportInspectorButton = new ExtendedButton(5, 50, 100, 20, (Component)Constants.LocalizationKeys.CONTAINER_INSPECTOR_SHOW_EXPORTS_BUTTON.getComponent(), button -> {
        BlockEntity lookBlockEntity = ClientStuff.getLookBlockEntity();
        if (lastScreen != null && lookBlockEntity != null) {
            SFMPackets.INSPECTION_CHANNEL.sendToServer((Object)new ServerboundContainerExportsInspectionRequestPacket(ContainerScreenInspectorHandler.lastScreen.m_6262_().f_38840_, lookBlockEntity.m_58899_()));
        }
    });

    @SubscribeEvent
    public static void onMouseClick(ScreenEvent.MouseButtonPressed.Pre event) {
        boolean shouldCapture = Minecraft.m_91087_().f_91080_ instanceof AbstractContainerScreen;
        if (shouldCapture && visible && exportInspectorButton.m_93680_(event.getMouseX(), event.getMouseY())) {
            exportInspectorButton.m_7435_(Minecraft.m_91087_().m_91106_());
            exportInspectorButton.m_5716_(event.getMouseX(), event.getMouseY());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onGuiRender(ScreenEvent.Render.Post event) {
        if (!visible) {
            return;
        }
        Screen screen = event.getScreen();
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen acs;
            lastScreen = acs = (AbstractContainerScreen)screen;
            AbstractContainerMenu menu = acs.m_6262_();
            int containerSlotCount = 0;
            int inventorySlotCount = 0;
            PoseStack poseStack = event.getPoseStack();
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, 0.0, 350.0);
            exportInspectorButton.m_6305_(poseStack, event.getMouseX(), event.getMouseY(), event.getPartialTick());
            for (Slot slot : menu.f_38839_) {
                int colour;
                if (slot.f_40218_ instanceof Inventory) {
                    colour = ChatFormatting.YELLOW.m_126665_();
                    ++inventorySlotCount;
                } else {
                    colour = 4095;
                    ++containerSlotCount;
                }
                Minecraft.m_91087_().f_91062_.m_92889_(poseStack, (Component)Component.m_237113_((String)Integer.toString(slot.getSlotIndex())), (float)(acs.getGuiLeft() + slot.f_40220_), (float)(acs.getGuiTop() + slot.f_40221_), colour);
            }
            Minecraft.m_91087_().f_91062_.m_92763_(poseStack, (Component)Constants.LocalizationKeys.CONTAINER_INSPECTOR_CONTAINER_SLOT_COUNT.getComponent(Component.m_237113_((String)String.valueOf(containerSlotCount)).m_130940_(ChatFormatting.BLUE)), 5.0f, 5.0f, 0xFFFFFF);
            Minecraft.m_91087_().f_91062_.m_92763_(poseStack, (Component)Constants.LocalizationKeys.CONTAINER_INSPECTOR_INVENTORY_SLOT_COUNT.getComponent(Component.m_237113_((String)String.valueOf(inventorySlotCount)).m_130940_(ChatFormatting.YELLOW)), 5.0f, 25.0f, 0xFFFFFF);
            poseStack.m_85849_();
        }
    }

    @SubscribeEvent
    public static void onKeyDown(ScreenEvent.KeyPressed.Pre event) {
        KeyMapping toggleKey = (KeyMapping)SFMKeyMappings.CONTAINER_INSPECTOR_KEY.get();
        boolean toggleKeyPressed = toggleKey.isActiveAndMatches(InputConstants.Type.KEYSYM.m_84895_(event.getKeyCode()));
        if (toggleKeyPressed) {
            visible = !visible;
            event.setCanceled(true);
        }
    }
}

