/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfml.ast;

import ca.teamdman.sfm.common.registry.SFMResourceTypes;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import ca.teamdman.sfml.ast.ASTNode;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class ResourceIdentifier<STACK, ITEM, CAP>
implements ASTNode,
Predicate<Object> {
    public static final ResourceIdentifier<?, ?, ?> MATCH_ALL = new ResourceIdentifier(".*", ".*");
    public final String resourceTypeNamespace;
    public final String resourceTypeName;
    public final String resourceNamespace;
    public final String resourceName;
    @Nullable
    private ResourceType<STACK, ITEM, CAP> resourceTypeCache = null;
    private static final Map<ResourceIdentifier<?, ?, ?>, List<ResourceIdentifier<?, ?, ?>>> expansionCache = new Object2ObjectOpenHashMap();

    public ResourceIdentifier(String resourceTypeNamespace, String resourceTypeName, String resourceNamespace, String resourceName) {
        this.resourceTypeNamespace = resourceTypeNamespace;
        this.resourceTypeName = resourceTypeName;
        this.resourceNamespace = resourceNamespace;
        this.resourceName = resourceName;
    }

    public ResourceIdentifier(String value) {
        this("sfm", "item", ".*", value);
    }

    public ResourceIdentifier(String namespace, String value) {
        this("sfm", "item", namespace, value);
    }

    public ResourceIdentifier(String typeName, String resourceNamespace, String resourceName) {
        this("sfm", typeName, resourceNamespace, resourceName);
    }

    public static <STACK, ITEM, CAP> ResourceIdentifier<STACK, ITEM, CAP> fromString(String string) {
        String[] parts = string.split(":");
        if (parts.length == 1) {
            return new ResourceIdentifier<STACK, ITEM, CAP>(parts[0]);
        }
        if (parts.length == 2) {
            return new ResourceIdentifier<STACK, ITEM, CAP>(parts[0], parts[1]);
        }
        if (parts.length == 3) {
            return new ResourceIdentifier<STACK, ITEM, CAP>(parts[0], parts[1], parts[2]);
        }
        if (parts.length == 4) {
            return new ResourceIdentifier<STACK, ITEM, CAP>(parts[0], parts[1], parts[2], parts[3]);
        }
        throw new IllegalArgumentException("bad resource id: " + string);
    }

    public void assertValid() throws IllegalArgumentException {
        try {
            Pattern.compile(this.resourceNamespace);
            Pattern.compile(this.resourceName);
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("Invalid resource identifier pattern \"" + this + "\" - " + e.getMessage());
        }
    }

    public Optional<ResourceLocation> getLocation() {
        try {
            return Optional.of(new ResourceLocation(this.resourceNamespace, this.resourceName));
        }
        catch (ResourceLocationException e) {
            return Optional.empty();
        }
    }

    @Override
    public boolean test(Object other) {
        ResourceType<STACK, ITEM, CAP> resourceType = this.getResourceType();
        return resourceType != null && resourceType.stackMatches(this, other);
    }

    public List<ResourceIdentifier<STACK, ITEM, CAP>> expand() {
        if (this.getResourceType() == SFMResourceTypes.FORGE_ENERGY.get()) {
            return List.of(new ResourceIdentifier<STACK, ITEM, CAP>(this.resourceTypeNamespace, this.resourceTypeName, "forge", "energy"));
        }
        if (expansionCache.containsKey(this)) {
            return expansionCache.get(this);
        }
        ResourceType<STACK, ITEM, CAP> resourceType = this.getResourceType();
        List<ResourceIdentifier<STACK, ITEM, CAP>> rtn = resourceType.getRegistry().getEntries().stream().filter(e -> ResourceType.stackIdMatches(this, ((ResourceKey)e.getKey()).m_135782_())).map(e -> new ResourceIdentifier<STACK, ITEM, CAP>(this.resourceTypeNamespace, this.resourceTypeName, ((ResourceKey)e.getKey()).m_135782_().m_135827_(), ((ResourceKey)e.getKey()).m_135782_().m_135815_())).toList();
        expansionCache.put(this, rtn);
        return rtn;
    }

    @Nullable
    public ResourceType<STACK, ITEM, CAP> getResourceType() {
        if (this.resourceTypeCache == null) {
            this.resourceTypeCache = (ResourceType)SFMResourceTypes.DEFERRED_TYPES.get().getValue(new ResourceLocation(this.resourceTypeNamespace, this.resourceTypeName));
        }
        return this.resourceTypeCache;
    }

    public String toString() {
        return this.resourceTypeNamespace + ":" + this.resourceTypeName + ":" + this.resourceNamespace + ":" + this.resourceName;
    }

    public String toStringCondensed() {
        Object rtn = this.resourceTypeNamespace.equals("sfm") && this.resourceTypeName.equals("item") ? (this.resourceNamespace.equals(".*") ? this.resourceName : this.resourceNamespace + ":" + this.resourceName) : (this.resourceTypeNamespace.equals("sfm") && this.resourceTypeName.equals("forge_energy") && this.getLocation().filter(rl -> rl.equals((Object)new ResourceLocation("forge", "energy"))).isPresent() ? "forge_energy::" : (this.resourceTypeNamespace.equals("sfm") ? this.resourceTypeName + ":" + this.resourceNamespace + ":" + this.resourceName : this.resourceTypeNamespace + ":" + this.resourceTypeName + ":" + this.resourceNamespace + ":" + this.resourceName));
        return "\"" + (String)rtn + "\"";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceIdentifier that = (ResourceIdentifier)o;
        return Objects.equals(this.resourceTypeNamespace, that.resourceTypeNamespace) && Objects.equals(this.resourceTypeName, that.resourceTypeName) && Objects.equals(this.resourceNamespace, that.resourceNamespace) && Objects.equals(this.resourceName, that.resourceName);
    }

    public int hashCode() {
        return Objects.hash(this.resourceTypeNamespace, this.resourceTypeName, this.resourceNamespace, this.resourceName);
    }
}

