/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfml.ast;

import ca.teamdman.sfm.common.program.InputResourceTracker;
import ca.teamdman.sfm.common.program.OutputResourceTracker;
import ca.teamdman.sfml.ast.ASTNode;
import ca.teamdman.sfml.ast.Limit;
import ca.teamdman.sfml.ast.ResourceIdSet;
import ca.teamdman.sfml.ast.ResourceIdentifier;
import ca.teamdman.sfml.ast.ResourceLimit;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public record ResourceLimits(List<? extends ResourceLimit<?, ?, ?>> resourceLimits, ResourceIdSet exclusions) implements ASTNode
{
    public List<InputResourceTracker<?, ?, ?>> createInputTrackers() {
        ArrayList rtn = new ArrayList();
        this.resourceLimits.forEach(rl -> rl.gatherInputTrackers(rtn::add, this.exclusions));
        return rtn;
    }

    public List<OutputResourceTracker<?, ?, ?>> createOutputTrackers() {
        ArrayList rtn = new ArrayList();
        this.resourceLimits.forEach(rl -> rl.gatherOutputTrackers(rtn::add, this.exclusions));
        return rtn;
    }

    public ResourceLimits withDefaults(Limit limit) {
        return new ResourceLimits(this.resourceLimits.stream().map(il -> il.withDefaults(limit)).toList(), this.exclusions);
    }

    public ResourceLimits withExclusions(ResourceIdSet exclusions) {
        return new ResourceLimits(this.resourceLimits, exclusions);
    }

    @Override
    public String toString() {
        Object rtn = this.resourceLimits.stream().map(ResourceLimit::toString).collect(Collectors.joining(",\n"));
        if (!this.exclusions.resourceIds().isEmpty()) {
            rtn = (String)rtn + "\nEXCEPT\n" + this.exclusions.resourceIds().stream().map(ResourceIdentifier::toString).collect(Collectors.joining(",\n"));
        }
        return rtn;
    }

    public String toStringPretty(Limit defaults) {
        Object rtn = this.resourceLimits.stream().map(rl -> rl.toStringCondensed(defaults)).map(x -> this.resourceLimits.size() == 1 ? x : x + ",").collect(Collectors.joining("\n"));
        if (!this.exclusions.resourceIds().isEmpty()) {
            rtn = (String)rtn + "\nEXCEPT\n" + this.exclusions.resourceIds().stream().map(ResourceIdentifier::toStringCondensed).collect(Collectors.joining(",\n"));
        }
        return rtn;
    }
}

