/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.entity.stoneborn;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import quek.undergarden.entity.stoneborn.goals.StonebornLookAtCustomerGoal;
import quek.undergarden.entity.stoneborn.goals.StonebornTradeWithPlayerGoal;
import quek.undergarden.entity.stoneborn.trading.StonebornTrades;
import quek.undergarden.registry.UGCriteria;
import quek.undergarden.registry.UGDimensions;
import quek.undergarden.registry.UGItems;
import quek.undergarden.registry.UGSoundEvents;

public class Stoneborn
extends Monster
implements NeutralMob,
Npc,
Merchant {
    protected int timeOutOfUG = 0;
    private static final UniformInt ANGER_TIME_RANGE = TimeUtil.m_145020_((int)20, (int)39);
    private int angerTime;
    private UUID targetUuid;
    @Nullable
    private Player customer;
    @Nullable
    protected MerchantOffers offers;

    public Stoneborn(EntityType<? extends Monster> type, Level level) {
        super(type, level);
        this.f_19793_ = 1.0f;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new StonebornTradeWithPlayerGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new StonebornLookAtCustomerGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.3));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 32.0f));
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22278_, 0.9);
    }

    public static boolean canStonebornSpawn(EntityType<? extends Monster> entity, LevelAccessor level, MobSpawnType mobSpawnType, BlockPos pos, RandomSource random) {
        return level.m_46791_() != Difficulty.PEACEFUL && random.m_188503_(10) == 0 && Stoneborn.m_217057_(entity, (LevelAccessor)level, (MobSpawnType)mobSpawnType, (BlockPos)pos, (RandomSource)random);
    }

    public boolean m_6040_() {
        return true;
    }

    protected SoundEvent m_7515_() {
        if (this.m_5912_()) {
            return (SoundEvent)UGSoundEvents.STONEBORN_ANGRY.get();
        }
        if (this.hasCustomer()) {
            return (SoundEvent)UGSoundEvents.STONEBORN_SPEAKING.get();
        }
        if (!this.inUndergarden()) {
            return (SoundEvent)UGSoundEvents.STONEBORN_CONFUSED.get();
        }
        return null;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)UGSoundEvents.STONEBORN_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)UGSoundEvents.STONEBORN_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_((SoundEvent)UGSoundEvents.STONEBORN_STEP.get(), 1.0f, 1.0f);
    }

    protected SoundEvent getYesOrNoSound(boolean getYesSound) {
        return getYesSound ? (SoundEvent)UGSoundEvents.STONEBORN_PLEASED.get() : (SoundEvent)UGSoundEvents.STONEBORN_CONFUSED.get();
    }

    public InteractionResult m_6071_(Player player, InteractionHand playerHand) {
        ItemStack itemstack = player.m_21120_(playerHand);
        if (itemstack.m_41720_() != UGItems.STONEBORN_SPAWN_EGG.get() && this.m_6084_() && !this.hasCustomer() && this.inUndergarden()) {
            if (this.m_6616_().isEmpty()) {
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
            if (!this.f_19853_.f_46443_) {
                this.m_7189_(player);
                this.m_45301_(player, this.m_5446_(), 1);
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6071_(player, playerHand);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.inUndergarden() && !this.m_21525_()) {
            ++this.timeOutOfUG;
            this.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 300, 0));
        } else {
            this.timeOutOfUG = 0;
        }
        if (this.timeOutOfUG > 300) {
            this.m_5496_((SoundEvent)UGSoundEvents.STONEBORN_CHANT.get(), 1.0f, 1.0f);
            if (!this.f_19853_.f_46443_) {
                this.m_142687_(Entity.RemovalReason.KILLED);
                Explosion.BlockInteraction explosionType = this.f_19853_.m_46469_().m_46207_(GameRules.f_46132_) ? Explosion.BlockInteraction.BREAK : Explosion.BlockInteraction.NONE;
                this.f_19853_.m_46511_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 3.0f, explosionType);
            }
        }
        if (!this.m_5912_() && this.f_19853_.m_46467_() % 40L == 0L) {
            this.m_5634_(1.0f);
        }
    }

    public boolean inUndergarden() {
        return this.f_19853_.m_46472_() == UGDimensions.UNDERGARDEN_LEVEL;
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        this.timeOutOfUG = nbt.m_128451_("TimeOutOfUndergarden");
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        nbt.m_128405_("TimeOutOfUndergarden", this.timeOutOfUG);
    }

    public int m_6784_() {
        return this.angerTime;
    }

    public void m_7870_(int time) {
        this.angerTime = time;
    }

    @Nullable
    public UUID m_6120_() {
        return this.targetUuid;
    }

    public void m_6925_(@Nullable UUID target) {
        this.targetUuid = target;
    }

    public void m_6825_() {
        this.m_7870_(ANGER_TIME_RANGE.m_214085_(this.f_19796_));
    }

    public void m_7189_(@Nullable Player player) {
        this.customer = player;
    }

    @Nullable
    public Player m_7962_() {
        return this.customer;
    }

    public boolean hasCustomer() {
        return this.customer != null;
    }

    public MerchantOffers m_6616_() {
        if (this.offers == null) {
            this.offers = new MerchantOffers();
            this.populateTradeData();
        }
        return this.offers;
    }

    protected void populateTradeData() {
        VillagerTrades.ItemListing[] trades = (VillagerTrades.ItemListing[])StonebornTrades.VAGABOND_TRADES.get(1);
        if (trades != null) {
            MerchantOffers merchantoffers = this.m_6616_();
            this.addTrades(merchantoffers, trades, 4);
        }
    }

    protected void addTrades(MerchantOffers givenMerchantOffers, VillagerTrades.ItemListing[] newTrades, int maxNumbers) {
        HashSet set = Sets.newHashSet();
        if (newTrades.length > maxNumbers) {
            while (set.size() < maxNumbers) {
                set.add(this.f_19796_.m_188503_(newTrades.length));
            }
        } else {
            for (int i = 0; i < newTrades.length; ++i) {
                set.add(i);
            }
        }
        for (Integer integer : set) {
            VillagerTrades.ItemListing villagertrades$itrade = newTrades[integer];
            MerchantOffer merchantoffer = villagertrades$itrade.m_213663_((Entity)this, this.f_19796_);
            if (merchantoffer == null) continue;
            givenMerchantOffers.add((Object)merchantoffer);
        }
    }

    public void m_6255_(@Nullable MerchantOffers offers) {
    }

    public void m_6996_(MerchantOffer offer) {
        offer.m_45374_();
        this.f_21363_ = -this.m_8100_();
        this.onStonebornTrade(offer);
        if (this.customer instanceof ServerPlayer) {
            UGCriteria.STONEBORN_TRADE.test((ServerPlayer)this.customer, this, offer.m_45368_());
        }
    }

    protected void onStonebornTrade(MerchantOffer offer) {
        if (offer.m_45383_()) {
            int i = 3 + this.f_19796_.m_188503_(4);
            this.f_19853_.m_7967_((Entity)new ExperienceOrb(this.f_19853_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), i));
        }
    }

    public void m_7713_(ItemStack stack) {
        if (!this.f_19853_.f_46443_ && this.f_21363_ > -this.m_8100_() + 20) {
            this.f_21363_ = -this.m_8100_();
            this.m_5496_(this.getYesOrNoSound(!stack.m_41619_()), this.m_6121_(), this.m_6100_());
        }
    }

    public Level m_9236_() {
        return this.f_19853_;
    }

    public int m_7809_() {
        return 0;
    }

    public void m_6621_(int xpIn) {
    }

    public boolean m_7826_() {
        return false;
    }

    public SoundEvent m_7596_() {
        return (SoundEvent)UGSoundEvents.STONEBORN_PLEASED.get();
    }

    public boolean m_183595_() {
        return this.m_9236_().f_46443_;
    }
}

