/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.crudefurnace;

import com.google.common.collect.Lists;
import de.melanx.utilitix.content.crudefurnace.CrudeFurnaceRecipeHelper;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.moddingx.libx.base.tile.BlockEntityBase;
import org.moddingx.libx.base.tile.TickingBlock;
import org.moddingx.libx.capability.ItemCapabilities;
import org.moddingx.libx.inventory.BaseItemStackHandler;

public class TileCrudeFurnace
extends BlockEntityBase
implements TickingBlock {
    private final Object2IntOpenHashMap<ResourceLocation> recipes = new Object2IntOpenHashMap();
    private final BaseItemStackHandler inventory = BaseItemStackHandler.builder((int)5).validator(stack -> ForgeHooks.getBurnTime((ItemStack)stack, (RecipeType)RecipeType.f_44108_) > 0, new int[]{0}).validator(stack -> this.f_58857_ != null && CrudeFurnaceRecipeHelper.getResult(this.f_58857_.m_7465_(), stack) != null, new int[]{1}).output(new int[]{2}).contentsChanged(() -> {
        this.m_6596_();
        this.setDispatchable();
        this.update = true;
    }).build();
    private final LazyOptional<IItemHandler> fuel = ItemCapabilities.create(this::getInventory, slot -> false, (slot, stack) -> slot == 0).cast();
    private final LazyOptional<IItemHandler> input = ItemCapabilities.create(this::getInventory, slot -> false, (slot, stack) -> slot == 1).cast();
    private final LazyOptional<IItemHandler> output = ItemCapabilities.create(this::getInventory, slot -> slot == 2, (slot, stack) -> false).cast();
    private CrudeFurnaceRecipeHelper.ModifiedRecipe recipe;
    private int maxFuelTime;
    private int fuelTime;
    private int burnTime;
    private boolean update;
    private boolean initDone;

    public TileCrudeFurnace(BlockEntityType<?> blockEntityTypeIn, BlockPos pos, BlockState state) {
        super(blockEntityTypeIn, pos, state);
    }

    private boolean isItemValid(int slot, ItemStack stack) {
        if (slot == 0) {
            return ForgeHooks.getBurnTime((ItemStack)stack, (RecipeType)RecipeType.f_44108_) > 0;
        }
        if (slot == 1) {
            return this.f_58857_ != null && CrudeFurnaceRecipeHelper.getResult(this.f_58857_.m_7465_(), stack) != null;
        }
        return false;
    }

    public void tick() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            boolean isBurning = this.isBurning();
            if (!this.initDone) {
                this.updateRecipe();
                this.initDone = true;
            }
            if (this.recipe != null) {
                ItemStack result = this.recipe.getOutput();
                if (this.fuelTime > 0) {
                    ++this.burnTime;
                    this.setDispatchable();
                }
                if (!result.m_41619_() && this.burnTime >= this.recipe.getBurnTime() && this.inventory.getUnrestricted().insertItem(2, result, true).m_41619_()) {
                    this.burnTime = 0;
                    this.inventory.getUnrestricted().extractItem(1, 1, false);
                    this.inventory.getUnrestricted().insertItem(2, result.m_41777_(), false);
                    this.setRecipeUsed((Recipe<?>)this.recipe.getOriginalRecipe());
                    this.updateRecipe();
                    this.setDispatchable();
                }
            }
            if (this.fuelTime > 0) {
                --this.fuelTime;
                this.setDispatchable();
            }
            if (this.recipe != null && this.fuelTime <= 0) {
                this.maxFuelTime = this.fuelTime = ForgeHooks.getBurnTime((ItemStack)this.inventory.getStackInSlot(0), (RecipeType)RecipeType.f_44108_) / 2;
                this.inventory.getUnrestricted().extractItem(0, 1, false);
                this.setDispatchable();
            }
            if (this.fuelTime <= 0 && this.burnTime != 0) {
                this.burnTime = 0;
                this.setDispatchable();
            }
            if (isBurning != this.isBurning()) {
                this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)AbstractFurnaceBlock.f_48684_, (Comparable)Boolean.valueOf(this.isBurning())));
            }
            this.m_6596_();
        }
        if (this.update) {
            this.updateRecipe();
            this.update = false;
        }
    }

    public boolean isBurning() {
        return this.fuelTime > 0;
    }

    public int getScaledBurnTime() {
        return this.fuelTime * 13 / this.maxFuelTime;
    }

    public int getCookProgressionScaled() {
        return this.burnTime != 0 && this.recipe != null && this.recipe.getBurnTime() != 0 ? this.burnTime * 24 / this.recipe.getBurnTime() : 0;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side == null) {
                return LazyOptional.of(this::getInventory).cast();
            }
            return switch (side) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST -> this.fuel.cast();
                case Direction.UP -> this.input.cast();
                case Direction.DOWN -> this.output.cast();
            };
        }
        return super.getCapability(cap, side);
    }

    @Nonnull
    public IItemHandlerModifiable getInventory() {
        return this.inventory;
    }

    @Nonnull
    public IItemHandlerModifiable getUnrestricted() {
        return this.inventory.getUnrestricted();
    }

    public CrudeFurnaceRecipeHelper.ModifiedRecipe getRecipe() {
        return this.recipe;
    }

    public void setRecipeUsed(@Nullable Recipe<?> recipe) {
        if (recipe != null) {
            ResourceLocation id = recipe.m_6423_();
            this.recipes.addTo((Object)id, 1);
        }
    }

    public void unlockRecipes(Player player) {
        List<Recipe<?>> recipes = this.grantStoredRecipeExperience(player.f_19853_, player.m_20182_());
        player.m_7281_(recipes);
        this.recipes.clear();
    }

    public List<Recipe<?>> grantStoredRecipeExperience(Level level, Vec3 pos) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.recipes.object2IntEntrySet()) {
            level.m_7465_().m_44043_((ResourceLocation)entry.getKey()).ifPresent(recipe -> {
                list.add(recipe);
                TileCrudeFurnace.splitAndSpawnExperience(level, pos, entry.getIntValue(), new CrudeFurnaceRecipeHelper.ModifiedRecipe((SmeltingRecipe)recipe).getXp());
            });
        }
        return list;
    }

    private static void splitAndSpawnExperience(Level level, Vec3 pos, int craftedAmount, float experience) {
        int i = Mth.m_14143_((float)((float)craftedAmount * experience));
        float f = Mth.m_14187_((float)((float)craftedAmount * experience));
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        while (i > 0) {
            int j = ExperienceOrb.m_20782_((int)i);
            i -= j;
            level.m_7967_((Entity)new ExperienceOrb(level, pos.f_82479_, pos.f_82480_, pos.f_82481_, j));
        }
    }

    private void updateRecipe() {
        if (this.f_58857_ != null) {
            this.recipe = CrudeFurnaceRecipeHelper.getResult(this.f_58857_.m_7465_(), this.inventory.getStackInSlot(1));
        }
    }

    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.inventory.deserializeNBT(nbt.m_128469_("Inventory"));
        this.burnTime = nbt.m_128451_("burnTime");
        this.fuelTime = nbt.m_128451_("fuelTime");
        this.maxFuelTime = nbt.m_128451_("maxFuelTime");
        CompoundTag recipes = nbt.m_128469_("RecipesUsed");
        for (String s : recipes.m_128431_()) {
            this.recipes.put((Object)new ResourceLocation(s), recipes.m_128451_(s));
        }
    }

    public void m_183515_(@Nonnull CompoundTag compound) {
        compound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
        compound.m_128405_("burnTime", this.burnTime);
        compound.m_128405_("fuelTime", this.fuelTime);
        compound.m_128405_("maxFuelTime", this.maxFuelTime);
        CompoundTag recipes = new CompoundTag();
        this.recipes.forEach((id, xp) -> recipes.m_128405_(id.toString(), xp.intValue()));
        compound.m_128365_("RecipesUsed", (Tag)recipes);
    }

    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            nbt.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
            nbt.m_128405_("burnTime", this.burnTime);
            nbt.m_128405_("fuelTime", this.fuelTime);
            nbt.m_128405_("maxFuelTime", this.maxFuelTime);
            CompoundTag recipes = nbt.m_128469_("RecipesUsed");
            for (String s : recipes.m_128431_()) {
                this.recipes.put((Object)new ResourceLocation(s), recipes.m_128451_(s));
            }
        }
        return nbt;
    }

    public void handleUpdateTag(CompoundTag nbt) {
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            super.handleUpdateTag(nbt);
            this.inventory.deserializeNBT(nbt.m_128469_("Inventory"));
            this.burnTime = nbt.m_128451_("burnTime");
            this.fuelTime = nbt.m_128451_("fuelTime");
            this.maxFuelTime = nbt.m_128451_("maxFuelTime");
            CompoundTag recipes = new CompoundTag();
            this.recipes.forEach((id, xp) -> recipes.m_128405_(id.toString(), xp.intValue()));
            nbt.m_128365_("RecipesUsed", (Tag)recipes);
        }
    }
}

