/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.shulkerboat;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Vector3f;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ShulkerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.BoatRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.vehicle.Boat;

public class ShulkerBoatRenderer
extends BoatRenderer {
    private final Map<Boat.Type, Pair<ResourceLocation, BoatModel>> boatResources = (Map)Stream.of(Boat.Type.values()).collect(ImmutableMap.toImmutableMap(type -> type, type -> {
        ResourceLocation location = new ResourceLocation("minecraft", "textures/entity/boat/" + type.m_38429_() + ".png");
        BoatModel model = new BoatModel(context.m_174023_(ModelLayers.m_171289_((Boat.Type)type)), false);
        return Pair.of((Object)location, (Object)model);
    }));
    private final ShulkerModel<?> shulkerModel;

    public ShulkerBoatRenderer(EntityRendererProvider.Context context) {
        super(context, true);
        this.shulkerModel = new ShulkerModel(context.m_174023_(ModelLayers.f_171180_));
    }

    public void m_7392_(@Nonnull Boat boat, float entityYaw, float partialTick, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int packedLight) {
        super.m_7392_(boat, entityYaw, partialTick, poseStack, buffer, packedLight);
        RenderType renderType = this.shulkerModel.m_103119_(new ResourceLocation("minecraft", "textures/" + Sheets.f_110741_.m_119203_().m_135815_() + ".png"));
        VertexConsumer vertexConsumer = buffer.m_6299_(renderType);
        poseStack.m_85836_();
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - entityYaw));
        float remainingHurtTime = (float)boat.m_38385_() - partialTick;
        if (remainingHurtTime > 0.0f) {
            float damage = Math.max(0.0f, boat.m_38384_() - partialTick);
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(Mth.m_14031_((float)remainingHurtTime) * remainingHurtTime * damage / 10.0f * (float)boat.m_38386_()));
        }
        poseStack.m_85837_(0.0, 1.39, 0.475);
        poseStack.m_85841_(0.8f, 0.8f, 0.8f);
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
        this.shulkerModel.m_7695_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }

    @Nonnull
    public Pair<ResourceLocation, BoatModel> getModelWithLocation(@Nonnull Boat boat) {
        return this.boatResources.get(boat.m_38387_());
    }
}

