/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.track;

import de.melanx.utilitix.content.track.carts.Cart;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;

public class TrackUtil {
    public static void accelerateStraight(Level level, BlockPos pos, RailShape shape, AbstractMinecart cart, double accelerationValue) {
        Vec3 motion = cart.m_20184_();
        double horizontalMotion = Math.sqrt(Cart.getHorizontalDistanceSqr(motion));
        if (horizontalMotion > accelerationValue / 40.0) {
            cart.m_20256_(motion.m_82520_(motion.f_82479_ / horizontalMotion * (accelerationValue * 0.15), 0.0, motion.f_82481_ / horizontalMotion * (accelerationValue * 0.15)));
        } else {
            double motionX = motion.f_82479_;
            double motionZ = motion.f_82481_;
            if (shape == RailShape.EAST_WEST) {
                if (level.m_8055_(pos.m_122024_()).m_60796_((BlockGetter)level, pos.m_122024_())) {
                    motionX = accelerationValue / 20.0;
                } else if (level.m_8055_(pos.m_122029_()).m_60796_((BlockGetter)level, pos.m_122029_())) {
                    motionX = -(accelerationValue / 20.0);
                }
            } else if (shape == RailShape.NORTH_SOUTH) {
                if (level.m_8055_(pos.m_122012_()).m_60796_((BlockGetter)level, pos.m_122012_())) {
                    motionZ = accelerationValue / 20.0;
                } else if (level.m_8055_(pos.m_122019_()).m_60796_((BlockGetter)level, pos.m_122019_())) {
                    motionZ = -(accelerationValue / 20.0);
                }
            }
            cart.m_20334_(motionX, motion.f_82480_, motionZ);
        }
    }

    public static void slowDownCart(Level level, AbstractMinecart cart, double accelerationValue) {
        double horizontalMotion = Math.sqrt(Cart.getHorizontalDistanceSqr(cart.m_20184_()));
        if (horizontalMotion < accelerationValue * 0.75) {
            cart.m_20256_(Vec3.f_82478_);
        } else {
            cart.m_20256_(cart.m_20184_().m_82542_(1.0 / (5.0 * accelerationValue), 0.0, 1.0 / (5.0 * accelerationValue)));
        }
    }

    public static Direction getFace(RailShape shape, boolean reverse) {
        return switch (shape) {
            case RailShape.NORTH_SOUTH, RailShape.ASCENDING_NORTH, RailShape.ASCENDING_SOUTH -> {
                if (reverse) {
                    yield Direction.SOUTH;
                }
                yield Direction.NORTH;
            }
            case RailShape.ASCENDING_EAST, RailShape.ASCENDING_WEST, RailShape.EAST_WEST -> {
                if (reverse) {
                    yield Direction.WEST;
                }
                yield Direction.EAST;
            }
            default -> Direction.NORTH;
        };
    }

    public static Pair<RailShape, Boolean> getForPlacement(Direction dir) {
        return switch (dir) {
            case Direction.NORTH -> Pair.of((Object)RailShape.NORTH_SOUTH, (Object)false);
            case Direction.SOUTH -> Pair.of((Object)RailShape.NORTH_SOUTH, (Object)true);
            case Direction.EAST -> Pair.of((Object)RailShape.EAST_WEST, (Object)false);
            case Direction.WEST -> Pair.of((Object)RailShape.EAST_WEST, (Object)true);
            default -> Pair.of((Object)RailShape.NORTH_SOUTH, (Object)false);
        };
    }

    public static void defaultCollisions(AbstractMinecart cart, Entity other) {
        double zd;
        double xd;
        double horizontalSquared;
        if (!(cart.f_19853_.f_46443_ || cart.f_19794_ || other.f_19794_ || cart.m_20363_(other) || !((horizontalSquared = (xd = other.m_20185_() - cart.m_20185_()) * xd + (zd = other.m_20189_() - cart.m_20189_()) * zd) >= 0.001))) {
            double horizontal = Mth.m_14116_((float)((float)horizontalSquared));
            xd /= horizontal;
            zd /= horizontal;
            if (other instanceof AbstractMinecart) {
                Vec3 cartRot;
                AbstractMinecart otherCart = (AbstractMinecart)other;
                Vec3 diffVecN = new Vec3(otherCart.m_20185_() - cart.m_20185_(), 0.0, otherCart.m_20189_() - cart.m_20189_()).m_82541_();
                double product = Math.abs(diffVecN.m_82526_(cartRot = new Vec3(Math.cos(Math.toRadians(cart.f_19857_)), 0.0, Math.sin(Math.toRadians(cart.f_19857_))).m_82541_()));
                if (product >= 0.8) {
                    Vec3 cartMotion = cart.m_20184_();
                    Vec3 entityMotion = otherCart.m_20184_();
                    if (!cart.isPoweredCart() && otherCart.isPoweredCart()) {
                        cart.m_20256_(cartMotion.m_82542_(0.2, 1.0, 0.2));
                        cart.m_5997_(entityMotion.f_82479_ - xd, 0.0, entityMotion.f_82481_ - zd);
                        otherCart.m_20256_(entityMotion.m_82542_(0.95, 1.0, 0.95));
                    } else if (cart.isPoweredCart() && !otherCart.isPoweredCart()) {
                        otherCart.m_20256_(entityMotion.m_82542_(0.2, 1.0, 0.2));
                        otherCart.m_5997_(cartMotion.f_82479_ + xd, 0.0, cartMotion.f_82481_ + zd);
                        cart.m_20256_(cartMotion.m_82542_(0.95, 1.0, 0.95));
                    } else {
                        double xm = (entityMotion.f_82479_ + cartMotion.f_82479_) / 2.0;
                        double zm = (entityMotion.f_82481_ + cartMotion.f_82481_) / 2.0;
                        cart.m_20256_(cartMotion.m_82542_(0.2, 1.0, 0.2));
                        cart.m_5997_(xm - xd, 0.0, zm - zd);
                        otherCart.m_20256_(entityMotion.m_82542_(0.2, 1.0, 0.2));
                        otherCart.m_5997_(xm + xd, 0.0, zm + zd);
                    }
                }
            } else {
                cart.m_5997_(-xd, 0.0, -zd);
                other.m_5997_(xd / 4.0, 0.0, zd / 4.0);
            }
        }
    }
}

