/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.track.carts;

import de.melanx.utilitix.UtilitiX;
import de.melanx.utilitix.content.track.carts.ItemCart;
import de.melanx.utilitix.content.track.carts.MinecartRendererX;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.Registry;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import org.moddingx.libx.base.ItemBase;
import org.moddingx.libx.mod.ModX;
import org.moddingx.libx.registration.Registerable;
import org.moddingx.libx.registration.RegistrationContext;
import org.moddingx.libx.registration.SetupContext;

public class Cart
extends AbstractMinecart {
    private static final Map<EntityType<?>, Item> cartItems = Collections.synchronizedMap(new HashMap());

    protected Cart(EntityType<?> type, Level level) {
        super(type, level);
    }

    @Nonnull
    public AbstractMinecart.Type m_6064_() {
        return AbstractMinecart.Type.RIDEABLE;
    }

    @Nonnull
    public Item m_213728_() {
        return cartItems.getOrDefault(this.m_6095_(), Items.f_42449_);
    }

    public boolean canBeRidden() {
        return false;
    }

    @Nonnull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static <T extends Cart> CartType<T> type(String id, EntityType.EntityFactory<T> factory) {
        return Cart.type(id, factory, new Item.Properties().m_41487_(1));
    }

    public static <T extends Cart> CartType<T> type(String id, EntityType.EntityFactory<T> factory, Item.Properties properties) {
        EntityType type = EntityType.Builder.m_20704_(factory, (MobCategory)MobCategory.MISC).m_20699_(0.98f, 0.7f).m_20702_(8).m_20712_(UtilitiX.getInstance().modid + "_" + id);
        ItemCart item = new ItemCart((ModX)UtilitiX.getInstance(), (EntityType<? extends Cart>)type, properties);
        cartItems.put(type, (Item)item);
        return new DefaultCartType(type, item);
    }

    public static double getHorizontalDistanceSqr(Vec3 vec) {
        return vec.f_82479_ * vec.f_82479_ + vec.f_82481_ * vec.f_82481_;
    }

    public static interface CartType<T extends Cart>
    extends Registerable {
        public EntityType<T> get();

        public ItemBase item();
    }

    private static class DefaultCartType<T extends Cart>
    implements CartType<T> {
        private final EntityType<T> type;
        private final ItemBase item;

        private DefaultCartType(EntityType<T> type, ItemBase item) {
            this.type = type;
            this.item = item;
        }

        @Override
        public EntityType<T> get() {
            return this.type;
        }

        @Override
        public ItemBase item() {
            return this.item;
        }

        public void registerAdditional(RegistrationContext ctx, Registerable.EntryCollector builder) {
            builder.register(Registry.f_122903_, this.type);
            builder.register(Registry.f_122904_, (Object)this.item);
        }

        public void initTracking(RegistrationContext ctx, Registerable.TrackingCollector builder) throws ReflectiveOperationException {
            builder.track(ForgeRegistries.ENTITY_TYPES, DefaultCartType.class.getDeclaredField("type"));
            builder.track(ForgeRegistries.ITEMS, DefaultCartType.class.getDeclaredField("item"));
        }

        @OnlyIn(value=Dist.CLIENT)
        public void registerClient(SetupContext ctx) {
            EntityRenderers.m_174036_(this.type, context -> new MinecartRendererX(context, ModelLayers.f_171198_));
        }
    }
}

