/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.client.render.ui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import org.jetbrains.annotations.NotNull;

public class TiledIcon {
    public static void render(@NotNull PoseStack matrixStack, float x, float y, float width, float height, float scale, TextureAtlasSprite sprite, TileConfiguration configuration) {
        int yCoord;
        int xCoord;
        int i;
        matrixStack.m_85836_();
        if (!configuration.reverse) {
            matrixStack.m_85837_((double)(x + configuration.maxWidth * scale), (double)(y + configuration.maxHeight * scale), 0.0);
        } else {
            matrixStack.m_85837_((double)x, (double)y, 0.0);
        }
        matrixStack.m_85841_(configuration.reverse ? scale : -scale, configuration.reverse ? scale : -scale, scale);
        int spriteWidth = sprite.m_118405_();
        int spriteHeight = sprite.m_118408_();
        int tileX = (int)(width / (float)spriteWidth);
        int tileY = (int)(height / (float)spriteHeight);
        float modWidth = width % (float)sprite.m_118405_();
        float modHeight = height % (float)sprite.m_118408_();
        float u = 16.0f * modWidth / (float)spriteWidth;
        float v = 16.0f * modHeight / (float)spriteHeight;
        if (!configuration.reverse) {
            u = 16.0f - u;
            v = 16.0f - v;
        }
        float u0 = configuration.reverse ? sprite.m_118409_() : sprite.m_118410_();
        float u1 = configuration.reverse ? sprite.m_118410_() : sprite.m_118409_();
        float v0 = configuration.reverse ? sprite.m_118411_() : sprite.m_118412_();
        float v1 = configuration.reverse ? sprite.m_118412_() : sprite.m_118411_();
        boolean offset = false;
        for (i = 0; i < tileX; ++i) {
            for (int j = 0; j < tileY; ++j) {
                int xCoord2 = i * spriteWidth;
                int yCoord2 = j * spriteHeight;
                int xCoordWidth = xCoord2 + spriteWidth;
                int yCoordHeight = yCoord2 + spriteHeight;
                TiledIcon.innerBlit(matrixStack.m_85850_().m_85861_(), (float)xCoord2, (float)xCoordWidth, (float)yCoord2, (float)yCoordHeight, (float)offset, u0, u1, v0, v1);
            }
        }
        u1 = configuration.reverse ? sprite.m_118410_() : sprite.m_118409_();
        v1 = sprite.m_118393_((double)v);
        for (i = 0; i < tileX; ++i) {
            xCoord = i * spriteWidth;
            yCoord = tileY * spriteHeight;
            int xCoordWidth = xCoord + spriteWidth;
            float yCoordHeight = (float)yCoord + modHeight;
            TiledIcon.innerBlit(matrixStack.m_85850_().m_85861_(), (float)xCoord, (float)xCoordWidth, (float)yCoord, yCoordHeight, (float)offset, u0, u1, v0, v1);
        }
        u1 = sprite.m_118367_((double)u);
        v1 = configuration.reverse ? sprite.m_118412_() : sprite.m_118411_();
        for (int j = 0; j < tileY; ++j) {
            xCoord = tileX * spriteWidth;
            yCoord = j * spriteHeight;
            float xCoordWidth = (float)xCoord + modWidth;
            int yCoordHeight = yCoord + spriteHeight;
            TiledIcon.innerBlit(matrixStack.m_85850_().m_85861_(), (float)xCoord, xCoordWidth, (float)yCoord, (float)yCoordHeight, (float)offset, u0, u1, v0, v1);
        }
        int xCoord3 = tileX * spriteWidth;
        int yCoord3 = tileY * spriteHeight;
        float xCoordWidth = (float)xCoord3 + modWidth;
        float yCoordHeight = (float)yCoord3 + modHeight;
        u1 = sprite.m_118367_((double)u);
        v1 = sprite.m_118393_((double)v);
        TiledIcon.innerBlit(matrixStack.m_85850_().m_85861_(), (float)xCoord3, xCoordWidth, (float)yCoord3, yCoordHeight, (float)offset, u0, u1, v0, v1);
        matrixStack.m_85849_();
    }

    public static void innerBlit(@NotNull PoseStack matrixStack, int x0, int x1, int y0, int y1, int offset, float u0, float u1, float v0, float v1) {
        GuiComponent.m_93112_((Matrix4f)matrixStack.m_85850_().m_85861_(), (int)x0, (int)x1, (int)y0, (int)y1, (int)offset, (float)u0, (float)u1, (float)v0, (float)v1);
    }

    public static void innerBlit(Matrix4f matrix, float x0, float x1, float y0, float y1, float zOffset, float u0, float u1, float v0, float v1) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferbuilder.m_85982_(matrix, x0, y1, zOffset).m_7421_(u0, v1).m_5752_();
        bufferbuilder.m_85982_(matrix, x1, y1, zOffset).m_7421_(u1, v1).m_5752_();
        bufferbuilder.m_85982_(matrix, x1, y0, zOffset).m_7421_(u1, v0).m_5752_();
        bufferbuilder.m_85982_(matrix, x0, y0, zOffset).m_7421_(u0, v0).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
    }

    public static void innerBlit(Matrix4f matrix, int x0, int x1, int y0, int y1, int offset, TextureAtlasSprite sprite) {
        GuiComponent.m_93112_((Matrix4f)matrix, (int)x0, (int)x1, (int)y0, (int)y1, (int)offset, (float)sprite.m_118409_(), (float)sprite.m_118410_(), (float)sprite.m_118411_(), (float)sprite.m_118412_());
    }

    public record TileConfiguration(boolean reverse, float maxWidth, float maxHeight) {
        public TileConfiguration() {
            this(true, 0.0f, 0.0f);
        }
    }
}

