/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content;

import java.util.HashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.registries.RegistryObject;
import tv.soaryn.xycraft.core.data.BlockModelType;

public class BlockContent {
    private final RegistryObject<Block> _registryBlock;
    private final RegistryObject<Item> _registryItem;
    private final RegistryObject<BlockEntityType<?>> _registryEntity;
    private String _modelPath;
    protected final HashMap<String, String> _localizations = new HashMap();
    private BlockModelType _modelType;
    private boolean _customBreakRules;
    private boolean _customItemModel;

    public BlockContent(RegistryObject<Block> block, RegistryObject<Item> item) {
        this(block, item, null);
    }

    public BlockContent(RegistryObject<Block> block, RegistryObject<Item> item, RegistryObject<BlockEntityType<?>> entity) {
        this._registryBlock = block;
        this._registryItem = item;
        this._modelPath = block.getId().m_135815_();
        this._modelType = BlockModelType.Block;
        this._registryEntity = entity;
    }

    public ResourceLocation id() {
        return this._registryBlock.getId();
    }

    public Block block() {
        return (Block)this._registryBlock.get();
    }

    public Item item() {
        return (Item)this._registryItem.get();
    }

    public <T extends BlockEntity> BlockEntityType<T> entity() {
        return (BlockEntityType)this._registryEntity.get();
    }

    public BlockContent withModelPath(String modelPath) {
        this._modelPath = modelPath;
        return this;
    }

    public BlockContent withName(String localizedName) {
        this._localizations.put("en_us", localizedName);
        return this;
    }

    public BlockContent withName(String locale, String localizedName) {
        this._localizations.put(locale, localizedName);
        return this;
    }

    public BlockContent withModelType(BlockModelType type) {
        this._modelType = type;
        return this;
    }

    public BlockContent withCustomBreakRule() {
        this._customBreakRules = true;
        return this;
    }

    public BlockContent withCustomItemModel() {
        this._customItemModel = true;
        return this;
    }

    public String getLocalizedName(String locale) {
        return this._localizations.get(locale);
    }

    public String modelPath() {
        return this._modelPath;
    }

    public BlockModelType getModelType() {
        return this._modelType;
    }

    public boolean hasCustomBreakRules() {
        return this._customBreakRules;
    }

    public boolean hasCustomItemModel() {
        return this._customItemModel;
    }
}

