/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core.content;

import java.util.HashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.RegistryObject;

public class ItemContent {
    private final RegistryObject<Item> _registryItem;
    private String _modelPath;
    private final HashMap<String, String> _localizations = new HashMap();
    private boolean _customItemModel;

    public ItemContent(RegistryObject<Item> item) {
        this._registryItem = item;
        this._modelPath = item.getId().m_135815_();
        this._localizations.put("en_us", item.getId().m_135815_());
    }

    public ItemContent withTempModel() {
        return this.withModelPath("temp");
    }

    public ItemContent withCustomItemModel() {
        this._customItemModel = true;
        return this;
    }

    public ItemContent withModelPath(String modelPath) {
        this._modelPath = modelPath;
        return this;
    }

    public ItemContent withName(String localizedName) {
        this._localizations.put("en_us", localizedName);
        return this;
    }

    public ItemContent withName(String locale, String localizedName) {
        this._localizations.put(locale, localizedName);
        return this;
    }

    public ResourceLocation id() {
        return this._registryItem.getId();
    }

    public Item item() {
        return (Item)this._registryItem.get();
    }

    public String getLocalizedName(String locale) {
        return this._localizations.get(locale);
    }

    public boolean hasCustomItemModel() {
        return this._customItemModel;
    }

    public String modelPath() {
        return this._modelPath;
    }
}

