/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemistry.common.network.jei;

import com.smashingmods.alchemistry.Alchemistry;
import com.smashingmods.alchemistry.client.jei.RecipeTypes;
import com.smashingmods.alchemistry.common.block.fission.FissionControllerBlockEntity;
import com.smashingmods.alchemistry.common.block.fission.FissionControllerMenu;
import com.smashingmods.alchemistry.common.network.jei.TransferUtils;
import com.smashingmods.alchemistry.common.recipe.fission.FissionRecipe;
import com.smashingmods.alchemistry.registry.MenuRegistry;
import com.smashingmods.alchemistry.registry.RecipeRegistry;
import com.smashingmods.alchemylib.api.network.AlchemyPacket;
import com.smashingmods.alchemylib.api.recipe.AbstractProcessingRecipe;
import com.smashingmods.alchemylib.api.storage.ProcessingSlotHandler;
import java.util.Objects;
import java.util.Optional;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class FissionTransferPacket
implements AlchemyPacket {
    private final BlockPos blockPos;
    private final ItemStack input;
    private final boolean maxTransfer;

    public FissionTransferPacket(BlockPos pBlockPos, ItemStack pInput, boolean pMaxTransfer) {
        this.blockPos = pBlockPos;
        this.input = pInput;
        this.maxTransfer = pMaxTransfer;
    }

    public FissionTransferPacket(FriendlyByteBuf pBuffer) {
        this.blockPos = pBuffer.m_130135_();
        this.input = pBuffer.m_130267_();
        this.maxTransfer = pBuffer.readBoolean();
    }

    public void encode(FriendlyByteBuf pBuffer) {
        pBuffer.m_130064_(this.blockPos);
        pBuffer.m_130055_(this.input);
        pBuffer.writeBoolean(this.maxTransfer);
    }

    public void handle(NetworkEvent.Context pContext) {
        ServerPlayer player = pContext.getSender();
        Objects.requireNonNull(player);
        FissionControllerBlockEntity blockEntity = (FissionControllerBlockEntity)player.m_9236_().m_7702_(this.blockPos);
        Objects.requireNonNull(blockEntity);
        ProcessingSlotHandler inputHandler = blockEntity.getInputHandler();
        ProcessingSlotHandler outputHander = blockEntity.getOutputHandler();
        Inventory inventory = player.m_150109_();
        RecipeRegistry.getFissionRecipe(recipe -> ItemStack.m_150942_((ItemStack)recipe.getInput(), (ItemStack)this.input), (Level)player.m_9236_()).ifPresent(recipe -> {
            boolean canTransfer;
            FissionRecipe recipeCopy = recipe.copy();
            inputHandler.emptyToInventory(inventory);
            outputHander.emptyToInventory(inventory);
            boolean creative = player.f_8941_.m_9295_();
            boolean bl = canTransfer = (inventory.m_36063_(recipeCopy.getInput()) || creative) && inputHandler.isEmpty() && outputHander.isEmpty();
            if (canTransfer) {
                if (creative) {
                    int maxOperations = TransferUtils.getMaxOperations(recipeCopy.getInput(), this.maxTransfer);
                    inputHandler.setOrIncrement(0, new ItemStack((ItemLike)recipeCopy.getInput().m_41720_(), recipeCopy.getInput().m_41613_() * maxOperations));
                } else {
                    int slot = inventory.m_36030_(recipeCopy.getInput());
                    int maxOperations = TransferUtils.getMaxOperations(recipeCopy.getInput(), inventory.m_8020_(slot), this.maxTransfer, false);
                    inventory.m_7407_(slot, recipeCopy.getInput().m_41613_() * maxOperations);
                    inputHandler.setOrIncrement(0, new ItemStack((ItemLike)recipeCopy.getInput().m_41720_(), recipeCopy.getInput().m_41613_() * maxOperations));
                }
                blockEntity.setProgress(0);
                blockEntity.setRecipe(recipe);
            }
        });
    }

    public static class TransferHandler
    implements IRecipeTransferHandler<FissionControllerMenu, FissionRecipe> {
        public Class<FissionControllerMenu> getContainerClass() {
            return FissionControllerMenu.class;
        }

        public Optional<MenuType<FissionControllerMenu>> getMenuType() {
            return Optional.of((MenuType)MenuRegistry.FISSION_CONTROLLER_MENU.get());
        }

        public RecipeType<FissionRecipe> getRecipeType() {
            return RecipeTypes.FISSION;
        }

        @Nullable
        public IRecipeTransferError transferRecipe(FissionControllerMenu pContainer, FissionRecipe pRecipe, IRecipeSlotsView pRecipeSlots, Player pPlayer, boolean pMaxTransfer, boolean pDoTransfer) {
            if (pDoTransfer) {
                pContainer.getBlockEntity().setRecipe((AbstractProcessingRecipe)pRecipe);
                Alchemistry.PACKET_HANDLER.sendToServer(new FissionTransferPacket(pContainer.getBlockEntity().m_58899_(), pRecipe.getInput(), pMaxTransfer));
            }
            return null;
        }
    }
}

