/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemistry.datagen.recipe.compactor;

import com.smashingmods.alchemistry.datagen.recipe.compactor.CompactorRecipeResult;
import com.smashingmods.alchemylib.api.item.IngredientStack;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class CompactorRecipeBuilder
implements RecipeBuilder {
    private String group;
    private final IngredientStack input;
    private final ItemStack result;
    private final ResourceLocation recipeId;
    private final Advancement.Builder advancementBuilder = Advancement.Builder.m_138353_();

    public CompactorRecipeBuilder(IngredientStack pInput, ItemStack pResult, ResourceLocation pRecipeId) {
        this.input = pInput;
        this.result = pResult;
        this.recipeId = pRecipeId;
    }

    public static CompactorRecipeBuilder createRecipe(IngredientStack pInput, ItemStack pOutput, ResourceLocation pRecipeId) {
        return new CompactorRecipeBuilder(pInput, pOutput, pRecipeId);
    }

    public RecipeBuilder m_126132_(String pCriterionName, CriterionTriggerInstance pCriterionTrigger) {
        this.advancementBuilder.m_138386_(pCriterionName, pCriterionTrigger).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)new ResourceLocation("alchemistry", this.recipeId.m_135815_()))).m_138360_(RequirementsStrategy.f_15979_);
        return this;
    }

    public RecipeBuilder m_126145_(@Nullable String pGroupName) {
        this.group = pGroupName;
        return this;
    }

    public Item m_142372_() {
        return this.result.m_41720_();
    }

    public void m_126140_(Consumer<FinishedRecipe> pFinishedRecipeConsumer, ResourceLocation pRecipeId) {
        Objects.requireNonNull(this.result.m_41720_().m_41471_());
        String advancementPath = String.format("recipes/compactor/%s", pRecipeId.m_135815_());
        ResourceLocation recipeId = new ResourceLocation("alchemistry", String.format("compactor/%s", pRecipeId.m_135815_()));
        ResourceLocation advancementId = new ResourceLocation("alchemistry", advancementPath);
        pFinishedRecipeConsumer.accept(new CompactorRecipeResult(this.group, this.advancementBuilder, recipeId, advancementId, this.input, this.result));
    }
}

