/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemistry.datagen.recipe.compactor;

import com.google.common.collect.Lists;
import com.smashingmods.alchemistry.datagen.recipe.compactor.CompactorRecipeBuilder;
import com.smashingmods.alchemylib.api.item.IngredientStack;
import com.smashingmods.alchemylib.datagen.DatagenHelpers;
import com.smashingmods.chemlib.api.ChemicalItemType;
import com.smashingmods.chemlib.api.MatterState;
import com.smashingmods.chemlib.api.MetalType;
import com.smashingmods.chemlib.common.items.CompoundItem;
import com.smashingmods.chemlib.common.items.ElementItem;
import com.smashingmods.chemlib.registry.ItemRegistry;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.Registry;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.ForgeRegistries;

public class CompactorRecipeProvider {
    private final Consumer<FinishedRecipe> consumer;

    public CompactorRecipeProvider(Consumer<FinishedRecipe> pConsumer) {
        this.consumer = pConsumer;
    }

    public static void register(Consumer<FinishedRecipe> pConsumer) {
        new CompactorRecipeProvider(pConsumer).register();
    }

    private void register() {
        Optional output;
        for (ElementItem element : ItemRegistry.getElements()) {
            if (!element.getMetalType().equals((Object)MetalType.METAL) || element.isArtificial()) continue;
            output = ItemRegistry.getChemicalItemByNameAndType((String)element.getChemicalName(), (ChemicalItemType)ChemicalItemType.DUST);
            output.ifPresent(chemicalItem -> this.compactor(new ItemStack((ItemLike)element, 16), (ItemLike)chemicalItem));
        }
        for (CompoundItem compound : ItemRegistry.getCompounds()) {
            if (!compound.getMatterState().equals((Object)MatterState.SOLID)) continue;
            output = ItemRegistry.getChemicalItemByNameAndType((String)compound.getChemicalName(), (ChemicalItemType)ChemicalItemType.COMPOUND);
            output.ifPresent(chemicalItem -> this.compactor(new ItemStack((ItemLike)compound, 8), (ItemLike)chemicalItem));
        }
        List<Item> logs = Stream.of(Items.f_41837_, Items.f_41838_, Items.f_41839_, Items.f_41840_, Items.f_41842_, Items.f_41841_).toList();
        ItemRegistry.getCompoundByName((String)"cellulose").ifPresent(cellulose -> {
            for (Item log : logs) {
                this.compactor((ItemLike)cellulose, (ItemLike)log);
            }
            this.compactor((ItemLike)cellulose, (ItemLike)Items.f_41911_);
            this.compactor((ItemLike)cellulose, new ItemStack((ItemLike)Items.f_42516_));
            this.compactor((ItemLike)cellulose, new ItemStack((ItemLike)Items.f_42094_));
        });
        ItemRegistry.getCompoundByName((String)"silicon_dioxide").ifPresent(siliconDioxide -> {
            List<Item> silicates = Stream.of(Items.f_41832_, Items.f_42594_, Items.f_41905_, Items.f_41958_, Items.f_42064_, Items.f_42170_).toList();
            for (Item silicate : silicates) {
                this.compactor((ItemLike)siliconDioxide, (ItemLike)silicate);
            }
            this.compactor(new ItemStack((ItemLike)siliconDioxide, 4), (ItemLike)Items.f_41830_);
            this.compactor(new ItemStack((ItemLike)siliconDioxide, 3), (ItemLike)Items.f_42484_);
        });
        ItemRegistry.getCompoundByName((String)"calcium_carbonate").ifPresent(carbonate -> {
            this.compactor((ItemLike)carbonate, new ItemStack((ItemLike)Items.f_151047_));
            this.compactor((ItemLike)carbonate, (ItemLike)Items.f_151087_);
        });
        ItemRegistry.getCompoundByName((String)"kaolinite").ifPresent(kaolinite -> {
            this.compactor((ItemLike)kaolinite, (ItemLike)Items.f_42461_);
            this.compactor(new ItemStack((ItemLike)kaolinite, 4), (ItemLike)Items.f_41983_);
        });
        ItemRegistry.getCompoundByName((String)"mercury_sulfide").ifPresent(mercurySulfide -> this.compactor(new ItemStack((ItemLike)mercurySulfide, 4), (ItemLike)Items.f_42497_));
        ItemRegistry.getCompoundByName((String)"arsenic_sulfide").ifPresent(arsenicSulfide -> this.compactor(new ItemStack((ItemLike)arsenicSulfide, 4), (ItemLike)Items.f_42489_));
        ItemRegistry.getCompoundByName((String)"nickel_chloride").ifPresent(nickelChloride -> this.compactor(new ItemStack((ItemLike)nickelChloride, 4), (ItemLike)Items.f_42496_));
        ItemRegistry.getCompoundByName((String)"chromium_oxide").ifPresent(chromiumOxide -> this.compactor(new ItemStack((ItemLike)chromiumOxide, 4), (ItemLike)Items.f_42540_));
        ItemRegistry.getCompoundByName((String)"potassium_permanganate").ifPresent(potassiumPermanganate -> this.compactor(new ItemStack((ItemLike)potassiumPermanganate, 4), (ItemLike)Items.f_42493_));
        ItemRegistry.getCompoundByName((String)"lead_iodide").ifPresent(leadIodide -> this.compactor(new ItemStack((ItemLike)leadIodide, 4), (ItemLike)Items.f_42539_));
        ItemRegistry.getCompoundByName((String)"potassium_dichromate").ifPresent(potassiumDichromate -> this.compactor(new ItemStack((ItemLike)potassiumDichromate, 4), (ItemLike)Items.f_42536_));
        ItemRegistry.getCompoundByName((String)"titanium_oxide").ifPresent(titaniumOxide -> this.compactor(new ItemStack((ItemLike)titaniumOxide, 4), (ItemLike)Items.f_42498_));
        ItemRegistry.getCompoundByName((String)"barium_sulfate").ifPresent(bariumSulfate -> this.compactor(new ItemStack((ItemLike)bariumSulfate, 4), (ItemLike)Items.f_42490_));
        ItemRegistry.getCompoundByName((String)"han_purple").ifPresent(hanPurple -> this.compactor(new ItemStack((ItemLike)hanPurple, 4), (ItemLike)Items.f_42537_));
        ItemRegistry.getCompoundByName((String)"cobalt_aluminate").ifPresent(cobaltAluminate -> this.compactor(new ItemStack((ItemLike)cobaltAluminate, 4), (ItemLike)Items.f_42538_));
        ItemRegistry.getCompoundByName((String)"magnesium_sulfate").ifPresent(magnesiumSulfate -> this.compactor(new ItemStack((ItemLike)magnesiumSulfate, 4), (ItemLike)Items.f_42491_));
        ItemRegistry.getCompoundByName((String)"copper_chloride").ifPresent(copperChloride -> this.compactor(new ItemStack((ItemLike)copperChloride, 4), (ItemLike)Items.f_42492_));
        ItemRegistry.getCompoundByName((String)"hydroxylapatite").ifPresent(hydroxlapatite -> this.compactor(new ItemStack((ItemLike)hydroxlapatite, 2), new ItemStack((ItemLike)Items.f_42499_, 3)));
        ItemRegistry.getCompoundByName((String)"hydroxylapatite").ifPresent(hydroxlapatite -> this.compactor(new ItemStack((ItemLike)hydroxlapatite, 6), (ItemLike)Items.f_42262_));
        ItemRegistry.getCompoundByName((String)"sucrose").ifPresent(sucrose -> this.compactor((ItemLike)sucrose, (ItemLike)Items.f_42501_));
        ItemRegistry.getCompoundByName((String)"sucrose").ifPresent(sucrose -> this.compactor((ItemLike)sucrose, (ItemLike)Items.f_41909_));
        ItemRegistry.getCompoundByName((String)"graphite").ifPresent(graphite -> {
            ItemRegistry.getElementByName((String)"carbon").ifPresent(carbon -> this.compactor(new ItemStack((ItemLike)carbon, 4), new ItemStack((ItemLike)graphite)));
            this.compactor(new ItemStack((ItemLike)graphite, 2), new ItemStack((ItemLike)Items.f_42413_));
            this.compactor(new ItemStack((ItemLike)graphite, 2), new ItemStack((ItemLike)Items.f_42414_));
        });
        ItemRegistry.getChemicalItemByNameAndType((String)"graphite", (ChemicalItemType)ChemicalItemType.COMPOUND).ifPresent(graphite -> this.compactor(new ItemStack((ItemLike)graphite, 16), (ItemLike)Items.f_42415_));
        ItemRegistry.getCompoundByName((String)"phosphorus").ifPresent(phosphorus -> {
            this.compactor(new ItemStack((ItemLike)phosphorus, 4), new ItemStack((ItemLike)Items.f_42525_));
            this.compactor(new ItemStack((ItemLike)phosphorus, 16), new ItemStack((ItemLike)Items.f_42054_));
        });
        ItemRegistry.getCompoundByName((String)"water").ifPresent(water -> {
            this.compactor(new ItemStack((ItemLike)water, 4), (ItemLike)Items.f_42452_);
            this.compactor(new ItemStack((ItemLike)water, 16), (ItemLike)Items.f_41979_);
            this.compactor(new ItemStack((ItemLike)water, 16), (ItemLike)Items.f_41980_);
            this.compactor(new ItemStack((ItemLike)Items.f_41980_, 9), (ItemLike)Items.f_42201_);
            this.compactor(new ItemStack((ItemLike)Items.f_42201_, 9), (ItemLike)Items.f_42363_);
        });
        ItemRegistry.getCompoundByName((String)"protein").ifPresent(protein -> {
            this.compactor(new ItemStack((ItemLike)protein, 3), (ItemLike)Items.f_42454_);
            this.compactor(new ItemStack((ItemLike)protein, 3), (ItemLike)Items.f_42583_);
            for (Item item : Lists.newArrayList((Object[])new Item[]{Items.f_42579_, Items.f_42485_, Items.f_42658_, Items.f_42581_, Items.f_42697_})) {
                this.compactor(new ItemStack((ItemLike)protein, 4), new ItemStack((ItemLike)item));
            }
        });
        ItemRegistry.getCompoundByName((String)"keratin").ifPresent(keratin -> {
            this.compactor(new ItemStack((ItemLike)keratin, 2), (ItemLike)Items.f_42402_);
            this.compactor((ItemLike)keratin, new ItemStack((ItemLike)Items.f_42401_, 2));
        });
        ItemRegistry.getCompoundByName((String)"polyvinyl_chloride").ifPresent(pvc -> ItemRegistry.getChemicalItemByNameAndType((String)"polyvinyl_chloride", (ChemicalItemType)ChemicalItemType.PLATE).ifPresent(plate -> this.compactor(new ItemStack((ItemLike)pvc, 8), new ItemStack((ItemLike)plate))));
    }

    public void compactor(ItemStack pInput, ItemStack pOutput) {
        this.compactor(new IngredientStack(pInput), pOutput, Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)pOutput.m_41720_())));
    }

    public void compactor(ItemLike pInput, ItemStack pOutput) {
        this.compactor(new IngredientStack(pInput), pOutput, Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)pOutput.m_41720_())));
    }

    public void compactor(ItemLike pInput, ItemLike pOutput) {
        this.compactor(new IngredientStack(pInput), new ItemStack(pOutput), Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)pOutput.m_5456_())));
    }

    public void compactor(ItemStack pInput, ItemLike pOutput) {
        this.compactor(new IngredientStack(pInput), new ItemStack(pOutput), Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)pOutput.m_5456_())));
    }

    private void compactor(String pInputTag, ItemStack pOutput) {
        TagKey tagKey = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation(pInputTag));
        Ingredient ingredient = Ingredient.m_204132_((TagKey)tagKey);
        this.compactor(ingredient, pOutput);
    }

    private void compactor(String pInputTag, int pCount, ItemStack pOutput) {
        TagKey tagKey = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation(pInputTag));
        this.compactor(new IngredientStack(Ingredient.m_204132_((TagKey)tagKey), pCount), pOutput, Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)pOutput.m_41720_())));
    }

    public void compactor(Ingredient pInput, ItemStack pOutput) {
        this.compactor(new IngredientStack(pInput), pOutput, Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)pOutput.m_41720_())));
    }

    private void compactor(String pInputTag, ItemLike pItemLike, ICondition pCondition) {
        this.compactor(pInputTag, new ItemStack(pItemLike), pCondition);
    }

    private void compactor(String pInputTag, ItemStack pOutput, ICondition pCondition) {
        this.compactor(pInputTag, 1, pOutput, pCondition);
    }

    private void compactor(String pInputTag, int pCount, ItemStack pOutput, ICondition pCondition) {
        TagKey tagKey = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation(pInputTag));
        this.compactor(new IngredientStack(Ingredient.m_204132_((TagKey)tagKey), pCount), pOutput, pCondition);
    }

    private void compactor(IngredientStack pInput, ItemStack pOutput, ICondition pCondition) {
        ResourceLocation recipeId = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)pOutput.m_41720_()));
        ConditionalRecipe.builder().addCondition(pCondition).addRecipe(arg_0 -> ((RecipeBuilder)CompactorRecipeBuilder.createRecipe(pInput, pOutput, recipeId).m_126145_(String.format("%s:compactor", "alchemistry")).m_126132_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)DatagenHelpers.getLocation((ItemStack)pOutput, (String)"compactor", (String)"alchemistry")))).m_176498_(arg_0)).build(this.consumer, new ResourceLocation("alchemistry", String.format("compactor/%s", recipeId.m_135815_())));
    }

    public void compactor(IngredientStack pInput, ItemStack pOutput, ResourceLocation pRecipeId) {
        CompactorRecipeBuilder.createRecipe(pInput, pOutput, pRecipeId).m_126145_(String.format("%s:compactor", "alchemistry")).m_126132_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)DatagenHelpers.getLocation((ItemStack)pOutput, (String)"compactor", (String)"alchemistry"))).m_176498_(this.consumer);
    }
}

