/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemistry.datagen.recipe.dissolver;

import com.smashingmods.alchemistry.common.recipe.dissolver.ProbabilityGroup;
import com.smashingmods.alchemistry.common.recipe.dissolver.ProbabilitySet;
import com.smashingmods.alchemistry.datagen.recipe.combiner.CombinerRecipeBuilder;
import com.smashingmods.alchemistry.datagen.recipe.dissolver.ChemlibRecipes;
import com.smashingmods.alchemistry.datagen.recipe.dissolver.DissolverRecipeBuilder;
import com.smashingmods.alchemistry.datagen.recipe.dissolver.MinecraftRecipes;
import com.smashingmods.alchemistry.datagen.recipe.dissolver.ThermalRecipes;
import com.smashingmods.alchemylib.api.item.IngredientStack;
import com.smashingmods.alchemylib.datagen.DatagenHelpers;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.Registry;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.ForgeRegistries;

public class DissolverRecipeProvider {
    private final Consumer<FinishedRecipe> consumer;

    public DissolverRecipeProvider(Consumer<FinishedRecipe> pConsumer) {
        this.consumer = pConsumer;
    }

    public static void register(Consumer<FinishedRecipe> pConsumer) {
        new DissolverRecipeProvider(pConsumer).register();
    }

    private void register() {
        ChemlibRecipes.register(this.consumer);
        MinecraftRecipes.register(this.consumer);
        ThermalRecipes.register(this.consumer);
    }

    public void dissolver(ItemLike pItemLike, ProbabilitySet pSet) {
        this.dissolver(pItemLike, pSet, false);
    }

    public void dissolver(ItemLike pItemLike, ProbabilitySet pSet, boolean pReversible) {
        this.dissolver(new IngredientStack(pItemLike), pSet, Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)pItemLike.m_5456_())));
        if (pReversible) {
            ItemStack output = new ItemStack(pItemLike);
            List<Object> items = new ArrayList();
            pSet.getProbabilityGroups().stream().map(ProbabilityGroup::getOutput).forEach(items::addAll);
            if (items.size() <= 4) {
                items = items.stream().filter(itemStack -> !itemStack.m_41619_()).toList();
                ArrayList<IngredientStack> ingredientStackList = new ArrayList<IngredientStack>();
                for (ItemStack itemStack2 : items) {
                    ingredientStackList.add(new IngredientStack(itemStack2));
                }
                ResourceLocation recipeId = DatagenHelpers.getLocation((ItemStack)output, (String)"combiner", (String)"alchemistry");
                CombinerRecipeBuilder.createRecipe(output, ingredientStackList, Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)output.m_41720_()))).m_126145_(String.format("%s:combiner", "alchemistry")).m_126132_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)recipeId)).m_176498_(this.consumer);
            }
        }
    }

    public void dissolver(String pItemTag, ProbabilitySet pSet) {
        ResourceLocation itemId = new ResourceLocation(pItemTag);
        TagKey tagKey = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)itemId);
        this.dissolver(new IngredientStack(Ingredient.m_204132_((TagKey)tagKey)), pSet, itemId);
    }

    public void dissolver(String pItemTag, ProbabilitySet pSet, ICondition pCondition) {
        ResourceLocation itemId = new ResourceLocation(pItemTag);
        TagKey tagKey = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)itemId);
        this.dissolver(new IngredientStack(Ingredient.m_204132_((TagKey)tagKey)), pSet, itemId, pCondition);
    }

    public void dissolver(IngredientStack pIngredient, ProbabilitySet pSet, ResourceLocation pRecipeId, ICondition pCondition) {
        ConditionalRecipe.builder().addCondition(pCondition).addRecipe(arg_0 -> ((RecipeBuilder)DissolverRecipeBuilder.createRecipe(pIngredient, pSet, pRecipeId).m_126145_(String.format("%s:dissolver", "alchemistry")).m_126132_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)pRecipeId))).m_176498_(arg_0)).build(this.consumer, new ResourceLocation("alchemistry", String.format("dissolver/%s", pRecipeId.m_135815_())));
    }

    public void dissolver(IngredientStack pIngredient, ProbabilitySet pSet, ResourceLocation pRecipeId) {
        DissolverRecipeBuilder.createRecipe(pIngredient, pSet, pRecipeId).m_126145_(String.format("%s:dissolver", "alchemistry")).m_126132_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)pRecipeId)).m_126140_(this.consumer, pRecipeId);
    }
}

