/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemistry.datagen.recipe.fission;

import com.smashingmods.alchemistry.datagen.recipe.fission.FissionRecipeResult;
import com.smashingmods.chemlib.common.items.ElementItem;
import com.smashingmods.chemlib.registry.ItemRegistry;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class FissionRecipeBuilder
implements RecipeBuilder {
    private String group;
    private final ElementItem input;
    private final ItemStack output1;
    private final ItemStack output2;
    private final Advancement.Builder advancementBuilder = Advancement.Builder.m_138353_();

    public FissionRecipeBuilder(ElementItem pInput) {
        this.input = pInput;
        int inputAtomicNumber = pInput.getAtomicNumber();
        this.output1 = inputAtomicNumber % 2 == 0 ? ItemRegistry.getElementByAtomicNumber((int)(inputAtomicNumber / 2)).map(ItemStack::new).orElse(ItemStack.f_41583_) : ItemRegistry.getElementByAtomicNumber((int)(inputAtomicNumber / 2 + 1)).map(ItemStack::new).orElse(ItemStack.f_41583_);
        this.output2 = ItemRegistry.getElementByAtomicNumber((int)(inputAtomicNumber / 2)).map(ItemStack::new).orElse(ItemStack.f_41583_);
    }

    public static FissionRecipeBuilder createRecipe(ElementItem pInput) {
        return new FissionRecipeBuilder(pInput);
    }

    public RecipeBuilder m_126132_(String pCriterionName, CriterionTriggerInstance pCriterionTrigger) {
        this.advancementBuilder.m_138386_(pCriterionName, pCriterionTrigger).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)new ResourceLocation("alchemistry", Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)this.input)).m_135815_()))).m_138360_(RequirementsStrategy.f_15979_);
        return this;
    }

    public RecipeBuilder m_126145_(@Nullable String pGroupName) {
        this.group = pGroupName;
        return this;
    }

    public Item m_142372_() {
        return this.input;
    }

    public void m_126140_(Consumer<FinishedRecipe> pFinishedRecipeConsumer, ResourceLocation pRecipeId) {
        ResourceLocation recipeId = new ResourceLocation("alchemistry", String.format("fission/%s", pRecipeId.m_135815_()));
        ResourceLocation advancementId = new ResourceLocation("alchemistry", String.format("recipes/fission/%s", pRecipeId.m_135815_()));
        pFinishedRecipeConsumer.accept(new FissionRecipeResult(this.group, this.advancementBuilder, recipeId, advancementId, this.input, this.output1, this.output2));
    }
}

