/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemylib.api.blockentity.container;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.smashingmods.alchemylib.api.blockentity.container.AbstractProcessingMenu;
import com.smashingmods.alchemylib.api.blockentity.container.Direction2D;
import com.smashingmods.alchemylib.api.blockentity.container.RecipeDisplayUtil;
import com.smashingmods.alchemylib.api.blockentity.container.data.AbstractDisplayData;
import com.smashingmods.alchemylib.api.blockentity.container.data.EnergyDisplayData;
import com.smashingmods.alchemylib.api.blockentity.container.data.FluidDisplayData;
import com.smashingmods.alchemylib.api.blockentity.container.data.ProgressDisplayData;
import com.smashingmods.alchemylib.api.blockentity.processing.AbstractProcessingBlockEntity;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;

public abstract class AbstractProcessingScreen<M extends AbstractProcessingMenu>
extends AbstractContainerScreen<M> {
    private final AbstractProcessingBlockEntity blockEntity;
    protected final LinkedList<AbstractWidget> widgets = new LinkedList();

    public AbstractProcessingScreen(M pMenu, Inventory pPlayerInventory, Component pTitle) {
        super(pMenu, pPlayerInventory, pTitle);
        this.f_97726_ = 184;
        this.f_97727_ = 162;
        this.blockEntity = ((AbstractProcessingMenu)((Object)pMenu)).getBlockEntity();
    }

    protected void m_7856_() {
        this.f_97735_ = (this.f_96543_ - this.f_97726_) / 2;
        this.f_97736_ = (this.f_96544_ - this.f_97727_) / 2;
        super.m_7856_();
    }

    public void m_6305_(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_7333_(pPoseStack);
        this.m_7286_(pPoseStack, pPartialTick, pMouseX, pMouseY);
        super.m_6305_(pPoseStack, pMouseX, pMouseY, pPartialTick);
        for (int index = 0; index < this.widgets.size(); ++index) {
            this.renderWidget(this.widgets.get(index), this.f_97735_ - 24, this.f_97736_ + index * 24);
        }
    }

    public void drawFluidTank(FluidDisplayData pData) {
        if (pData.getValue() > 0) {
            FluidStack fluidStack = pData.getFluidHandler().getFluidStack();
            IClientFluidTypeExtensions fluidTypeExtensions = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
            AbstractProcessingScreen.setShaderColor(fluidTypeExtensions.getTintColor());
            TextureAtlasSprite icon = AbstractProcessingScreen.getResourceTexture(fluidTypeExtensions.getStillTexture());
            this.drawTexture(pData, icon, this.f_97735_ + pData.getX(), this.f_97736_ + pData.getY());
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public void drawTexture(AbstractDisplayData pData, TextureAtlasSprite pSprite, int pTextureX, int pTextureY) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        int renderAmount = Math.max(Math.min(pData.getHeight(), pData.getValue() * pData.getHeight() / pData.getMaxValue()), 1);
        int posY = pTextureY + pData.getHeight() - renderAmount;
        float minU = pSprite.m_118409_();
        float maxU = pSprite.m_118410_();
        float minV = pSprite.m_118411_();
        float maxV = pSprite.m_118412_();
        for (int width = 0; width < pData.getWidth(); ++width) {
            for (int height = 0; height < pData.getHeight(); ++height) {
                int drawHeight = Math.min(renderAmount - height, 16);
                int drawWidth = Math.min(pData.getWidth() - width, 16);
                int x1 = pTextureX + width;
                float x2 = x1 + drawWidth;
                int y1 = posY + height;
                float y2 = y1 + drawHeight;
                float scaleV = minV + (maxV - minV) * (float)drawHeight / 16.0f;
                float scaleU = minU + (maxU - minU) * (float)drawWidth / 16.0f;
                float blitOffset = 0.0f;
                Tesselator tesselator = Tesselator.m_85913_();
                BufferBuilder bufferBuilder = tesselator.m_85915_();
                bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                bufferBuilder.m_5483_((double)x1, (double)y2, (double)blitOffset).m_7421_(minU, scaleV).m_5752_();
                bufferBuilder.m_5483_((double)x2, (double)y2, (double)blitOffset).m_7421_(scaleU, scaleV).m_5752_();
                bufferBuilder.m_5483_((double)x2, (double)y1, (double)blitOffset).m_7421_(scaleU, minV).m_5752_();
                bufferBuilder.m_5483_((double)x1, (double)y1, (double)blitOffset).m_7421_(minU, minV).m_5752_();
                tesselator.m_85914_();
                height += 15;
            }
            width += 16;
        }
    }

    public static TextureAtlasSprite getResourceTexture(ResourceLocation pResourceLocation) {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(pResourceLocation);
    }

    public static void setShaderColor(int pColor) {
        float alpha = (float)(pColor >> 24 & 0xFF) / 255.0f;
        float red = (float)(pColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(pColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(pColor & 0xFF) / 255.0f;
        RenderSystem.m_157429_((float)red, (float)green, (float)blue, (float)alpha);
    }

    public static int getScaled(int pPixels, int pValue, int pMaxValue) {
        if (pValue > 0 && pMaxValue > 0) {
            return pValue * pPixels / pMaxValue;
        }
        return 0;
    }

    public void drawEnergyBar(PoseStack pPoseStack, EnergyDisplayData pData) {
        int x = pData.getX() + (this.f_96543_ - this.f_97726_) / 2;
        int y = pData.getY() + (this.f_96544_ - this.f_97727_) / 2;
        this.directionalBlit(pPoseStack, x, y + pData.getHeight(), 0, 0, pData.getWidth(), pData.getHeight(), pData.getValue(), pData.getMaxValue(), Direction2D.UP, true);
    }

    private void directionalBlit(PoseStack pPoseStack, int pX, int pY, int pUOffset, int pVOffset, int pU, int pV, int pValue, int pMaxValue, Direction2D pDirection2D) {
        this.directionalBlit(pPoseStack, pX, pY, pUOffset, pVOffset, pU, pV, pValue, pMaxValue, pDirection2D, false);
    }

    private void directionalBlit(PoseStack pPoseStack, int pX, int pY, int pUOffset, int pVOffset, int pU, int pV, int pValue, int pMaxValue, Direction2D pDirection2D, boolean pScaleOffset) {
        int x = pX;
        int y = pY;
        int uOffset = pUOffset;
        int vOffset = pVOffset;
        int uWidth = pU;
        int vHeight = pV;
        int pVScaled = AbstractProcessingScreen.getScaled(pV, pValue, pMaxValue);
        int pVScalePercent = (int)((float)pV * 1.8f - (float)pVScaled * 1.8f);
        int finalVOffset = pScaleOffset ? pVScalePercent : pVOffset + pV - pVScaled;
        switch (pDirection2D) {
            case LEFT: {
                x = pX - pVScaled;
                uOffset = pU - pVScaled;
                uWidth = pVScaled;
                break;
            }
            case UP: {
                y = pY - pVScaled;
                vOffset = finalVOffset;
                vHeight = pVScaled;
                break;
            }
            case RIGHT: {
                uWidth = pVScaled;
                vHeight = pU;
                break;
            }
            case DOWN: {
                vHeight = pVScaled;
            }
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)new ResourceLocation("alchemylib", "textures/gui/widgets.png"));
        this.m_93228_(pPoseStack, x, y, uOffset, vOffset, uWidth, vHeight);
    }

    public void directionalArrow(PoseStack pPoseStack, int pX, int pY, ProgressDisplayData pData) {
        int uOffset = 0;
        int vOffset = 100;
        int width = 0;
        int height = 0;
        switch (pData.getDirection()) {
            case LEFT: {
                height = 9;
                width = 30;
                break;
            }
            case UP: {
                vOffset += 18;
                height = 9;
                width = 30;
                break;
            }
            case RIGHT: {
                vOffset += 9;
                height = 9;
                width = 30;
                break;
            }
            case DOWN: {
                uOffset += 9;
                vOffset += 18;
                height = 9;
                width = 30;
            }
        }
        this.directionalBlit(pPoseStack, pX + pData.getX(), pY + pData.getY(), uOffset, vOffset, height, width, pData.getValue(), pData.getMaxValue(), pData.getDirection());
    }

    public void renderDisplayData(List<AbstractDisplayData> pDisplayData, PoseStack pPoseStack, int pX, int pY) {
        pDisplayData.forEach(data -> {
            if (data instanceof ProgressDisplayData) {
                ProgressDisplayData progressData = (ProgressDisplayData)data;
                this.directionalArrow(pPoseStack, pX, pY, progressData);
            }
            if (data instanceof EnergyDisplayData) {
                EnergyDisplayData energyData = (EnergyDisplayData)data;
                this.drawEnergyBar(pPoseStack, energyData);
            }
            if (data instanceof FluidDisplayData) {
                FluidDisplayData fluidData = (FluidDisplayData)data;
                this.drawFluidTank(fluidData);
            }
        });
    }

    public void renderDisplayTooltip(List<AbstractDisplayData> pDisplayData, PoseStack pPoseStack, int pX, int pY, int pMouseX, int pMouseY) {
        pDisplayData.stream().filter(data -> pMouseX >= data.getX() + pX && pMouseX <= data.getX() + pX + data.getWidth() && pMouseY >= data.getY() + pY && pMouseY <= data.getY() + pY + data.getHeight()).forEach(data -> {
            if (!(data instanceof ProgressDisplayData)) {
                this.m_96602_(pPoseStack, (Component)data.toTextComponent(), pMouseX, pMouseY);
            }
        });
    }

    public void renderItemTooltip(PoseStack pPoseStack, ItemStack pItemStack, MutableComponent pComponent, int pMouseX, int pMouseY) {
        this.m_169388_(pPoseStack, RecipeDisplayUtil.getItemTooltipComponent(pItemStack, pComponent), Optional.empty(), pMouseX, pMouseY);
    }

    public <W extends GuiEventListener & Widget> void renderWidget(W pWidget, int pX, int pY) {
        if (!this.f_169369_.contains(pWidget)) {
            if (pWidget instanceof AbstractWidget) {
                AbstractWidget widget = (AbstractWidget)pWidget;
                widget.f_93620_ = pX;
                widget.f_93621_ = pY;
            }
            this.m_142416_(pWidget);
        }
    }

    public AbstractProcessingBlockEntity getBlockEntity() {
        return this.blockEntity;
    }
}

