/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemylib.api.blockentity.processing;

import com.smashingmods.alchemylib.api.blockentity.processing.EnergyBlockEntity;
import com.smashingmods.alchemylib.api.blockentity.processing.ProcessingBlockEntity;
import com.smashingmods.alchemylib.api.storage.EnergyStorageHandler;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractProcessingBlockEntity
extends BlockEntity
implements ProcessingBlockEntity,
EnergyBlockEntity,
MenuProvider {
    private final Component name;
    private int energyPerTick = 0;
    private int maxProgress = 0;
    private int progress = 0;
    private boolean canProcess = false;
    private boolean recipeLocked = false;
    private boolean paused = false;
    private final EnergyStorageHandler energyHandler = this.initializeEnergyStorage();
    private final LazyOptional<IEnergyStorage> lazyEnergyHandler = LazyOptional.of(() -> this.energyHandler);

    public AbstractProcessingBlockEntity(String pModId, BlockEntityType<?> pBlockEntityType, BlockPos pWorldPosition, BlockState pBlockState) {
        super(pBlockEntityType, pWorldPosition, pBlockState);
        this.name = MutableComponent.m_237204_((ComponentContents)new TranslatableContents(String.format("%s.container.%s", pModId, ForgeRegistries.BLOCK_ENTITY_TYPES.getKey((Object)this.m_58903_()))));
    }

    public Component m_5446_() {
        return this.name;
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    public void onDataPacket(Connection pConnection, ClientboundBlockEntityDataPacket pPacket) {
        Objects.requireNonNull(pPacket.m_131708_());
        this.m_142466_(pPacket.m_131708_());
        super.onDataPacket(pConnection, pPacket);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Override
    public void tick() {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_() && !this.paused) {
            if (!this.recipeLocked) {
                this.updateRecipe();
            }
            if (this.canProcess) {
                this.processRecipe();
            }
        }
    }

    @Override
    public boolean getCanProcess() {
        return this.canProcess;
    }

    @Override
    public void setCanProcess(boolean pCanProcess) {
        this.canProcess = pCanProcess;
    }

    @Override
    public int getMaxProgress() {
        return this.maxProgress;
    }

    @Override
    public void setMaxProgress(int pMaxProgress) {
        this.maxProgress = pMaxProgress;
    }

    @Override
    public int getProgress() {
        return this.progress;
    }

    @Override
    public void setProgress(int pProgress) {
        this.progress = pProgress;
    }

    @Override
    public void incrementProgress() {
        ++this.progress;
    }

    @Override
    public boolean isRecipeLocked() {
        return this.recipeLocked;
    }

    @Override
    public void setRecipeLocked(boolean pRecipeLocked) {
        this.recipeLocked = pRecipeLocked;
    }

    @Override
    public boolean isProcessingPaused() {
        return this.paused;
    }

    @Override
    public void setPaused(boolean pPaused) {
        this.paused = pPaused;
    }

    @Override
    public EnergyStorageHandler getEnergyHandler() {
        return this.energyHandler;
    }

    public int getEnergyPerTick() {
        return this.energyPerTick;
    }

    public void setEnergyPerTick(int pEnergyPerTick) {
        this.energyPerTick = pEnergyPerTick;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> pCapability, @Nullable Direction pDirection) {
        if (pCapability == ForgeCapabilities.ENERGY) {
            return this.lazyEnergyHandler.cast();
        }
        return super.getCapability(pCapability, pDirection);
    }

    public void invalidateCaps() {
        this.lazyEnergyHandler.invalidate();
        super.invalidateCaps();
    }

    protected void m_183515_(CompoundTag pTag) {
        pTag.m_128405_("progress", this.progress);
        pTag.m_128379_("locked", this.isRecipeLocked());
        pTag.m_128379_("paused", this.isProcessingPaused());
        pTag.m_128365_("energy", this.energyHandler.serializeNBT());
        super.m_183515_(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.setProgress(pTag.m_128451_("progress"));
        this.setRecipeLocked(pTag.m_128471_("locked"));
        this.setPaused(pTag.m_128471_("paused"));
        this.energyHandler.deserializeNBT(pTag.m_128423_("energy"));
    }
}

