/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.utils;

import com.almostreliable.unified.AlmostUnified;
import com.almostreliable.unified.api.StoneStrataHandler;
import com.almostreliable.unified.config.UnifyConfig;
import com.almostreliable.unified.utils.TagMap;
import com.almostreliable.unified.utils.TagOwnerships;
import com.almostreliable.unified.utils.UnifyTag;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class ReplacementMap {
    private final UnifyConfig unifyConfig;
    private final TagMap<Item> tagMap;
    private final StoneStrataHandler stoneStrataHandler;
    private final TagOwnerships tagOwnerships;
    private final Set<ResourceLocation> warnings;

    public ReplacementMap(UnifyConfig unifyConfig, TagMap<Item> tagMap, StoneStrataHandler stoneStrataHandler, TagOwnerships tagOwnerships) {
        this.tagMap = tagMap;
        this.unifyConfig = unifyConfig;
        this.stoneStrataHandler = stoneStrataHandler;
        this.tagOwnerships = tagOwnerships;
        this.warnings = new HashSet<ResourceLocation>();
    }

    @Nullable
    public UnifyTag<Item> getPreferredTagForItem(ResourceLocation item) {
        Set<UnifyTag<Item>> tags = this.tagMap.getTagsByEntry(item);
        if (tags.isEmpty()) {
            return null;
        }
        if (tags.size() > 1 && !this.warnings.contains(item)) {
            AlmostUnified.LOG.warn("Item '{}' has multiple preferred tags '{}' for recipe replacement. This needs to be manually fixed by the user.", (Object)item, tags.stream().map(UnifyTag::location).toList());
            this.warnings.add(item);
        }
        return (UnifyTag)tags.iterator().next();
    }

    @Nullable
    public ResourceLocation getReplacementForItem(ResourceLocation item) {
        UnifyTag<Item> t = this.getPreferredTagForItem(item);
        if (t == null) {
            return null;
        }
        if (this.stoneStrataHandler.isStoneStrataTag(t)) {
            String stone = this.stoneStrataHandler.getStoneStrata(item);
            return this.getPreferredItemForTag(t, i -> stone.equals(this.stoneStrataHandler.getStoneStrata((ResourceLocation)i)));
        }
        return this.getPreferredItemForTag(t, i -> true);
    }

    @Nullable
    public ResourceLocation getPreferredItemForTag(UnifyTag<Item> tag, Predicate<ResourceLocation> itemFilter) {
        List<ResourceLocation> items;
        UnifyTag<Item> tagToLookup = this.tagOwnerships.getOwnerByTag(tag);
        if (tagToLookup == null) {
            tagToLookup = tag;
        }
        if ((items = this.tagMap.getEntriesByTag(tagToLookup).stream().filter(itemFilter).sorted(Comparator.comparingInt(value -> value.toString().length())).toList()).isEmpty()) {
            return null;
        }
        ResourceLocation overrideItem = this.getOverrideForTag(tagToLookup, items);
        if (overrideItem != null) {
            return overrideItem;
        }
        for (String modPriority : this.unifyConfig.getModPriorities()) {
            ResourceLocation item = this.findItemByNamespace(items, modPriority);
            if (item == null) continue;
            return item;
        }
        return null;
    }

    public boolean isItemInUnifiedIngredient(Ingredient ingred, ItemStack item) {
        HashSet<UnifyTag<Item>> checkedTags = new HashSet<UnifyTag<Item>>();
        for (ItemStack ingredItem : ingred.m_43908_()) {
            ResourceLocation itemId = Registry.f_122827_.m_7981_((Object)ingredItem.m_41720_());
            UnifyTag<Item> preferredTag = this.getPreferredTagForItem(itemId);
            if (preferredTag == null || checkedTags.contains(preferredTag)) continue;
            checkedTags.add(preferredTag);
            TagKey preferredTagKey = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)preferredTag.location());
            if (!item.m_204117_(preferredTagKey)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private ResourceLocation getOverrideForTag(UnifyTag<Item> tag, List<ResourceLocation> items) {
        String priorityOverride = this.unifyConfig.getPriorityOverrides().get(tag.location());
        if (priorityOverride != null) {
            ResourceLocation item = this.findItemByNamespace(items, priorityOverride);
            if (item != null) {
                return item;
            }
            AlmostUnified.LOG.warn("Priority override mod '{}' for tag '{}' does not contain a valid item. Falling back to default priority.", (Object)priorityOverride, (Object)tag.location());
        }
        return null;
    }

    @Nullable
    private ResourceLocation findItemByNamespace(List<ResourceLocation> items, String namespace) {
        for (ResourceLocation item : items) {
            if (!item.m_135827_().equals(namespace)) continue;
            return item;
        }
        return null;
    }

    public TagOwnerships getTagOwnerships() {
        return this.tagOwnerships;
    }
}

