/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.misc;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.implementations.blockentities.ICrankable;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.stacks.AEItemKey;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalBlockPos;
import appeng.blockentity.grid.AENetworkPowerBlockEntity;
import appeng.blockentity.misc.ChargerRecipes;
import appeng.capabilities.Capabilities;
import appeng.core.AEConfig;
import appeng.core.settings.TickRates;
import appeng.util.Platform;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.filter.IAEItemFilter;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.Nullable;

public class ChargerBlockEntity
extends AENetworkPowerBlockEntity
implements IGridTickable {
    public static final int POWER_MAXIMUM_AMOUNT = 1600;
    private static final int POWER_THRESHOLD = 1599;
    private boolean working;
    private final AppEngInternalInventory inv = new AppEngInternalInventory(this, 1, 1, new ChargerInvFilter(this));

    public ChargerBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState blockState) {
        super(blockEntityType, pos, blockState);
        this.getMainNode().setExposedOnSides(EnumSet.noneOf(Direction.class)).setFlags(new GridFlags[0]).setIdlePowerUsage(0.0).addService(IGridTickable.class, this);
        this.setInternalMaxPower(1600.0);
    }

    @Override
    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.COVERED;
    }

    @Override
    public void onReady() {
        EnumSet<Direction> validSides = EnumSet.allOf(Direction.class);
        validSides.remove(this.getForward());
        this.getMainNode().setExposedOnSides(validSides);
        super.onReady();
    }

    @Override
    protected boolean readFromStream(FriendlyByteBuf data) {
        boolean changed = super.readFromStream(data);
        this.working = data.readBoolean();
        if (data.readBoolean()) {
            AEItemKey item = AEItemKey.fromPacket(data);
            this.inv.setItemDirect(0, item.toStack());
        } else {
            this.inv.setItemDirect(0, ItemStack.f_41583_);
        }
        return changed;
    }

    @Override
    protected void writeToStream(FriendlyByteBuf data) {
        super.writeToStream(data);
        data.writeBoolean(this.working);
        AEItemKey is = AEItemKey.of(this.inv.getStackInSlot(0));
        data.writeBoolean(is != null);
        if (is != null) {
            is.writeToPacket(data);
        }
    }

    @Override
    public void setOrientation(Direction inForward, Direction inUp) {
        super.setOrientation(inForward, inUp);
        EnumSet<Direction> validSides = EnumSet.allOf(Direction.class);
        validSides.remove(this.getForward());
        this.getMainNode().setExposedOnSides(validSides);
        this.setPowerSides(validSides);
    }

    @Override
    public InternalInventory getInternalInventory() {
        return this.inv;
    }

    @Override
    public void onChangeInventory(InternalInventory inv, int slot) {
        this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().wakeDevice((IGridNode)node));
        this.markForUpdate();
    }

    public void activate(Player player) {
        if (!Platform.hasPermissions(new DimensionalBlockPos(this), player)) {
            return;
        }
        ItemStack myItem = this.inv.getStackInSlot(0);
        if (myItem.m_41619_()) {
            ItemStack held = player.m_150109_().m_36056_();
            if (ChargerRecipes.findRecipe(this.f_58857_, held) != null || Platform.isChargeable(held)) {
                held = player.m_150109_().m_7407_(player.m_150109_().f_35977_, 1);
                this.inv.setItemDirect(0, held);
            }
        } else {
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
            drops.add(myItem);
            this.inv.setItemDirect(0, ItemStack.f_41583_);
            Platform.spawnDrops(player.f_19853_, this.f_58858_.m_121945_(this.getForward()), drops);
        }
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.Charger, false, true);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        this.doWork(ticksSinceLastCall);
        return TickRateModulation.FASTER;
    }

    private void doWork(int ticksSinceLastCall) {
        boolean wasWorking = this.working;
        this.working = false;
        boolean changed = false;
        ItemStack myItem = this.inv.getStackInSlot(0);
        if (!myItem.m_41619_()) {
            if (Platform.isChargeable(myItem)) {
                double maxPower;
                IAEItemPowerStorage ps = (IAEItemPowerStorage)myItem.m_41720_();
                double currentPower = ps.getAECurrentPower(myItem);
                if (currentPower < (maxPower = ps.getAEMaxPower(myItem))) {
                    double chargeRate = ps.getChargeRate(myItem) * (double)ticksSinceLastCall * AEConfig.instance().getChargerChargeRate();
                    double extractedAmount = this.extractAEPower(chargeRate, Actionable.MODULATE, PowerMultiplier.CONFIG);
                    double missingChargeRate = chargeRate - extractedAmount;
                    double missingAEPower = maxPower - currentPower;
                    double toExtract = Math.min(missingChargeRate, missingAEPower);
                    IGrid grid2 = this.getMainNode().getGrid();
                    if (grid2 != null) {
                        extractedAmount += grid2.getEnergyService().extractAEPower(toExtract, Actionable.MODULATE, PowerMultiplier.ONE);
                    }
                    if (extractedAmount > 0.0) {
                        double adjustment = ps.injectAEPower(myItem, extractedAmount, Actionable.MODULATE);
                        this.setInternalCurrentPower(this.getInternalCurrentPower() + adjustment);
                        this.working = true;
                        changed = true;
                    }
                }
            } else if (this.getInternalCurrentPower() > 1599.0 && ChargerRecipes.findRecipe(this.f_58857_, myItem) != null) {
                this.working = true;
                if (Platform.getRandomFloat() > 0.8f) {
                    this.extractAEPower(this.getInternalMaxPower(), Actionable.MODULATE, PowerMultiplier.CONFIG);
                    Item charged = Objects.requireNonNull(ChargerRecipes.findRecipe((Level)this.f_58857_, (ItemStack)myItem)).result;
                    this.inv.setItemDirect(0, new ItemStack((ItemLike)charged));
                    changed = true;
                }
            }
        }
        if (this.getInternalCurrentPower() < 1599.0) {
            this.getMainNode().ifPresent(grid -> {
                double toExtract = Math.min(800.0, this.getInternalMaxPower() - this.getInternalCurrentPower());
                double extracted = grid.getEnergyService().extractAEPower(toExtract, Actionable.MODULATE, PowerMultiplier.ONE);
                this.injectExternalPower(PowerUnits.AE, extracted, Actionable.MODULATE);
            });
            changed = true;
        }
        if (changed || this.working != wasWorking) {
            this.markForUpdate();
        }
    }

    public boolean isWorking() {
        return this.working;
    }

    @Nullable
    public ICrankable getCrankable(Direction direction) {
        Direction up = this.getUp();
        if (direction == up || direction == up.m_122424_()) {
            return new Crankable();
        }
        return null;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (Capabilities.CRANKABLE.equals(capability)) {
            ICrankable crankable = this.getCrankable(facing);
            if (crankable == null) {
                return LazyOptional.empty();
            }
            return Capabilities.CRANKABLE.orEmpty(capability, LazyOptional.of(() -> crankable));
        }
        return super.getCapability(capability, facing);
    }

    private record ChargerInvFilter(ChargerBlockEntity chargerBlockEntity) implements IAEItemFilter
    {
        @Override
        public boolean allowInsert(InternalInventory inv, int i, ItemStack itemstack) {
            return Platform.isChargeable(itemstack) || ChargerRecipes.allowInsert(this.chargerBlockEntity.f_58857_, itemstack);
        }

        @Override
        public boolean allowExtract(InternalInventory inv, int slotIndex, int amount) {
            IAEItemPowerStorage ips;
            ItemStack extractedItem = inv.getStackInSlot(slotIndex);
            if (Platform.isChargeable(extractedItem) && (ips = (IAEItemPowerStorage)extractedItem.m_41720_()).getAECurrentPower(extractedItem) >= ips.getAEMaxPower(extractedItem)) {
                return true;
            }
            return ChargerRecipes.allowExtract(this.chargerBlockEntity.f_58857_, extractedItem);
        }
    }

    class Crankable
    implements ICrankable {
        Crankable() {
        }

        @Override
        public boolean canTurn() {
            return ChargerBlockEntity.this.getInternalCurrentPower() < ChargerBlockEntity.this.getInternalMaxPower();
        }

        @Override
        public void applyTurn() {
            ChargerBlockEntity.this.injectExternalPower(PowerUnits.AE, 160.0, Actionable.MODULATE);
        }
    }
}

