/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.compiler.tags;

import appeng.client.guidebook.compiler.PageCompiler;
import appeng.client.guidebook.compiler.tags.BlockTagCompiler;
import appeng.client.guidebook.compiler.tags.MdxAttrs;
import appeng.client.guidebook.document.block.LytBlock;
import appeng.client.guidebook.document.block.LytBlockContainer;
import appeng.client.guidebook.document.block.recipes.LytCraftingRecipe;
import appeng.client.guidebook.document.block.recipes.LytInscriberRecipe;
import appeng.libs.mdast.mdx.model.MdxJsxElementFields;
import appeng.recipes.handlers.InscriberRecipe;
import appeng.util.Platform;
import java.util.List;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class RecipeForCompiler
extends BlockTagCompiler {
    private final List<RecipeTypeMapping<?, ?>> mappings = List.of(new RecipeTypeMapping(RecipeType.f_44107_, LytCraftingRecipe::new), new RecipeTypeMapping(InscriberRecipe.TYPE, LytInscriberRecipe::new));

    @Override
    protected void compile(PageCompiler compiler, LytBlockContainer parent, MdxJsxElementFields el) {
        Pair<ResourceLocation, Item> itemAndId = MdxAttrs.getRequiredItemAndId(compiler, parent, el, "id");
        if (itemAndId == null) {
            return;
        }
        ResourceLocation id = (ResourceLocation)itemAndId.getLeft();
        Item item = (Item)itemAndId.getRight();
        RecipeManager recipeManager = Platform.getClientRecipeManager();
        if (recipeManager == null) {
            parent.appendError(compiler, "Cannot show recipe for " + id + " while not in-game", el);
            return;
        }
        for (RecipeTypeMapping<?, ?> mapping : this.mappings) {
            LytBlock block = mapping.tryCreate(recipeManager, item);
            if (block == null) continue;
            parent.append(block);
            return;
        }
        parent.appendError(compiler, "Couldn't find recipe for " + id, el);
    }

    private record RecipeTypeMapping<T extends Recipe<C>, C extends Container>(RecipeType<T> recipeType, Function<T, LytBlock> factory) {
        @Nullable
        LytBlock tryCreate(RecipeManager recipeManager, Item resultItem) {
            for (Recipe recipe : recipeManager.m_44054_(this.recipeType).values()) {
                if (recipe.m_8043_().m_41720_() != resultItem) continue;
                return this.factory.apply(recipe);
            }
            return null;
        }
    }
}

