/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu;

import appeng.items.contents.NetworkToolMenuHost;
import appeng.items.tools.NetworkToolItem;
import appeng.menu.AEBaseMenu;
import appeng.menu.SlotSemantics;
import appeng.menu.slot.RestrictedInputSlot;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class ToolboxMenu {
    private final AEBaseMenu menu;
    private final int slot;
    private final NetworkToolMenuHost inv;

    public ToolboxMenu(AEBaseMenu menu) {
        this.menu = menu;
        this.inv = NetworkToolItem.findNetworkToolInv(menu.getPlayer());
        if (this.inv != null) {
            this.slot = Objects.requireNonNullElse(this.inv.getSlot(), 0);
            menu.lockPlayerInventorySlot(this.slot);
        } else {
            this.slot = 0;
        }
        if (this.isPresent()) {
            for (int i = 0; i < 9; ++i) {
                RestrictedInputSlot slot = new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.UPGRADES, this.inv.getInternalInventory(), i);
                menu.addSlot(slot, SlotSemantics.TOOLBOX);
            }
        }
    }

    public boolean isPresent() {
        return this.inv != null;
    }

    public void tick() {
        ItemStack currentItem;
        if (this.isPresent() && (currentItem = this.menu.getPlayerInventory().m_8020_(this.slot)) != this.inv.getItemStack()) {
            if (!currentItem.m_41619_()) {
                if (ItemStack.m_41746_((ItemStack)this.inv.getItemStack(), (ItemStack)currentItem)) {
                    this.menu.getPlayerInventory().m_6836_(this.slot, this.inv.getItemStack());
                } else {
                    this.menu.setValidMenu(false);
                }
            } else {
                this.menu.setValidMenu(false);
            }
        }
    }

    public Component getName() {
        return this.inv != null ? this.inv.getItemStack().m_41786_() : Component.m_237119_();
    }
}

