/*
 * Decompiled with CFR 0.152.
 */
package appeng.spatial;

import appeng.core.definitions.AEBlocks;
import appeng.spatial.SpatialStorageDimensionIds;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.FixedBiomeSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.structure.StructureSet;

public class SpatialStorageChunkGenerator
extends ChunkGenerator {
    public static final int MIN_Y = 0;
    public static final int HEIGHT = 256;
    public static final Codec<SpatialStorageChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> SpatialStorageChunkGenerator.m_208005_((RecordCodecBuilder.Instance)instance).and((App)RegistryOps.m_206832_((ResourceKey)Registry.f_122885_).forGetter(source -> source.biomeRegistry)).apply((Applicative)instance, instance.stable(SpatialStorageChunkGenerator::new)));
    private final Registry<Biome> biomeRegistry;
    private final NoiseColumn columnSample;
    private final BlockState defaultBlockState = AEBlocks.MATRIX_FRAME.block().m_49966_();

    public SpatialStorageChunkGenerator(Registry<StructureSet> structureSets, Registry<Biome> biomeRegistry) {
        super(structureSets, Optional.of(HolderSet.m_205809_((Holder[])new Holder[0])), (BiomeSource)SpatialStorageChunkGenerator.createBiomeSource(biomeRegistry));
        this.biomeRegistry = biomeRegistry;
        Object[] columnSample = new BlockState[256];
        Arrays.fill(columnSample, this.defaultBlockState);
        this.columnSample = new NoiseColumn(0, (BlockState[])columnSample);
    }

    protected Codec<? extends ChunkGenerator> m_6909_() {
        return CODEC;
    }

    private static FixedBiomeSource createBiomeSource(Registry<Biome> biomeRegistry) {
        return new FixedBiomeSource(biomeRegistry.m_206081_(SpatialStorageDimensionIds.BIOME_KEY));
    }

    public int m_6331_() {
        return 256;
    }

    public int m_142062_() {
        return 0;
    }

    public void m_214194_(WorldGenRegion worldGenRegion, StructureManager structureManager, RandomState randomState, ChunkAccess chunk) {
        this.fillChunk(chunk);
        chunk.m_8092_(false);
    }

    private void fillChunk(ChunkAccess chunk) {
        BlockPos.MutableBlockPos mutPos = new BlockPos.MutableBlockPos();
        for (int cx = 0; cx < 16; ++cx) {
            mutPos.m_142451_(cx);
            for (int cz = 0; cz < 16; ++cz) {
                mutPos.m_142443_(cz);
                for (int cy = 0; cy < 256; ++cy) {
                    mutPos.m_142448_(cy);
                    chunk.m_6978_((BlockPos)mutPos, this.defaultBlockState, false);
                }
            }
        }
    }

    public int m_6337_() {
        return 0;
    }

    public CompletableFuture<ChunkAccess> m_213974_(Executor executor, Blender blender, RandomState randomState, StructureManager structureManager, ChunkAccess chunk) {
        return CompletableFuture.completedFuture(chunk);
    }

    public int m_214096_(int i, int j, Heightmap.Types types, LevelHeightAccessor levelHeightAccessor, RandomState randomState) {
        return 0;
    }

    public NoiseColumn m_214184_(int i, int j, LevelHeightAccessor levelHeightAccessor, RandomState randomState) {
        return this.columnSample;
    }

    public void m_213600_(List<String> list, RandomState randomState, BlockPos blockPos) {
    }

    public void m_213679_(WorldGenRegion worldGenRegion, long l, RandomState randomState, BiomeManager biomeManager, StructureManager structureManager, ChunkAccess chunkAccess, GenerationStep.Carving carving) {
    }

    public void m_6929_(WorldGenRegion level) {
    }
}

