/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.blocks.prism;

import alexthw.ars_elemental.api.item.SpellPrismLens;
import alexthw.ars_elemental.common.blocks.prism.AdvancedPrismTile;
import com.hollingsworth.arsnouveau.api.util.BlockUtil;
import com.hollingsworth.arsnouveau.common.advancement.ANCriteriaTriggers;
import com.hollingsworth.arsnouveau.common.block.SpellPrismBlock;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.BlockSourceImpl;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.PositionImpl;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class AdvancedPrism
extends SpellPrismBlock
implements EntityBlock {
    static final SpellPrismLens defaultLent = (spell, level, pos) -> true;

    public AdvancedPrism(BlockBehaviour.Properties blockProps) {
        super(blockProps.m_60955_());
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        BlockEntity blockEntity;
        if (pPlayer.f_19853_.f_46443_) {
            super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
        }
        if (pPlayer.m_21120_(pHand).m_41720_() instanceof SpellPrismLens && (blockEntity = pLevel.m_7702_(pPos)) instanceof AdvancedPrismTile) {
            AdvancedPrismTile tile = (AdvancedPrismTile)blockEntity;
            tile.setLens(pPlayer.m_21120_(pHand).m_41620_(1), pPlayer);
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
    }

    public void onHit(ServerLevel world, BlockPos pos, EntityProjectileSpell spell) {
        SpellPrismLens lens;
        BlockEntity blockEntity = world.m_7702_(pos);
        if (!(blockEntity instanceof AdvancedPrismTile)) {
            return;
        }
        AdvancedPrismTile tile = (AdvancedPrismTile)blockEntity;
        Position iposition = AdvancedPrism.getDispensePosition((BlockSource)new BlockSourceImpl(world, pos), tile);
        spell.m_6034_(iposition.m_7096_(), iposition.m_7098_(), iposition.m_7094_());
        ++spell.prismRedirect;
        if (spell.prismRedirect >= 3) {
            ANCriteriaTriggers.rewardNearbyPlayers((PlayerTrigger)ANCriteriaTriggers.PRISMATIC, (ServerLevel)world, (BlockPos)pos, (int)10);
        }
        if (spell.spellResolver == null) {
            spell.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        Vec3 vec3d = tile.getShootAngle().m_82541_();
        Item item = tile.getLens().m_41720_();
        if (item instanceof SpellPrismLens && (lens = (SpellPrismLens)item).canConvert(spell, (Level)world, pos)) {
            lens.shoot(world, pos, spell, vec3d);
        } else {
            defaultLent.shoot(world, pos, spell, vec3d);
        }
        BlockUtil.updateObservers((Level)world, (BlockPos)pos);
    }

    public static Position getDispensePosition(BlockSource coords, AdvancedPrismTile tile) {
        Vec3 direction = tile.getShootAngle().m_82541_();
        double d0 = coords.m_7096_() + 0.5 * direction.m_7096_();
        double d1 = coords.m_7098_() + 0.5 * direction.m_7098_();
        double d2 = coords.m_7094_() + 0.5 * direction.m_7094_();
        return new PositionImpl(d0, d1, d2);
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        Direction orientation = placer == null ? Direction.WEST : Direction.m_122382_((Entity)placer)[0].m_122424_();
        BlockEntity blockEntity = world.m_7702_(pos);
        if (!(blockEntity instanceof AdvancedPrismTile)) {
            return;
        }
        AdvancedPrismTile prismTile = (AdvancedPrismTile)blockEntity;
        switch (orientation) {
            case DOWN: {
                prismTile.rotationY = -90.0f;
                break;
            }
            case UP: {
                prismTile.rotationY = 90.0f;
                break;
            }
            case NORTH: {
                prismTile.rotationX = 270.0f;
                break;
            }
            case SOUTH: {
                prismTile.rotationX = 90.0f;
                break;
            }
            case WEST: {
                break;
            }
            case EAST: {
                prismTile.rotationX = 180.0f;
            }
        }
    }

    public BlockState rotate(BlockState state, LevelAccessor level, BlockPos pos, Rotation rot) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof AdvancedPrismTile) {
            AdvancedPrismTile prismTile = (AdvancedPrismTile)blockEntity;
            float f = prismTile.getRotationX();
            prismTile.setRotationX(f + (switch (rot) {
                default -> throw new IncompatibleClassChangeError();
                case Rotation.NONE -> 0.0f;
                case Rotation.CLOCKWISE_90 -> 90.0f;
                case Rotation.CLOCKWISE_180 -> 180.0f;
                case Rotation.COUNTERCLOCKWISE_90 -> -90.0f;
            }));
            prismTile.updateBlock();
        }
        return super.rotate(state, level, pos, rot);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return super.m_6843_(state, rot);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new AdvancedPrismTile(pPos, pState);
    }
}

