/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.entity.spells;

import alexthw.ars_elemental.common.glyphs.MethodCurvedProjectile;
import alexthw.ars_elemental.registry.ModEntities;
import com.hollingsworth.arsnouveau.api.block.IPrismaticBlock;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketANEffect;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtract;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EntityCurvedProjectile
extends EntityProjectileSpell {
    private boolean isCareful = false;

    public int getExpirationTime() {
        return MethodCurvedProjectile.INSTANCE.getProjectileLifespan() * 20;
    }

    public EntityCurvedProjectile(EntityType<? extends EntityProjectileSpell> entityType, Level world) {
        super(entityType, world);
        this.isNoGravity = false;
    }

    public EntityCurvedProjectile(Level world, SpellResolver resolver) {
        super((EntityType)ModEntities.CURVED_PROJECTILE.get(), world, resolver);
        this.isCareful = resolver.spell.getBuffsAtIndex(0, resolver.spellContext.getUnwrappedCaster(), (AbstractAugment)AugmentExtract.INSTANCE) > 0;
        this.isNoGravity = false;
    }

    public EntityType<?> m_6095_() {
        return (EntityType)ModEntities.CURVED_PROJECTILE.get();
    }

    public void tickNextPosition() {
        Vec3 motion = this.m_20184_();
        this.m_20334_(motion.f_82479_ * 0.96, (motion.f_82480_ > 0.0 ? motion.f_82480_ * 0.96 : motion.f_82480_) - (double)0.03f, motion.f_82481_ * 0.96);
        Vec3 pos = this.m_20182_();
        this.m_6034_(pos.f_82479_ + motion.f_82479_, pos.f_82480_ + motion.f_82480_, pos.f_82481_ + motion.f_82481_);
    }

    public void m_8119_() {
        if (!this.f_19853_.f_46443_ && this.age > this.getExpirationTime()) {
            this.m_6532_((HitResult)new BlockHitResult(this.getNextHitPosition(), Direction.UP, this.m_20183_(), true));
        }
        super.m_8119_();
    }

    protected void attemptRemoval() {
        --this.pierceLeft;
        if (this.pierceLeft < 0) {
            this.f_19853_.m_7605_((Entity)this, (byte)3);
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        } else {
            Vec3 vel = this.m_20184_();
            this.m_20334_(vel.m_7096_(), -0.9 * vel.m_7098_(), vel.m_7094_());
        }
    }

    private void attemptRemoval(BlockHitResult blockraytraceresult) {
        --this.pierceLeft;
        if (this.pierceLeft < 0) {
            this.f_19853_.m_7605_((Entity)this, (byte)3);
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        } else {
            Direction direction = blockraytraceresult.m_82434_();
            float factor = -0.9f;
            switch (direction) {
                case UP: 
                case DOWN: {
                    Vec3 vel = this.m_20184_();
                    this.m_20334_(vel.m_7096_(), (double)factor * vel.m_7098_(), vel.m_7094_());
                    break;
                }
                case EAST: 
                case WEST: {
                    Vec3 vel = this.m_20184_();
                    this.m_20334_((double)factor * vel.m_7096_(), vel.m_7098_(), vel.m_7094_());
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    Vec3 vel = this.m_20184_();
                    this.m_20334_(vel.m_7096_(), vel.m_7098_(), (double)factor * vel.m_7094_());
                }
            }
        }
    }

    protected void m_6532_(HitResult result) {
        result = this.transformHitResult(result);
        if (!this.f_19853_.f_46443_ && result instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)result;
            if (entityHitResult.m_82443_().equals((Object)this.m_37282_())) {
                return;
            }
            if (this.spellResolver != null) {
                this.spellResolver.onResolveEffect(this.f_19853_, result);
                Networking.sendToNearby((Level)this.f_19853_, (BlockPos)new BlockPos(result.m_82450_()), (Object)new PacketANEffect(PacketANEffect.EffectType.BURST, new BlockPos(result.m_82450_()), this.getParticleColorWrapper(), new int[0]));
                this.attemptRemoval();
            }
        }
        if (!this.f_19853_.f_46443_ && result instanceof BlockHitResult) {
            BlockHitResult blockRaytraceResult = (BlockHitResult)result;
            if (!this.m_213877_() && !this.hitList.contains(blockRaytraceResult.m_82425_())) {
                BlockState state = this.f_19853_.m_8055_(blockRaytraceResult.m_82425_());
                Block block = state.m_60734_();
                if (block instanceof IPrismaticBlock) {
                    IPrismaticBlock prismaticBlock = (IPrismaticBlock)block;
                    prismaticBlock.onHit((ServerLevel)this.f_19853_, blockRaytraceResult.m_82425_(), (EntityProjectileSpell)this);
                    return;
                }
                if (state.m_60767_() == Material.f_76298_) {
                    state.m_60734_().m_7892_(state, this.f_19853_, blockRaytraceResult.m_82425_(), (Entity)this);
                    return;
                }
                if (this.spellResolver != null) {
                    this.hitList.add(blockRaytraceResult.m_82425_());
                    if (!this.isCareful || this.pierceLeft == 0) {
                        this.spellResolver.onResolveEffect(this.f_19853_, (HitResult)blockRaytraceResult);
                    }
                }
                Networking.sendToNearby((Level)this.f_19853_, (BlockPos)((BlockHitResult)result).m_82425_(), (Object)new PacketANEffect(PacketANEffect.EffectType.BURST, new BlockPos(result.m_82450_()).m_7495_(), this.getParticleColorWrapper(), new int[0]));
                this.attemptRemoval(blockRaytraceResult);
            }
        }
    }
}

