/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.items.armor;

import alexthw.ars_elemental.common.items.armor.ElementalArmor;
import alexthw.ars_elemental.registry.ModItems;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.RegistryObject;

public class ArmorSet {
    private final String name;
    RegistryObject<Item> head;
    RegistryObject<Item> chest;
    RegistryObject<Item> legs;
    RegistryObject<Item> feet;

    public String getName() {
        return this.name;
    }

    public ArmorSet(String name, SpellSchool element) {
        this.name = name;
        this.head = ModItems.ITEMS.register(name + "_hat", () -> new ElementalArmor(EquipmentSlot.HEAD, element, ModItems.ArmorProp()));
        this.chest = ModItems.ITEMS.register(name + "_robes", () -> new ElementalArmor(EquipmentSlot.CHEST, element, ModItems.ArmorProp()));
        this.legs = ModItems.ITEMS.register(name + "_leggings", () -> new ElementalArmor(EquipmentSlot.LEGS, element, ModItems.ArmorProp()));
        this.feet = ModItems.ITEMS.register(name + "_boots", () -> new ElementalArmor(EquipmentSlot.FEET, element, ModItems.ArmorProp()));
    }

    public Item getHat() {
        return (Item)this.head.get();
    }

    public Item getChest() {
        return (Item)this.chest.get();
    }

    public Item getLegs() {
        return (Item)this.legs.get();
    }

    public Item getBoots() {
        return (Item)this.feet.get();
    }

    public Item getArmorFromSlot(EquipmentSlot slot) {
        return switch (slot) {
            case EquipmentSlot.CHEST -> this.getChest();
            case EquipmentSlot.LEGS -> this.getLegs();
            case EquipmentSlot.FEET -> this.getBoots();
            default -> this.getHat();
        };
    }

    public String getTranslationKey() {
        return "ars_elemental.armor_set." + this.name;
    }
}

