/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.datagen;

import alexthw.ars_elemental.datagen.AEAdvancementsProvider;
import alexthw.ars_elemental.datagen.AEApparatusProvider;
import alexthw.ars_elemental.datagen.AEBiomeModifiersProvider;
import alexthw.ars_elemental.datagen.AEBlockStateProvider;
import alexthw.ars_elemental.datagen.AECasterTomeProvider;
import alexthw.ars_elemental.datagen.AEGlyphProvider;
import alexthw.ars_elemental.datagen.AEImbuementProvider;
import alexthw.ars_elemental.datagen.AEItemModelProvider;
import alexthw.ars_elemental.datagen.AEPatchouliProvider;
import alexthw.ars_elemental.datagen.AETagsProvider;
import alexthw.ars_elemental.datagen.ModRecipeProvider;
import alexthw.ars_elemental.registry.ModItems;
import com.google.common.collect.ImmutableList;
import com.hollingsworth.arsnouveau.common.block.ArchfruitPod;
import com.hollingsworth.arsnouveau.common.block.SummonBlock;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="ars_elemental", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Datagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        gen.m_236039_(event.includeClient(), (DataProvider)new AEBlockStateProvider(gen, existingFileHelper));
        gen.m_236039_(event.includeClient(), (DataProvider)new AEItemModelProvider(gen, existingFileHelper));
        AETagsProvider.AEBlockTagsProvider BTP = new AETagsProvider.AEBlockTagsProvider(gen, existingFileHelper);
        gen.m_236039_(event.includeServer(), (DataProvider)BTP);
        gen.m_236039_(event.includeServer(), (DataProvider)new AETagsProvider.AEItemTagsProvider(gen, BTP, existingFileHelper));
        gen.m_236039_(event.includeServer(), (DataProvider)new AETagsProvider.AEEntityTagProvider(gen, existingFileHelper));
        gen.m_236039_(event.includeServer(), (DataProvider)new ModRecipeProvider(gen));
        gen.m_236039_(event.includeServer(), (DataProvider)new ModLootTables(gen));
        gen.m_236039_(event.includeServer(), (DataProvider)new AEImbuementProvider(gen));
        gen.m_236039_(event.includeServer(), (DataProvider)new AEGlyphProvider(gen));
        gen.m_236039_(event.includeServer(), (DataProvider)new AEApparatusProvider(gen));
        gen.m_236039_(event.includeServer(), (DataProvider)new AEPatchouliProvider(gen));
        gen.m_236039_(event.includeServer(), (DataProvider)new AEAdvancementsProvider(gen, existingFileHelper));
        gen.m_236039_(event.includeServer(), (DataProvider)new AECasterTomeProvider(gen));
        gen.m_236039_(event.includeServer(), (DataProvider)new AETagsProvider.AEFeatureTagsProvider(gen, existingFileHelper));
        gen.m_236039_(event.includeServer(), (DataProvider)new AETagsProvider.AEBiomeTagsProvider(gen, existingFileHelper));
        AEBiomeModifiersProvider.generateBiomeModifiers(event);
    }

    public static <T> Collection<T> takeAll(Collection<T> src, Predicate<T> predicate) {
        ArrayList<T> ret = new ArrayList<T>();
        Iterator<T> iter = src.iterator();
        while (iter.hasNext()) {
            T item = iter.next();
            if (!predicate.test(item)) continue;
            iter.remove();
            ret.add(item);
        }
        if (ret.isEmpty()) {
            return Collections.emptyList();
        }
        return ret;
    }

    public static class ModLootTables
    extends LootTableProvider {
        private static final float[] DEFAULT_SAPLING_DROP_RATES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};
        private final List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> tables = ImmutableList.of((Object)Pair.of(BlockLootTable::new, (Object)LootContextParamSets.f_81421_));

        public ModLootTables(DataGenerator dataGeneratorIn) {
            super(dataGeneratorIn);
        }

        protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
            return this.tables;
        }

        protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationTracker) {
            map.forEach((resourceLocation, lootTable) -> LootTables.m_79202_((ValidationContext)validationTracker, (ResourceLocation)resourceLocation, (LootTable)lootTable));
        }

        public static LootPool.Builder POD_BUILDER(Item item, Block block) {
            return LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)item).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)3.0f)).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)ArchfruitPod.f_51736_, 2)))));
        }

        @NotNull
        public String m_6055_() {
            return "Ars Elemental Loot Tables";
        }

        public static class BlockLootTable
        extends BlockLoot {
            public List<Block> list = new ArrayList<Block>();

            protected void addTables() {
                HashSet blocks = new HashSet(ModItems.BLOCKS.getEntries());
                Datagen.takeAll(blocks, b -> b.get() instanceof LeavesBlock);
                Datagen.takeAll(blocks, b -> !(b.get() instanceof SummonBlock)).forEach(b -> this.registerDropSelf((Block)b.get()));
                this.registerLeavesAndSticks((Block)ModItems.FLASHING_LEAVES.get(), (Block)ModItems.FLASHING_SAPLING.get());
                this.list.add((Block)ModItems.MERMAID_ROCK.get());
                this.m_124147_((Block)ModItems.MERMAID_ROCK.get(), (ItemLike)Blocks.f_50377_);
                this.list.add((Block)ModItems.POT_FLASHING_SAPLING.get());
                this.m_124252_((Block)ModItems.POT_FLASHING_SAPLING.get());
                this.m_124175_((Block)ModItems.FLASHING_POD.get(), block -> LootTable.m_79147_().m_79161_(ModLootTables.POD_BUILDER(block.m_5456_(), block)));
            }

            public void registerLeavesAndSticks(Block leaves, Block sapling) {
                this.list.add(leaves);
                this.m_124175_(leaves, l_state -> BlockLootTable.m_124157_((Block)l_state, (Block)sapling, (float[])DEFAULT_SAPLING_DROP_RATES));
            }

            public void registerDropSelf(Block block) {
                this.list.add(block);
                this.m_124288_(block);
            }

            protected Iterable<Block> getKnownBlocks() {
                return this.list;
            }
        }
    }
}

