/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.event;

import alexthw.ars_elemental.ArsNouveauRegistry;
import alexthw.ars_elemental.api.IUndeadSummon;
import alexthw.ars_elemental.api.item.ISchoolFocus;
import alexthw.ars_elemental.common.entity.summon.AllyVhexEntity;
import alexthw.ars_elemental.common.entity.summon.SummonDirewolf;
import alexthw.ars_elemental.common.entity.summon.SummonDolphin;
import alexthw.ars_elemental.common.entity.summon.SummonSkeleHorse;
import alexthw.ars_elemental.common.entity.summon.SummonStrider;
import alexthw.ars_elemental.common.entity.summon.SummonUndead;
import alexthw.ars_elemental.common.items.armor.SummonPerk;
import alexthw.ars_elemental.common.items.foci.NecroticFocus;
import com.hollingsworth.arsnouveau.api.entity.ISummon;
import com.hollingsworth.arsnouveau.api.event.SummonEvent;
import com.hollingsworth.arsnouveau.api.perk.IPerk;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.util.PerkUtil;
import com.hollingsworth.arsnouveau.common.entity.EntityAllyVex;
import com.hollingsworth.arsnouveau.common.entity.SummonHorse;
import com.hollingsworth.arsnouveau.common.entity.SummonSkeleton;
import com.hollingsworth.arsnouveau.common.entity.SummonWolf;
import com.hollingsworth.arsnouveau.common.potions.ModPotions;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="ars_elemental")
public class SummonEvents {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void summonedEvent(SummonEvent event) {
        SpellSchool focus = ISchoolFocus.hasFocus((Entity)event.shooter);
        if (!event.world.f_46443_ && focus != null) {
            Object object;
            if (focus == ArsNouveauRegistry.NECROMANCY && event.summon.getLivingEntity() != null) {
                event.summon.getLivingEntity().m_7292_(new MobEffectInstance(MobEffects.f_19600_, 500, 1));
                event.summon.getLivingEntity().m_7292_(new MobEffectInstance(MobEffects.f_19596_, 500, 1));
            }
            if ((object = event.summon) instanceof SummonHorse) {
                SummonHorse oldHorse = (SummonHorse)object;
                object = event.shooter;
                if (object instanceof ServerPlayer) {
                    ServerPlayer summoner = (ServerPlayer)object;
                    switch (focus.getId()) {
                        case "water": {
                            SummonDolphin newHorse = new SummonDolphin(oldHorse, (Player)summoner);
                            if (newHorse.getOwnerID() == null) break;
                            oldHorse.m_142687_(Entity.RemovalReason.DISCARDED);
                            event.summon = newHorse;
                            event.world.m_7967_((Entity)newHorse);
                            CriteriaTriggers.f_10580_.m_68256_(summoner, (Entity)newHorse);
                            break;
                        }
                        case "fire": {
                            SummonStrider newHorse = new SummonStrider(oldHorse, (Player)summoner);
                            if (newHorse.getOwnerID() == null) break;
                            oldHorse.m_142687_(Entity.RemovalReason.DISCARDED);
                            event.summon = newHorse;
                            event.world.m_7967_((Entity)newHorse);
                            CriteriaTriggers.f_10580_.m_68256_(summoner, (Entity)newHorse);
                            break;
                        }
                        case "necromancy": {
                            SummonSkeleHorse newHorse = new SummonSkeleHorse(oldHorse, (Player)summoner);
                            if (newHorse.getOwnerID() == null) break;
                            oldHorse.m_142687_(Entity.RemovalReason.DISCARDED);
                            event.summon = newHorse;
                            event.world.m_7967_((Entity)newHorse);
                            CriteriaTriggers.f_10580_.m_68256_(summoner, (Entity)newHorse);
                            break;
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void reRaiseSummon(SummonEvent.Death event) {
        ServerLevel world;
        Entity entity;
        if (!event.world.f_46443_ && (entity = event.summon.getOwner(world = (ServerLevel)event.world)) instanceof Player) {
            Player player = (Player)entity;
            if (!(event.summon instanceof IUndeadSummon) && NecroticFocus.hasFocus(event.world, (Entity)player)) {
                IUndeadSummon toRaise = null;
                ISummon iSummon = event.summon;
                if (iSummon instanceof SummonWolf) {
                    SummonWolf wolf = (SummonWolf)iSummon;
                    toRaise = new SummonDirewolf((Level)world, player, wolf);
                } else {
                    iSummon = event.summon;
                    if (iSummon instanceof EntityAllyVex) {
                        EntityAllyVex vex = (EntityAllyVex)iSummon;
                        toRaise = new AllyVhexEntity((Level)world, vex, player);
                    } else {
                        iSummon = event.summon;
                        if (iSummon instanceof SummonSkeleton) {
                            SummonSkeleton skelly = (SummonSkeleton)iSummon;
                            toRaise = new SummonUndead((Level)world, skelly, player);
                        }
                    }
                }
                if (toRaise instanceof IUndeadSummon) {
                    IUndeadSummon undead = toRaise;
                    undead.inherit(event.summon);
                    event.world.m_7967_((Entity)toRaise);
                    NecroticFocus.spawnDeathPoof(world, toRaise.m_20183_());
                }
            }
        }
    }

    @SubscribeEvent
    public static void summonSickReduction(MobEffectEvent.Added event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (event.getEffectInstance().m_19544_() == ModPotions.SUMMONING_SICKNESS_EFFECT.get() && PerkUtil.countForPerk((IPerk)SummonPerk.INSTANCE, (Player)player) > 0) {
                event.getEffectInstance().f_19503_ = event.getEffectInstance().m_19557_() * (1 - PerkUtil.countForPerk((IPerk)SummonPerk.INSTANCE, (Player)player) / 10);
            }
        }
    }

    @SubscribeEvent
    public static void summonPowerup(LivingDamageEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof ISummon) {
            ServerLevel level;
            Entity entity2;
            ISummon summon = (ISummon)entity;
            entity = event.getEntity().m_9236_();
            if (entity instanceof ServerLevel && (entity2 = summon.getOwner(level = (ServerLevel)entity)) instanceof Player) {
                SpellSchool school;
                Player player = (Player)entity2;
                int threadLevel = PerkUtil.countForPerk((IPerk)SummonPerk.INSTANCE, (Player)player) - 1;
                if (threadLevel > 0) {
                    event.setAmount(event.getAmount() + (float)threadLevel);
                }
                if (summon instanceof SummonWolf && (school = ISchoolFocus.hasFocus((Entity)player)) != null) {
                    switch (school.getId()) {
                        case "fire": {
                            event.getEntity().m_20254_(5);
                            break;
                        }
                        case "water": {
                            event.getEntity().m_7292_(new MobEffectInstance((MobEffect)ModPotions.FREEZING_EFFECT.get(), 100, 1));
                            break;
                        }
                        case "air": {
                            event.getEntity().m_7292_(new MobEffectInstance((MobEffect)ModPotions.SHOCKED_EFFECT.get(), 100, 1));
                            break;
                        }
                        case "earth": {
                            event.getEntity().m_7292_(new MobEffectInstance(MobEffects.f_19614_, 100));
                        }
                    }
                }
            }
        }
    }
}

