/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.recipe;

import alexthw.ars_elemental.registry.ModRegistry;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.hollingsworth.arsnouveau.api.RegistryHelper;
import com.hollingsworth.arsnouveau.api.enchanting_apparatus.EnchantingApparatusRecipe;
import com.hollingsworth.arsnouveau.api.enchanting_apparatus.ITextOutput;
import com.hollingsworth.arsnouveau.api.perk.ArmorPerkHolder;
import com.hollingsworth.arsnouveau.api.perk.IPerkHolder;
import com.hollingsworth.arsnouveau.api.util.PerkUtil;
import com.hollingsworth.arsnouveau.common.block.tile.EnchantingApparatusTile;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;

public class ElementalArmorRecipe
extends EnchantingApparatusRecipe
implements ITextOutput {
    public int tier;

    public ElementalArmorRecipe(ResourceLocation id, List<Ingredient> pedestalItems, Ingredient reagent, ItemStack result, int cost, int tier) {
        super(id, pedestalItems, reagent, result, cost, true);
        this.tier = tier;
    }

    public ElementalArmorRecipe(EnchantingApparatusRecipe recipe) {
        this(recipe.id, recipe.pedestalItems, recipe.reagent, recipe.result, recipe.sourceCost, 3);
    }

    public JsonElement asRecipe() {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("type", "ars_elemental:armor_upgrade");
        JsonArray pedestalArr = new JsonArray();
        for (Ingredient i : this.pedestalItems) {
            JsonObject object = new JsonObject();
            object.add("item", i.m_43942_());
            pedestalArr.add((JsonElement)object);
        }
        JsonArray reagent = new JsonArray();
        reagent.add(this.reagent.m_43942_());
        jsonobject.add("reagent", (JsonElement)reagent);
        JsonObject resultObj = new JsonObject();
        resultObj.addProperty("item", RegistryHelper.getRegistryName((Item)this.result.m_41720_()).toString());
        jsonobject.add("pedestalItems", (JsonElement)pedestalArr);
        jsonobject.add("output", (JsonElement)resultObj);
        jsonobject.addProperty("sourceCost", (Number)this.sourceCost);
        jsonobject.addProperty("tier", (Number)this.tier);
        return jsonobject;
    }

    public boolean isMatch(List<ItemStack> pedestalItems, ItemStack reagent, EnchantingApparatusTile enchantingApparatusTile, @Nullable Player player) {
        IPerkHolder perkHolder = PerkUtil.getPerkHolder((ItemStack)reagent);
        if (!(perkHolder instanceof ArmorPerkHolder)) {
            return false;
        }
        ArmorPerkHolder armorPerkHolder = (ArmorPerkHolder)perkHolder;
        return armorPerkHolder.getTier() == this.tier - 1 && super.isMatch(pedestalItems, reagent, enchantingApparatusTile, player);
    }

    public ItemStack getResult(List<ItemStack> pedestalItems, ItemStack reagent, EnchantingApparatusTile enchantingApparatusTile) {
        ItemStack result = this.result.m_41777_();
        if (reagent.m_41782_()) {
            result.m_41751_(reagent.m_41783_());
            result.m_41721_(0);
        }
        return result.m_41777_();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRegistry.ELEMENTAL_ARMOR_UP.get();
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRegistry.ELEMENTAL_ARMOR_UP_SERIALIZER.get();
    }

    public Component getOutputComponent() {
        return Component.m_237110_((String)"ars_nouveau.armor_upgrade.book_desc", (Object[])new Object[]{this.tier});
    }

    public boolean excludeJei() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<ElementalArmorRecipe> {
        public ElementalArmorRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            int tier = json.has("tier") ? GsonHelper.m_13927_((JsonObject)json, (String)"tier") : 0;
            Ingredient reagent = Ingredient.m_43917_((JsonElement)GsonHelper.m_13933_((JsonObject)json, (String)"reagent"));
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"output"));
            int cost = json.has("sourceCost") ? GsonHelper.m_13927_((JsonObject)json, (String)"sourceCost") : 0;
            JsonArray pedestalItems = GsonHelper.m_13933_((JsonObject)json, (String)"pedestalItems");
            ArrayList<Ingredient> stacks = new ArrayList<Ingredient>();
            for (JsonElement e : pedestalItems) {
                JsonObject obj = e.getAsJsonObject();
                Ingredient input = GsonHelper.m_13885_((JsonObject)obj, (String)"item") ? Ingredient.m_43917_((JsonElement)GsonHelper.m_13933_((JsonObject)obj, (String)"item")) : Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)obj, (String)"item"));
                stacks.add(input);
            }
            return new ElementalArmorRecipe(recipeId, stacks, reagent, output, cost, tier);
        }

        @Nullable
        public ElementalArmorRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int length = buffer.readInt();
            Ingredient reagent = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack output = buffer.m_130267_();
            ArrayList<Ingredient> stacks = new ArrayList<Ingredient>();
            for (int i = 0; i < length; ++i) {
                try {
                    stacks.add(Ingredient.m_43940_((FriendlyByteBuf)buffer));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
            }
            int cost = buffer.readInt();
            int tier = buffer.readInt();
            return new ElementalArmorRecipe(recipeId, stacks, reagent, output, cost, tier);
        }

        public void toNetwork(FriendlyByteBuf buf, ElementalArmorRecipe recipe) {
            buf.writeInt(recipe.pedestalItems.size());
            recipe.reagent.m_43923_(buf);
            buf.m_130055_(recipe.result);
            for (Ingredient i : recipe.pedestalItems) {
                i.m_43923_(buf);
            }
            buf.writeInt(recipe.sourceCost);
            buf.writeInt(recipe.tier);
        }
    }
}

