/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.blocks.misc;

import com.legacy.blue_skies.blocks.SkyPortalBlock;
import com.legacy.blue_skies.entities.util.interfaces.ISkyBossMob;
import com.legacy.blue_skies.events.SkiesPlayerEvents;
import com.legacy.structure_gel.api.block.GelPortalBlock;
import com.legacy.structure_gel.api.dimension.portal.GelPortalLogic;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;

public class SkyFireBlock
extends FireBlock {
    private final Supplier<MobEffectInstance> effect;
    public final Supplier<GelPortalBlock> portalBlock;

    public SkyFireBlock(Supplier<MobEffectInstance> effect, Supplier<GelPortalBlock> portalBlock) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76309_).m_60910_().m_60977_().m_60978_(0.0f).m_60953_(value -> 15).m_60918_(SoundType.f_56745_));
        this.effect = effect;
        this.portalBlock = portalBlock;
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entityIn) {
        if ((entityIn instanceof LivingEntity || entityIn instanceof Player) && !(entityIn instanceof ISkyBossMob)) {
            ((LivingEntity)entityIn).m_7292_(this.effect.get());
        }
    }

    public BlockState m_7417_(BlockState fireState, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        return this.m_7898_(fireState, (LevelReader)world, currentPos) ? this.getFireWithAge(world, currentPos, (Integer)fireState.m_61143_((Property)f_53408_)) : Blocks.f_50016_.m_49966_();
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (oldState.m_60734_() != state.m_60734_() && !GelPortalLogic.fillPortal((Level)world, (BlockPos)pos, (GelPortalBlock)this.portalBlock.get(), SkyPortalBlock.ALLOWED_INSIDE_BLOCKS)) {
            if (!state.m_60710_((LevelReader)world, pos)) {
                world.m_7471_(pos, false);
            } else {
                world.m_186460_(pos, (Block)this, SkyFireBlock.getTickCooldown(world.f_46441_));
            }
        }
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        world.m_186460_(pos, (Block)this, SkyFireBlock.getTickCooldown(world.f_46441_));
        if (world.m_46469_().m_46207_(GameRules.f_46131_)) {
            if (!state.m_60710_((LevelReader)world, pos)) {
                world.m_7471_(pos, false);
            }
            BlockState blockstate = world.m_8055_(pos.m_7495_());
            boolean flag = blockstate.isFireSource((LevelReader)world, pos, Direction.UP);
            int i = (Integer)state.m_61143_((Property)f_53408_);
            if (!flag && world.m_46471_() && this.m_53428_((Level)world, pos) && rand.m_188501_() < 0.2f + (float)i * 0.03f) {
                world.m_7471_(pos, false);
            } else {
                int j = Math.min(15, i + rand.m_188503_(3) / 2);
                if (i != j) {
                    state = (BlockState)state.m_61124_((Property)f_53408_, (Comparable)Integer.valueOf(j));
                    world.m_7731_(pos, state, 4);
                }
                if (!flag) {
                    if (!this.areNeighborsFlammable((BlockGetter)world, pos)) {
                        BlockPos blockpos = pos.m_7495_();
                        if (!world.m_8055_(blockpos).m_60783_((BlockGetter)world, blockpos, Direction.UP) || i > 3) {
                            world.m_7471_(pos, false);
                        }
                        return;
                    }
                    if (i == 15 && rand.m_188503_(4) == 0 && !this.canCatchFire((BlockGetter)world, pos.m_7495_(), Direction.UP)) {
                        world.m_7471_(pos, false);
                        return;
                    }
                }
                if (!SkiesPlayerEvents.DungeonBalancingChecks.isPosInBossRoom((Level)world, pos)) {
                    boolean flag1 = world.m_46761_(pos);
                    int k = flag1 ? -50 : 0;
                    this.tryCatchFire((Level)world, pos.m_122029_(), 300 + k, rand, i, Direction.WEST);
                    this.tryCatchFire((Level)world, pos.m_122024_(), 300 + k, rand, i, Direction.EAST);
                    this.tryCatchFire((Level)world, pos.m_7495_(), 250 + k, rand, i, Direction.UP);
                    this.tryCatchFire((Level)world, pos.m_7494_(), 250 + k, rand, i, Direction.DOWN);
                    this.tryCatchFire((Level)world, pos.m_122012_(), 300 + k, rand, i, Direction.SOUTH);
                    this.tryCatchFire((Level)world, pos.m_122019_(), 300 + k, rand, i, Direction.NORTH);
                    BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
                    for (int l = -1; l <= 1; ++l) {
                        for (int i1 = -1; i1 <= 1; ++i1) {
                            for (int j1 = -1; j1 <= 4; ++j1) {
                                if (l == 0 && j1 == 0 && i1 == 0) continue;
                                int k1 = 100;
                                if (j1 > 1) {
                                    k1 += (j1 - 1) * 100;
                                }
                                blockpos$mutable.m_122154_((Vec3i)pos, l, j1, i1);
                                int l1 = this.getNeighborEncouragement((LevelReader)world, (BlockPos)blockpos$mutable);
                                if (l1 <= 0) continue;
                                int i2 = (l1 + 40 + world.m_46791_().m_19028_() * 7) / (i + 30);
                                if (flag1) {
                                    i2 /= 2;
                                }
                                if (i2 <= 0 || rand.m_188503_(k1) > i2 || world.m_46471_() && this.m_53428_((Level)world, (BlockPos)blockpos$mutable)) continue;
                                int j2 = Math.min(15, i + rand.m_188503_(5) / 4);
                                world.m_7731_((BlockPos)blockpos$mutable, this.getFireWithAge((LevelAccessor)world, (BlockPos)blockpos$mutable, j2), 3);
                            }
                        }
                    }
                }
            }
        }
    }

    private void tryCatchFire(Level world, BlockPos pos, int chance, RandomSource rand, int age, Direction face) {
        if (rand.m_188503_(chance) < world.m_8055_(pos).getFlammability((BlockGetter)world, pos, face)) {
            BlockState blockstate = world.m_8055_(pos);
            if (rand.m_188503_(age + 10) < 5 && !world.m_46758_(pos)) {
                world.m_7731_(pos, this.getFireWithAge((LevelAccessor)world, pos, Math.min(age + rand.m_188503_(5) / 4, 15)), 3);
            } else {
                world.m_7471_(pos, false);
            }
            blockstate.onCaughtFire(world, pos, face, null);
        }
    }

    private BlockState getFireWithAge(LevelAccessor world, BlockPos pos, int age) {
        BlockState state = this.m_53470_((BlockGetter)world, pos);
        return state.m_60713_((Block)this) ? (BlockState)state.m_61124_((Property)f_53408_, (Comparable)Integer.valueOf(age)) : state;
    }

    private boolean areNeighborsFlammable(BlockGetter world, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            if (!this.canCatchFire(world, pos.m_121945_(direction), direction.m_122424_())) continue;
            return true;
        }
        return false;
    }

    private int getNeighborEncouragement(LevelReader world, BlockPos pos) {
        if (!world.m_46859_(pos)) {
            return 0;
        }
        int i = 0;
        for (Direction direction : Direction.values()) {
            i = Math.max(world.m_8055_(pos.m_121945_(direction)).getFireSpreadSpeed((BlockGetter)world, pos.m_121945_(direction), direction.m_122424_()), i);
        }
        return i;
    }

    private static int getTickCooldown(RandomSource rand) {
        return 30 + rand.m_188503_(10);
    }
}

