/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.init;

import com.legacy.blue_skies.data.objects.tags.SkiesBiomeTags;
import com.legacy.blue_skies.items.util.FoodPrepUtils;
import com.legacy.blue_skies.items.util.PreparedFood;
import com.legacy.blue_skies.items.util.ToolUtils;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesDimensions;
import com.legacy.blue_skies.registries.SkiesItems;
import com.legacy.structure_gel.api.registry.RegistryHelper;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="blue_skies", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class SkiesColoring {
    @SubscribeEvent
    public static void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        Minecraft mc = Minecraft.m_91087_();
        event.register((state, world, pos, index) -> {
            Biome biome;
            if (mc.f_91073_ != null && pos != null && (mc.f_91073_.m_46472_().equals(SkiesDimensions.everbrightKey()) || (biome = (Biome)mc.f_91073_.m_204166_(pos).m_203334_()) != null && RegistryHelper.isInTag((Registry)mc.f_91073_.m_5962_().m_175515_(Registry.f_122885_), SkiesBiomeTags.EVERBRIGHT, (Object)biome))) {
                return world != null ? BiomeColors.m_108793_((BlockAndTintGetter)world, (BlockPos)pos) : 0xFFFFFF;
            }
            return 0xFFFFFF;
        }, new Block[]{SkiesBlocks.turquoise_grass_block, SkiesBlocks.turquoise_grass, SkiesBlocks.tall_turquoise_grass, SkiesBlocks.brittlebush, SkiesBlocks.potted_brittlebush, SkiesBlocks.chillweed, SkiesBlocks.potted_chillweed});
        event.register((state, world, pos, index) -> {
            Biome biome;
            if (mc.f_91073_ != null && pos != null && (mc.f_91073_.m_46472_().equals(SkiesDimensions.everdawnKey()) || (biome = (Biome)mc.f_91073_.m_204166_(pos).m_203334_()) != null && RegistryHelper.isInTag((Registry)mc.f_91073_.m_5962_().m_175515_(Registry.f_122885_), SkiesBiomeTags.EVERDAWN, (Object)biome))) {
                return world != null ? BiomeColors.m_108793_((BlockAndTintGetter)world, (BlockPos)pos) : 14843647;
            }
            return 14843647;
        }, new Block[]{SkiesBlocks.lunar_grass_block, SkiesBlocks.lunar_grass, SkiesBlocks.tall_lunar_grass, SkiesBlocks.muckweed, SkiesBlocks.potted_muckweed, SkiesBlocks.lucentroot, SkiesBlocks.potted_lucentroot});
        event.register((state, world, pos, index) -> 9269656, new Block[]{SkiesBlocks.moonlit_water_lily});
    }

    @SubscribeEvent
    public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((itemStack, index) -> index == 0 ? ToolUtils.getHandleColor(itemStack) : -1, (ItemLike[])SkiesItems.coloredTools.toArray(new Item[0]));
        event.register((itemStack, index) -> index == 0 ? 0xFFFFFF : -1, new ItemLike[]{SkiesBlocks.turquoise_grass_block, SkiesBlocks.turquoise_grass, SkiesBlocks.tall_turquoise_grass, SkiesBlocks.brittlebush, SkiesBlocks.chillweed});
        event.register((itemStack, index) -> index == 0 ? 14843647 : -1, new ItemLike[]{SkiesBlocks.lunar_grass_block, SkiesBlocks.lunar_grass, SkiesBlocks.tall_lunar_grass, SkiesBlocks.muckweed, SkiesBlocks.lucentroot});
        event.register((itemStack, index) -> index == 0 ? 9269656 : -1, new ItemLike[]{SkiesItems.moonlit_water_lily});
        event.register((itemStack, index) -> {
            PreparedFood preparedFood = FoodPrepUtils.deserialize(itemStack.m_41783_());
            List<ItemStack> ingredients = preparedFood.getIngredients();
            if (index == 1) {
                if (ingredients.size() > 0) {
                    return FoodPrepUtils.FoodColor.get((Item)ingredients.get((int)0).m_41720_()).color;
                }
                return FoodPrepUtils.FoodColor.BEEF.color;
            }
            if (index == 2) {
                if (ingredients.size() > 1) {
                    return FoodPrepUtils.FoodColor.get((Item)ingredients.get((int)1).m_41720_()).color;
                }
                return FoodPrepUtils.FoodColor.LETTUCE.color;
            }
            if (index == 3) {
                List<MobEffectInstance> effects = preparedFood.getEffects();
                if (effects.size() > 0) {
                    return effects.get(0).m_19544_().m_19484_();
                }
                if (ingredients.size() > 2) {
                    return FoodPrepUtils.FoodColor.get((Item)ingredients.get((int)2).m_41720_()).color;
                }
                return FoodPrepUtils.FoodColor.CHEESE.color;
            }
            return -1;
        }, new ItemLike[]{SkiesItems.prepared_food});
    }
}

