/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.particle.data;

import com.legacy.blue_skies.registries.SkiesParticles;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class PoisonData
implements ParticleOptions {
    public static final ParticleOptions.Deserializer<PoisonData> DESERIALIZER = new ParticleOptions.Deserializer<PoisonData>(){

        public PoisonData fromCommand(ParticleType<PoisonData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            boolean small = reader.readBoolean();
            return new PoisonData(small);
        }

        public PoisonData fromNetwork(ParticleType<PoisonData> particleTypeIn, FriendlyByteBuf buffer) {
            return new PoisonData(buffer.readBoolean());
        }
    };
    public static final Codec<PoisonData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("small").forGetter(poisonData -> poisonData.isSmall())).apply((Applicative)instance, PoisonData::new));
    private final boolean small;

    public PoisonData(boolean small) {
        this.small = small;
    }

    public ParticleType<PoisonData> m_6012_() {
        return SkiesParticles.POISON;
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.small);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s small=%s", ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()), this.small ? "true" : "false");
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isSmall() {
        return this.small;
    }
}

