/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.data.objects.alchemy;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.data.managers.SkiesDataManager;
import com.legacy.blue_skies.data.objects.IToJson;
import com.legacy.blue_skies.data.objects.alchemy.CatylistRecipe;
import com.legacy.blue_skies.data.objects.alchemy.TransmuteRecipe;
import com.legacy.blue_skies.util.ListSet;
import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public abstract class AlchemyRecipe
implements IToJson<AlchemyRecipe> {
    public final boolean shouldOverride;
    public final ResourceLocation type;

    public AlchemyRecipe(boolean shouldOverride, ResourceLocation type) {
        this.shouldOverride = shouldOverride;
        this.type = type;
    }

    protected static <R extends AlchemyRecipe> Products.P2<RecordCodecBuilder.Mu<R>, Boolean, ResourceLocation> parentCodec(RecordCodecBuilder.Instance<R> instance) {
        return instance.group((App)Codec.BOOL.optionalFieldOf("override", (Object)false).forGetter(r -> r.shouldOverride), (App)ResourceLocation.f_135803_.fieldOf("type").forGetter(r -> r.type));
    }

    public static ListSet<Item> computeValues(List<ResourceLocation> names, List<TagKey<Item>> tags) {
        return Stream.concat(names.stream().map(arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).getValue(arg_0)).filter(Objects::nonNull), tags.stream().map(arg_0 -> ((DefaultedRegistry)Registry.f_122827_).m_203431_(arg_0)).filter(Optional::isPresent).map(Optional::get).flatMap(HolderSet::m_203614_).map(Holder::get)).distinct().collect(ListSet.toListSet());
    }

    public static ListSet<Item> computeValues(List<ResourceLocation> names, List<TagKey<Item>> tags, Optional<Item> extra) {
        ListSet<Item> computed = AlchemyRecipe.computeValues(names, tags);
        if (extra.isPresent()) {
            return Stream.concat(Stream.of(extra).filter(Optional::isPresent).map(Optional::get), computed.stream()).distinct().collect(ListSet.toListSet());
        }
        return computed;
    }

    public abstract void mergeRecipe(AlchemyRecipe var1);

    public abstract List<Item> getResults(Item var1, Item var2);

    public abstract List<Item> getResults();

    public abstract boolean matches(Item var1, Item var2);

    public abstract AlchemyRecipe fromJson(JsonObject var1) throws SkiesDataManager.RegistryObjectNotFoundException;

    protected List<Item> toItemList(List<ResourceLocation> resourceLocationSet) {
        return resourceLocationSet.stream().filter(arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).containsKey(arg_0)).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).getValue(arg_0)).collect(Collectors.toList());
    }

    @Nullable
    public AlchemyRecipe fromNbt(CompoundTag nbt) {
        try {
            return this.fromJson(((JsonElement)NbtOps.f_128958_.convertTo((DynamicOps)JsonOps.INSTANCE, (Tag)nbt)).getAsJsonObject());
        }
        catch (Exception e) {
            SkiesDataManager.LOGGER.error("Failed to read an alchemy recipe from nbt {}");
            return null;
        }
    }

    public CompoundTag toNbt(AlchemyRecipe recipe) {
        if (this.getClass().isInstance(recipe)) {
            return (CompoundTag)JsonOps.INSTANCE.convertTo((DynamicOps)NbtOps.f_128958_, (JsonElement)this.toJson());
        }
        throw new IllegalArgumentException("The recipe passed was not an instanceof " + this.getClass().toString());
    }

    public static String getDirectory() {
        return "alchemy_recipes";
    }

    public static class Types {
        private static final Map<ResourceLocation, AlchemyRecipe> REGISTRY = new HashMap<ResourceLocation, AlchemyRecipe>();
        private static final String TYPE_KEY = "type";

        public static void register(AlchemyRecipe recipeDefault) {
            REGISTRY.put(recipeDefault.type, recipeDefault);
        }

        public static AlchemyRecipe parse(JsonObject json) {
            ResourceLocation name = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)TYPE_KEY));
            return Types.get(name);
        }

        public static AlchemyRecipe parse(CompoundTag nbt) {
            ResourceLocation name = new ResourceLocation(nbt.m_128461_(TYPE_KEY));
            return Types.get(name);
        }

        public static AlchemyRecipe get(ResourceLocation name) {
            if (REGISTRY.containsKey(name)) {
                return REGISTRY.get(name);
            }
            IllegalArgumentException e = new IllegalArgumentException(name.toString() + " is not a registered recipe type!");
            BlueSkies.LOGGER.fatal((Object)e);
            throw e;
        }

        static {
            Types.register(TransmuteRecipe.builder("default").items(new ItemLike[]{Items.f_41852_}).build());
            Types.register(CatylistRecipe.builder("default").input(new ItemLike[]{Items.f_41852_}).catylist(new ItemLike[]{Items.f_41852_}).results(new ItemLike[]{Items.f_41852_}).build());
        }
    }
}

