/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.hostile;

import com.legacy.blue_skies.client.particle.StarFlareParticle;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.blue_skies.util.LogicUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ambient.AmbientCreature;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FrostSpiritEntity
extends AmbientCreature {
    private BlockPos spawnPosition;
    public float wingRotation;
    public float destPos;
    public float prevDestPos;
    public float prevWingRotation;
    protected int ticksUntilFlap;

    public FrostSpiritEntity(EntityType<? extends FrostSpiritEntity> type, Level world) {
        super(type, world);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 3.0);
    }

    protected float m_6121_() {
        return 1.0f;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SkiesSounds.ENTITY_FROST_SPIRIT_HURT;
    }

    protected SoundEvent m_5592_() {
        return SkiesSounds.ENTITY_FROST_SPIRIT_DEATH;
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_7324_(Entity entityIn) {
    }

    protected void m_6138_() {
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.EVENTS;
    }

    public boolean m_142535_(float p_225503_1_, float p_225503_2_, DamageSource source) {
        return false;
    }

    protected void m_7840_(double p_184231_1_, boolean p_184231_3_, BlockState p_184231_4_, BlockPos p_184231_5_) {
    }

    public boolean m_6090_() {
        return true;
    }

    public float m_20236_(Pose pose) {
        return this.m_20206_() / 2.0f;
    }

    protected void m_8024_() {
        super.m_8024_();
        if (!(this.spawnPosition == null || this.f_19853_.m_46859_(this.spawnPosition) && this.spawnPosition.m_123342_() >= 1)) {
            this.spawnPosition = null;
        }
        if (this.spawnPosition == null || this.f_19796_.m_188503_(30) == 0 || this.spawnPosition.m_203195_((Position)this.m_20182_(), 2.0)) {
            this.spawnPosition = new BlockPos((int)this.m_20185_() + this.f_19796_.m_188503_(7) - this.f_19796_.m_188503_(7), (int)this.m_20186_() + this.f_19796_.m_188503_(6) - 2, (int)this.m_20189_() + this.f_19796_.m_188503_(7) - this.f_19796_.m_188503_(7));
        }
        double d0 = (double)this.spawnPosition.m_123341_() + 0.5 - this.m_20185_();
        double d1 = (double)this.spawnPosition.m_123342_() + 0.1 - this.m_20186_();
        double d2 = (double)this.spawnPosition.m_123343_() + 0.5 - this.m_20189_();
        Vec3 vec3d = this.m_20184_();
        Vec3 vec3d1 = vec3d.m_82520_((Math.signum(d0) * 0.5 - vec3d.f_82479_) * (double)0.1f, (Math.signum(d1) * (double)0.7f - vec3d.f_82480_) * (double)0.1f, (Math.signum(d2) * 0.5 - vec3d.f_82481_) * (double)0.1f);
        this.m_20256_(vec3d1);
        float f = (float)(Mth.m_14136_((double)vec3d1.f_82481_, (double)vec3d1.f_82479_) * 57.2957763671875) - 90.0f;
        float f1 = Mth.m_14177_((float)(f - this.m_146908_()));
        this.f_20902_ = 1.0f;
        this.m_146922_(this.m_146908_() + f1);
    }

    public void updateWingRotation() {
        if (!this.f_19861_) {
            this.ticksUntilFlap = this.ticksUntilFlap == 0 ? 25 : --this.ticksUntilFlap;
        }
        this.prevWingRotation = this.wingRotation;
        this.prevDestPos = this.destPos;
        this.destPos = (float)((double)this.destPos + 0.2);
        this.destPos = FrostSpiritEntity.minMax(0.01f, 1.0f, this.destPos);
        this.wingRotation += 1.233f;
    }

    public static float minMax(float min, float max, float value) {
        return Math.min(max, Math.max(min, value));
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_20256_(this.m_20184_().m_82542_(1.0, 0.6, 1.0));
        if (this.f_19853_.f_46443_ && this.f_19796_.m_188501_() < 0.5f) {
            this.spawnParticles();
        }
        this.updateWingRotation();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnParticles() {
        double offset = 0.2;
        double x = LogicUtil.plusOrMinus(this.m_20185_(), offset, this.f_19796_);
        double y = LogicUtil.plusOrMinus(this.m_20186_(), offset, this.f_19796_);
        double z = LogicUtil.plusOrMinus(this.m_20189_(), offset, this.f_19796_);
        double motion = 0.025;
        double dx = LogicUtil.plusOrMinus(motion, this.f_19796_);
        double dy = LogicUtil.plusOrMinus(motion, this.f_19796_);
        double dz = LogicUtil.plusOrMinus(motion, this.f_19796_);
        this.f_19853_.m_7106_((ParticleOptions)StarFlareParticle.dyeToRGB(DyeColor.WHITE), x, y, z, dx, dy, dz);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.f_19797_ < 7) {
            return false;
        }
        return super.m_6469_(source, amount);
    }
}

