/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.biome_provider.region;

import com.legacy.blue_skies.world.biome_provider.region.BiomeRegion;
import com.legacy.blue_skies.world.biome_provider.region.HeightRegion;

public class BakedWorldRegion {
    private final int scale;
    private final int length;
    private final int[][] biomes;
    private final int[][] heights;

    public BakedWorldRegion(BiomeRegion biomeRegion, HeightRegion heightRegion) {
        if (biomeRegion.scale != heightRegion.scale) {
            throw new IllegalStateException("The BiomeRegion has a different scale than the HeightRegion at x=" + biomeRegion.regionX * 1024 + " z=" + biomeRegion.regionZ * 1024);
        }
        biomeRegion.bake();
        heightRegion.bake();
        this.scale = biomeRegion.scale;
        this.length = this.scale - 1;
        this.biomes = (int[][])biomeRegion.getData().clone();
        this.heights = (int[][])heightRegion.getData().clone();
    }

    public int getBiome(int x, int z) {
        return this.getWithinScale(this.biomes, x, z);
    }

    public int getHeight(int x, int z) {
        return this.getWithinScale(this.heights, x, z);
    }

    private int getWithinScale(int[][] data, int x, int z) {
        double coordScale = (double)this.scale / 1024.0;
        int xPos = (int)Math.floor((double)x * coordScale) & this.length;
        int zPos = (int)Math.floor((double)z * coordScale) & this.length;
        return data[xPos][zPos];
    }
}

