/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everdawn.gen.structures.poison_dungeon;

import com.google.common.collect.ImmutableList;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.block_entity.KeystoneBlockEntity;
import com.legacy.blue_skies.blocks.dungeon.PoisonKeystoneBlock;
import com.legacy.blue_skies.data.providers.SkiesLootProv;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.registries.SkiesStructures;
import com.legacy.blue_skies.world.util.structure_processors.VinesProcessor;
import com.legacy.structure_gel.api.structure.GelTemplateStructurePiece;
import com.legacy.structure_gel.api.structure.IColoredBoundingBox;
import com.legacy.structure_gel.api.structure.processor.RandomBlockSwapProcessor;
import com.legacy.structure_gel.api.structure.processor.RemoveGelStructureProcessor;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class PoisonDungeonPieces {
    private static final ResourceLocation TREE = BlueSkies.locate("dungeons/everdawn/poison/tree");
    private static final ResourceLocation TUNNEL = BlueSkies.locate("dungeons/everdawn/poison/entry_tunnel");

    public static void assemble(StructureTemplateManager templateManager, BlockPos surfacePos, Rotation rotation, StructurePiecesBuilder pieces, RandomSource rand, RandomState randomState) {
        int i;
        ArrayList<Floor> floors = new ArrayList<Floor>();
        int y = 45;
        if (surfacePos.m_123342_() < 60) {
            surfacePos = new BlockPos(surfacePos.m_123341_(), 60, surfacePos.m_123343_());
        }
        floors.add(new Floor(0, new BlockPos(surfacePos.m_123341_(), y, surfacePos.m_123343_()), (Pair<Integer, Integer>)Pair.of((Object)8, (Object)8), rand));
        for (i = 0; i < 3; ++i) {
            floors.add(new Floor(i + 1, new BlockPos(surfacePos.m_123341_(), y - (i + 1) * 10, surfacePos.m_123343_()), ((Floor)floors.get((int)i)).exitPair, rand));
        }
        floors.add(new BossFloor(floors.size(), new BlockPos(surfacePos.m_123341_(), y - floors.size() * 10, surfacePos.m_123343_()), ((Floor)floors.get((int)(floors.size() - 1))).exitPair, rand));
        floors.forEach(floor -> floor.addPieces(pieces, templateManager));
        for (i = y + 5; i <= surfacePos.m_123342_(); ++i) {
            pieces.m_142679_((StructurePiece)new Piece(templateManager, new BlockPos(surfacePos.m_123341_() + 2, i, surfacePos.m_123343_() + 2), TUNNEL, rand));
        }
        pieces.m_142679_((StructurePiece)new Piece(templateManager, surfacePos.m_7918_(-6, 0, -7), TREE, rand));
    }

    public static class Floor {
        public List<List<Segment>> map = new ArrayList<List<Segment>>();
        public final BlockPos worldPos;
        public Pair<Integer, Integer> exitPair = Pair.of((Object)8, (Object)8);
        public final RandomSource rand;
        public final int level;
        public static final int size = 16;

        public Floor(int level, BlockPos worldPos, Pair<Integer, Integer> center, RandomSource rand) {
            this.level = level;
            this.worldPos = worldPos;
            this.rand = rand;
            for (int x = 0; x < 16; ++x) {
                ArrayList<Object> subList = new ArrayList<Object>(16);
                for (int z = 0; z < 16; ++z) {
                    subList.add(null);
                }
                this.map.add(subList);
            }
            this.init(center);
        }

        public void init(Pair<Integer, Integer> center) {
            int i;
            this.set((Integer)center.getFirst(), (Integer)center.getSecond(), new Intersection.Cross());
            ArrayList<Pair> firstBranches = new ArrayList<Pair>();
            for (i = 0; i < this.rand.m_188503_(2) + 3; ++i) {
                firstBranches.add(Pair.of((Object)this.rand.m_188503_(16), (Object)this.rand.m_188503_(16)));
            }
            firstBranches.forEach(pair -> this.connect((Integer)center.getFirst(), (Integer)center.getSecond(), (Integer)pair.getFirst(), (Integer)pair.getSecond()));
            for (i = 0; i < this.rand.m_188503_(5) + 6; ++i) {
                Pair<Integer, Integer> from = this.getRandomSegmentPos();
                Pair<Integer, Integer> to = this.randomPair();
                this.connect((Integer)from.getFirst(), (Integer)from.getSecond(), (Integer)to.getFirst(), (Integer)to.getSecond());
            }
            this.updateIntersections();
            this.changeToEntry(center);
            ArrayList<Pair> deadEnds = new ArrayList<Pair>();
            ArrayList<Pair> crosses = new ArrayList<Pair>();
            ArrayList<Pair> anyOfThem = new ArrayList<Pair>();
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    Segment seg = this.get(x, z);
                    if (seg == null || !(seg instanceof Intersection)) continue;
                    if (!Pair.of((Object)x, (Object)z).equals(center)) {
                        if (seg instanceof Intersection.End) {
                            deadEnds.add(Pair.of((Object)x, (Object)z));
                            continue;
                        }
                        if (!(seg instanceof Intersection.Cross)) continue;
                        crosses.add(Pair.of((Object)x, (Object)z));
                        continue;
                    }
                    anyOfThem.add(Pair.of((Object)x, (Object)z));
                }
            }
            if (!deadEnds.isEmpty()) {
                this.exitPair = (Pair)deadEnds.get(this.rand.m_188503_(deadEnds.size()));
                this.set((Integer)this.exitPair.getFirst(), (Integer)this.exitPair.getSecond(), new Stairway.End(this.get((int)((Integer)this.exitPair.getFirst()).intValue(), (int)((Integer)this.exitPair.getSecond()).intValue()).rotation));
            } else {
                this.exitPair = !crosses.isEmpty() ? (Pair)crosses.get(this.rand.m_188503_(crosses.size())) : (Pair)anyOfThem.get(this.rand.m_188503_(anyOfThem.size()));
                this.set((Integer)this.exitPair.getFirst(), (Integer)this.exitPair.getSecond(), new Stairway.Cross(this.get((int)((Integer)this.exitPair.getFirst()).intValue(), (int)((Integer)this.exitPair.getSecond()).intValue()).rotation));
            }
            ArrayList<Pair> intersections = new ArrayList<Pair>();
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    Segment checking = this.get(x, z);
                    if (checking == null || !(checking instanceof Intersection) || ((Intersection)checking).entry) continue;
                    intersections.add(Pair.of((Object)x, (Object)z));
                }
            }
            intersections.forEach(p -> {
                if (this.rand.m_188501_() < 0.4f) {
                    ((Intersection)this.get((Pair<Integer, Integer>)p)).setChest(true);
                }
            });
            Intersection keyRoom = (Intersection)this.get((Pair<Integer, Integer>)((Pair)intersections.get(this.rand.m_188503_(intersections.size()))));
            keyRoom.setKey(true);
            keyRoom.setChest(true);
        }

        public void changeToEntry(Pair<Integer, Integer> position) {
            Segment segOld = this.get((Integer)position.getFirst(), (Integer)position.getSecond());
            Intersection segNew = new Intersection.Cross(segOld.rotation, true);
            if (segOld != null) {
                if (segOld instanceof Intersection.End) {
                    segNew = new Intersection.End(segOld.rotation, true);
                } else if (segOld instanceof Intersection.IShape) {
                    segNew = new Intersection.IShape(segOld.rotation, true);
                } else if (segOld instanceof Intersection.LShape) {
                    segNew = new Intersection.LShape(segOld.rotation, true);
                } else if (segOld instanceof Intersection.TShape) {
                    segNew = new Intersection.TShape(segOld.rotation, true);
                }
            }
            this.set((Integer)position.getFirst(), (Integer)position.getSecond(), segNew);
        }

        public void updateIntersections() {
            for (int x = 0; x < 16; ++x) {
                block6: for (int z = 0; z < 16; ++z) {
                    if (this.get(x, z) == null) continue;
                    if (this.get(x, z) instanceof Intersection) {
                        List<Direction> conns = ((Intersection)this.get(x, z)).getSurroundingConnections(x, z, this);
                        switch (conns.size()) {
                            case 1: {
                                Rotation rot = Rotation.NONE;
                                if (conns.contains(Direction.EAST)) {
                                    rot = Rotation.CLOCKWISE_90;
                                } else if (conns.contains(Direction.SOUTH)) {
                                    rot = Rotation.CLOCKWISE_180;
                                } else if (conns.contains(Direction.WEST)) {
                                    rot = Rotation.COUNTERCLOCKWISE_90;
                                }
                                this.set(x, z, new Intersection.End(rot, false));
                                break;
                            }
                            case 2: {
                                if (conns.containsAll((Collection<?>)ImmutableList.of((Object)Direction.NORTH, (Object)Direction.SOUTH)) && !conns.containsAll((Collection<?>)ImmutableList.of((Object)Direction.EAST, (Object)Direction.WEST))) {
                                    this.set(x, z, new Intersection.IShape(this.rand.m_188499_() ? Rotation.NONE : Rotation.CLOCKWISE_180, false));
                                } else if (!conns.containsAll((Collection<?>)ImmutableList.of((Object)Direction.NORTH, (Object)Direction.SOUTH)) && conns.containsAll((Collection<?>)ImmutableList.of((Object)Direction.EAST, (Object)Direction.WEST))) {
                                    this.set(x, z, new Intersection.IShape(this.rand.m_188499_() ? Rotation.CLOCKWISE_90 : Rotation.COUNTERCLOCKWISE_90, false));
                                }
                                for (Rotation rot : Rotation.values()) {
                                    if (!conns.containsAll((Collection<?>)ImmutableList.of((Object)rot.m_55954_(Direction.NORTH), (Object)rot.m_55954_(Direction.WEST)))) continue;
                                    this.set(x, z, new Intersection.LShape(rot, false));
                                }
                                continue block6;
                            }
                            case 3: {
                                Rotation rot = Rotation.NONE;
                                if (!conns.contains(Direction.WEST)) {
                                    rot = Rotation.CLOCKWISE_90;
                                } else if (!conns.contains(Direction.NORTH)) {
                                    rot = Rotation.CLOCKWISE_180;
                                } else if (!conns.contains(Direction.EAST)) {
                                    rot = Rotation.COUNTERCLOCKWISE_90;
                                }
                                this.set(x, z, new Intersection.TShape(rot, false));
                                break;
                            }
                        }
                        continue;
                    }
                    if (!(this.get(x, z) instanceof Hallway)) continue;
                    this.set(x, z, new Hallway(this.get((int)x, (int)z).rotation.m_55952_(this.rand.m_188499_() ? Rotation.NONE : Rotation.CLOCKWISE_180)));
                }
            }
        }

        public Pair<Integer, Integer> getRandomSegmentPos() {
            Segment segment = null;
            Pair<Integer, Integer> pair = Pair.of((Object)8, (Object)8);
            while (segment == null || segment != null && segment instanceof BossRoom) {
                pair = this.randomPair();
                segment = this.get(pair);
            }
            return pair;
        }

        public Pair<Integer, Integer> randomPair() {
            return Pair.of((Object)this.rand.m_188503_(16), (Object)this.rand.m_188503_(16));
        }

        @Nullable
        public Segment get(int x, int z) {
            return this.map.get(x).get(z);
        }

        @Nullable
        public Segment get(Pair<Integer, Integer> pair) {
            return this.get((Integer)pair.getFirst(), (Integer)pair.getSecond());
        }

        public void set(int x, int z, Segment segment) {
            this.map.get(x).set(z, segment);
        }

        public void connect(int x, int z, int x1, int z1) {
            this.set(x, z, new Intersection.Cross());
            if (this.get(x1, z1) == null || !(this.get(x1, z1) instanceof BossRoom)) {
                this.set(x1, z1, new Intersection.Cross());
            }
            if (this.rand.m_188499_()) {
                int placements;
                for (placements = 0; x != x1 && placements < 50; ++placements) {
                    if (x < x1) {
                        ++x;
                    }
                    if (x > x1) {
                        --x;
                    }
                    if (this.get(x, z) == null) {
                        this.set(x, z, new Hallway(Rotation.CLOCKWISE_90));
                        continue;
                    }
                    if (this.get(x, z).equals(new Hallway(Rotation.CLOCKWISE_90))) continue;
                    this.set(x, z, new Intersection.Cross());
                }
                if (x == x1) {
                    this.set(x, z, new Intersection.Cross());
                }
                for (placements = 0; z != z1 && placements < 50; ++placements) {
                    if (z < z1) {
                        ++z;
                    }
                    if (z > z1) {
                        --z;
                    }
                    if (this.get(x, z) == null) {
                        this.set(x, z, new Hallway(Rotation.NONE));
                        continue;
                    }
                    if (this.get(x, z).equals(new Hallway(Rotation.NONE))) continue;
                    this.set(x, z, new Intersection.Cross());
                }
            } else {
                int placements;
                for (placements = 0; z != z1 && placements < 50; ++placements) {
                    if (z < z1) {
                        ++z;
                    }
                    if (z > z1) {
                        --z;
                    }
                    if (this.get(x, z) == null) {
                        this.set(x, z, new Hallway(Rotation.NONE));
                        continue;
                    }
                    if (this.get(x, z).equals(new Hallway(Rotation.NONE))) continue;
                    this.set(x, z, new Intersection.Cross());
                }
                if (z == z1) {
                    this.set(x, z, new Intersection.Cross());
                }
                for (placements = 0; x != x1 && placements < 50; ++placements) {
                    if (x < x1) {
                        ++x;
                    }
                    if (x > x1) {
                        --x;
                    }
                    if (this.get(x, z) == null) {
                        this.set(x, z, new Hallway(Rotation.CLOCKWISE_90));
                        continue;
                    }
                    if (this.get(x, z).equals(new Hallway(Rotation.CLOCKWISE_90))) continue;
                    this.set(x, z, new Intersection.Cross());
                }
            }
        }

        public void addPieces(StructurePiecesBuilder pieces, StructureTemplateManager templateManager) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    Segment seg = this.get(x, z);
                    if (seg == null) continue;
                    int yOffset = seg instanceof Stairway ? -5 : 0;
                    int xOffset = seg instanceof BossRoom ? -2 : 0;
                    pieces.m_142679_((StructurePiece)new Piece(templateManager, new BlockPos(this.worldPos.m_123341_() + (x - 8) * 9 + xOffset, this.worldPos.m_123342_() + yOffset, this.worldPos.m_123343_() + (z - 8) * 9), seg, this.level, this.rand));
                }
            }
        }
    }

    public static class BossFloor
    extends Floor {
        public BossFloor(int level, BlockPos worldPos, Pair<Integer, Integer> center, RandomSource rand) {
            super(level, worldPos, center, rand);
        }

        @Override
        public void init(Pair<Integer, Integer> center) {
            int middle = 8;
            Pair bossPos = Pair.of((Object)middle, (Object)middle);
            if ((Integer)center.getFirst() >= (Integer)bossPos.getFirst() - 3 && (Integer)center.getFirst() <= (Integer)bossPos.getFirst() + 3 && (Integer)center.getSecond() >= (Integer)bossPos.getSecond() - 3 && (Integer)center.getSecond() <= (Integer)bossPos.getSecond() + 3) {
                bossPos = Pair.of((Object)(middle + 5), (Object)(middle + 5));
            }
            this.set((Integer)center.getFirst(), (Integer)center.getSecond(), new Intersection.Cross());
            this.connect((Integer)center.getFirst(), (Integer)center.getSecond(), (Integer)bossPos.getFirst() + 1, (Integer)bossPos.getSecond() + 1);
            for (int x = ((Integer)bossPos.getFirst()).intValue(); x < (Integer)bossPos.getFirst() + 3; ++x) {
                for (int z = ((Integer)bossPos.getSecond()).intValue(); z < (Integer)bossPos.getSecond() + 3; ++z) {
                    this.set(x, z, null);
                }
            }
            this.set((Integer)bossPos.getFirst(), (Integer)bossPos.getSecond(), new BossRoom(Rotation.NONE));
            List<Direction> conns = this.get((Integer)bossPos.getFirst(), (Integer)bossPos.getSecond()).getSurroundingConnections((Integer)bossPos.getFirst(), (Integer)bossPos.getSecond(), this);
            Rotation rot = Rotation.NONE;
            if (conns.contains(Direction.SOUTH)) {
                rot = Rotation.CLOCKWISE_180;
            } else if (conns.contains(Direction.EAST)) {
                rot = Rotation.CLOCKWISE_90;
            } else if (conns.contains(Direction.WEST)) {
                rot = Rotation.COUNTERCLOCKWISE_90;
            }
            this.set((Integer)bossPos.getFirst(), (Integer)bossPos.getSecond(), new BossRoom(rot));
            this.updateIntersections();
            this.changeToEntry(center);
        }

        @Override
        public void connect(int x, int z, int x1, int z1) {
            if (Math.abs(x - x1) < Math.abs(z - z1)) {
                super.connect(x, z, x1, z);
                super.connect(x1, z, x1, z1);
            } else {
                super.connect(x, z, x, z1);
                super.connect(x, z1, x1, z1);
            }
        }
    }

    public static class Piece
    extends GelTemplateStructurePiece
    implements IColoredBoundingBox {
        private final boolean hasKey;

        public Piece(StructureTemplateManager templateManager, BlockPos pos, Segment segment, int level, RandomSource rand) {
            super((StructurePieceType)SkiesStructures.POISON_DUNGEON.getPieceType().get(), 0, templateManager, segment.getRandom(level, rand), pos);
            this.hasKey = segment instanceof Intersection ? ((Intersection)segment).key : false;
            this.f_73379_ = segment.rotation;
            this.f_73658_ = pos;
            this.setupPlaceSettings(templateManager);
        }

        public Piece(StructureTemplateManager templateManager, BlockPos pos, ResourceLocation name, RandomSource rand) {
            super((StructurePieceType)SkiesStructures.POISON_DUNGEON.getPieceType().get(), 0, templateManager, name, pos);
            this.hasKey = false;
            this.f_73379_ = Rotation.NONE;
            this.f_73658_ = pos;
            this.setupPlaceSettings(templateManager);
        }

        public Piece(StructurePieceSerializationContext context, CompoundTag nbt) {
            super((StructurePieceType)SkiesStructures.POISON_DUNGEON.getPieceType().get(), nbt, context.f_226956_());
            this.hasKey = nbt.m_128471_("HasKey");
            this.setupPlaceSettings(context.f_226956_());
        }

        protected void m_183620_(StructurePieceSerializationContext context, CompoundTag nbt) {
            super.m_183620_(context, nbt);
            nbt.m_128379_("HasKey", this.hasKey);
        }

        public StructurePlaceSettings getPlaceSettings(StructureTemplateManager templateManager) {
            Vec3i sizePos = ((StructureTemplate)templateManager.m_230407_(this.m_142415_()).get()).m_163801_();
            BlockPos centerPos = new BlockPos(sizePos.m_123341_() / 2, 0, sizePos.m_123343_() / 2);
            StructurePlaceSettings settings = new StructurePlaceSettings().m_163782_(false).m_74379_(this.f_73379_).m_74385_(centerPos);
            settings.m_74383_((StructureProcessor)RemoveGelStructureProcessor.INSTANCE);
            settings.m_74383_((StructureProcessor)BlockIgnoreProcessor.f_74046_);
            settings.m_74383_((StructureProcessor)new VinesProcessor());
            String key = this.f_163658_;
            if (key.endsWith("_0")) {
                for (Block block : new Block[]{SkiesBlocks.poison_stone_slab, SkiesBlocks.poison_stone_stairs}) {
                    settings.m_74383_((StructureProcessor)new RandomBlockSwapProcessor(block, 0.5f, Blocks.f_50016_));
                }
                settings.m_74383_((StructureProcessor)new RandomBlockSwapProcessor(SkiesBlocks.poison_stone, 0.02f, SkiesBlocks.glowing_poison_stone));
            } else if (key.endsWith("_1")) {
                for (Block block : new Block[]{SkiesBlocks.poison_stone_slab, SkiesBlocks.poison_stone_stairs, SkiesBlocks.poison_stonebrick_slab, SkiesBlocks.poison_stonebrick_stairs}) {
                    settings.m_74383_((StructureProcessor)new RandomBlockSwapProcessor(block, 0.5f, Blocks.f_50016_));
                }
                settings.m_74383_((StructureProcessor)new RandomBlockSwapProcessor(SkiesBlocks.poison_stone, 0.02f, SkiesBlocks.glowing_poison_stone));
                settings.m_74383_((StructureProcessor)new RandomBlockSwapProcessor(SkiesBlocks.poison_stone, 0.3f, SkiesBlocks.rough_poison_stonebrick));
            } else if (key.endsWith("_2")) {
                for (Block block : new Block[]{SkiesBlocks.poison_stone_slab, SkiesBlocks.poison_stone_stairs, SkiesBlocks.poison_stonebrick_slab, SkiesBlocks.poison_stonebrick_stairs}) {
                    settings.m_74383_((StructureProcessor)new RandomBlockSwapProcessor(block, 0.5f, Blocks.f_50016_));
                }
                settings.m_74383_((StructureProcessor)new RandomBlockSwapProcessor(SkiesBlocks.poison_stone, 0.02f, SkiesBlocks.glowing_poison_stone));
                settings.m_74383_((StructureProcessor)new RandomBlockSwapProcessor(SkiesBlocks.poison_stone, 0.75f, SkiesBlocks.rough_poison_stonebrick));
            } else if (key.endsWith("_3")) {
                settings.m_74383_((StructureProcessor)new RandomBlockSwapProcessor(Blocks.f_50141_, 0.5f, SkiesBlocks.rough_poison_stonebrick));
                settings.m_74383_((StructureProcessor)new RandomBlockSwapProcessor(SkiesBlocks.poison_stonebrick, 0.5f, SkiesBlocks.rough_poison_stonebrick));
                if (!key.contains("_chest")) {
                    settings.m_74383_((StructureProcessor)new RandomBlockSwapProcessor(SkiesBlocks.spider_webbing, 0.8f, Blocks.f_50016_));
                }
            } else if (key.endsWith("_4") && !key.contains("_chest")) {
                settings.m_74383_((StructureProcessor)new RandomBlockSwapProcessor(SkiesBlocks.spider_webbing, 0.8f, Blocks.f_50016_));
            }
            if (this.m_142415_() == TUNNEL) {
                settings.m_74383_((StructureProcessor)new RandomBlockSwapProcessor(SkiesBlocks.lunar_stone, 0.8f, SkiesBlocks.lunar_cobblestone));
                settings.m_74383_((StructureProcessor)new RandomBlockSwapProcessor(SkiesBlocks.lunar_stone, 0.5f, SkiesBlocks.poison_stone));
            }
            if (key.contains("_chest")) {
                settings.m_74383_((StructureProcessor)new RandomBlockSwapProcessor(Blocks.f_50033_, 0.3f, Blocks.f_50016_));
                settings.m_74383_((StructureProcessor)new RandomBlockSwapProcessor(SkiesBlocks.spider_webbing, 0.3f, Blocks.f_50016_));
            }
            if (key.contains("boss_room")) {
                settings.m_74383_((StructureProcessor)new RandomBlockSwapProcessor(SkiesBlocks.poison_stonebrick, 0.08f, SkiesBlocks.rough_poison_stonebrick));
                settings.m_74383_((StructureProcessor)new RandomBlockSwapProcessor(SkiesBlocks.poison_stone, 0.08f, SkiesBlocks.glowing_poison_stone));
            }
            return settings;
        }

        protected void m_213704_(String key, BlockPos pos, ServerLevelAccessor level, RandomSource rand, BoundingBox sbb) {
            BlockEntity blockEntity;
            if (key.contains("chest")) {
                BlockPos downPos = pos.m_7495_();
                if (sbb.m_71051_((Vec3i)downPos)) {
                    RandomizableContainerBlockEntity.m_222766_((BlockGetter)level, (RandomSource)rand, (BlockPos)downPos, (ResourceLocation)(this.hasKey ? SkiesLootProv.POISON_CHEST_KEY : SkiesLootProv.POISON_CHEST));
                }
                level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 2);
            }
            if (key.contains("spawner")) {
                level.m_7731_(pos, Blocks.f_50085_.m_49966_(), 2);
                blockEntity = level.m_7702_(pos);
                if (blockEntity instanceof SpawnerBlockEntity) {
                    SpawnerBlockEntity spawner = (SpawnerBlockEntity)blockEntity;
                    spawner.m_59801_().m_45462_(rand.m_188499_() ? SkiesEntityTypes.VENOM_SPIDER : EntityType.f_20554_);
                }
            }
            if ("keystone".equals(key)) {
                level.m_7731_(pos, SkiesBlocks.rough_poison_stonebrick.m_49966_(), 2);
                blockEntity = level.m_7702_(pos.m_6630_(2));
                if (blockEntity instanceof KeystoneBlockEntity.PoisonKeystoneBlockEntity) {
                    KeystoneBlockEntity.PoisonKeystoneBlockEntity keystone = (KeystoneBlockEntity.PoisonKeystoneBlockEntity)blockEntity;
                    Direction dir = (Direction)level.m_8055_(pos.m_6630_(2)).m_61143_((Property)PoisonKeystoneBlock.FACING);
                    keystone.setTeleportOffset(new BlockPos(0, -1, 0).m_5484_(dir, -3));
                    keystone.setSpawnOffset(new BlockPos(0, -1, 0).m_5484_(dir, -12));
                }
            }
        }

        public int getBoundingBoxColor() {
            return this.hasKey ? IColoredBoundingBox.RED : IColoredBoundingBox.GREEN;
        }
    }

    public static class BossRoom
    extends Segment {
        public BossRoom(Rotation rotation) {
            this.rotation = rotation;
        }

        @Override
        protected void initPieces() {
            this.addPieces(4, "boss_room");
        }

        @Override
        public List<Direction> getConnections() {
            return List.of(this.rotation.m_55954_(Direction.NORTH));
        }

        @Override
        public List<Direction> getSurroundingConnections(int x, int z, Floor floor) {
            ArrayList<Direction> directions = new ArrayList<Direction>();
            if (x > 0 && z < 15 && floor.get(x - 1, z + 1) != null && floor.get(x - 1, z + 1).getConnections().contains(Direction.EAST)) {
                directions.add(Direction.WEST);
            }
            if (x < 13 && z > 0 && floor.get(x + 3, z + 1) != null && floor.get(x + 3, z + 1).getConnections().contains(Direction.WEST)) {
                directions.add(Direction.EAST);
            }
            if (x < 15 && z > 0 && floor.get(x + 1, z - 1) != null && floor.get(x + 1, z - 1).getConnections().contains(Direction.SOUTH)) {
                directions.add(Direction.NORTH);
            }
            if (x < 15 && z < 13 && floor.get(x + 1, z + 3) != null && floor.get(x + 1, z + 3).getConnections().contains(Direction.NORTH)) {
                directions.add(Direction.SOUTH);
            }
            return directions;
        }
    }

    public static abstract class Stairway
    extends Segment {
        public Stairway(Rotation rotation) {
            this.rotation = rotation;
        }

        public static class End
        extends Stairway {
            public End(Rotation rotation) {
                super(rotation);
            }

            @Override
            protected void initPieces() {
                for (int i = 0; i < 4; ++i) {
                    this.addPieces(i, "stairway/end_" + i);
                }
            }
        }

        public static class Cross
        extends Stairway {
            public Cross(Rotation rotation) {
                super(rotation);
            }

            @Override
            protected void initPieces() {
                for (int i = 0; i < 4; ++i) {
                    this.addPieces(i, "stairway/cross_" + i);
                }
            }
        }
    }

    public static class Hallway
    extends Segment {
        public Hallway(Rotation rotation) {
            this.rotation = rotation;
        }

        @Override
        protected void initPieces() {
            for (int i = 0; i < 4; ++i) {
                this.addPieces(i, "hallway/thin_" + i, "hallway/thick_" + i);
            }
            this.addPieces(4, "hallway/thick_4");
        }

        @Override
        public List<Direction> getConnections() {
            return ImmutableList.of((Object)this.rotation.m_55954_(Direction.NORTH), (Object)this.rotation.m_55954_(Direction.SOUTH));
        }
    }

    public static abstract class Intersection
    extends Segment {
        public boolean hasConnection = false;
        public boolean entry = false;
        public boolean chestRoom = false;
        public boolean key = false;
        public String type = "cross";

        @Override
        protected void initPieces() {
            String prefix = "intersection/" + (this.entry ? "entry/" : (this.chestRoom ? "room/" : "")) + this.type;
            for (int floor = 0; floor < 5; ++floor) {
                this.addPieces(floor, prefix + (this.chestRoom && floor < 4 ? "_chest_" : "_") + floor);
            }
        }

        public void setChest(boolean hasChest) {
            this.chestRoom = hasChest;
        }

        public void setKey(boolean key) {
            this.key = key;
        }

        public static class End
        extends Intersection {
            public End(Rotation rotation, boolean entry) {
                this.rotation = rotation;
                this.entry = entry;
                this.type = "end";
            }

            @Override
            public List<Direction> getConnections() {
                return ImmutableList.of((Object)this.rotation.m_55954_(Direction.NORTH));
            }
        }

        public static class IShape
        extends Intersection {
            public IShape(Rotation rotation, boolean entry) {
                this.rotation = rotation;
                this.entry = entry;
                this.type = "i";
            }

            @Override
            public List<Direction> getConnections() {
                return ImmutableList.of((Object)this.rotation.m_55954_(Direction.NORTH), (Object)this.rotation.m_55954_(Direction.SOUTH));
            }
        }

        public static class LShape
        extends Intersection {
            public LShape(Rotation rotation, boolean entry) {
                this.rotation = rotation;
                this.entry = entry;
                this.type = "l";
            }

            @Override
            public List<Direction> getConnections() {
                return ImmutableList.of((Object)this.rotation.m_55954_(Direction.NORTH), (Object)this.rotation.m_55954_(Direction.WEST));
            }
        }

        public static class TShape
        extends Intersection {
            public TShape(Rotation rotation, boolean entry) {
                this.rotation = rotation;
                this.entry = entry;
                this.type = "t";
            }

            @Override
            public List<Direction> getConnections() {
                return ImmutableList.of((Object)this.rotation.m_55954_(Direction.NORTH), (Object)this.rotation.m_55954_(Direction.EAST), (Object)this.rotation.m_55954_(Direction.WEST));
            }
        }

        public static class Cross
        extends Intersection {
            public Cross() {
                this(Rotation.NONE, false);
            }

            public Cross(Rotation rotation, boolean entry) {
                this.rotation = rotation;
                this.entry = entry;
            }

            @Override
            public List<Direction> getConnections() {
                return ImmutableList.of((Object)Direction.WEST, (Object)Direction.EAST, (Object)Direction.NORTH, (Object)Direction.SOUTH);
            }
        }
    }

    public static abstract class Segment {
        public List<Direction> connections = new ArrayList<Direction>();
        public Map<Integer, List<ResourceLocation>> pieces = new HashMap<Integer, List<ResourceLocation>>();
        public Rotation rotation = Rotation.NONE;

        public ResourceLocation getRandom(int level, RandomSource rand) {
            this.initPieces();
            if (this.pieces.containsKey(level)) {
                return this.pieces.get(level).get(rand.m_188503_(this.pieces.get(level).size()));
            }
            if (this.pieces.entrySet().stream().findFirst().isPresent()) {
                Map.Entry entry = (Map.Entry)this.pieces.entrySet().stream().findFirst().get();
                return (ResourceLocation)((List)entry.getValue()).get(rand.m_188503_(((List)entry.getValue()).size()));
            }
            BlueSkies.LOGGER.warn(String.format("Missing structure pieces for %s on floor %d", SkiesStructures.POISON_DUNGEON.getRegistryName(), level));
            return new ResourceLocation("empty");
        }

        public List<Direction> getConnections() {
            return ImmutableList.of();
        }

        public List<Direction> getSurroundingConnections(int x, int z, Floor floor) {
            ArrayList<Direction> directions = new ArrayList<Direction>();
            if (x > 0 && floor.get(x - 1, z) != null && floor.get(x - 1, z).getConnections().contains(Direction.EAST)) {
                directions.add(Direction.WEST);
            }
            if (x < 15 && floor.get(x + 1, z) != null && floor.get(x + 1, z).getConnections().contains(Direction.WEST)) {
                directions.add(Direction.EAST);
            }
            if (z > 0 && floor.get(x, z - 1) != null && floor.get(x, z - 1).getConnections().contains(Direction.SOUTH)) {
                directions.add(Direction.NORTH);
            }
            if (z < 15 && floor.get(x, z + 1) != null && floor.get(x, z + 1).getConnections().contains(Direction.NORTH)) {
                directions.add(Direction.SOUTH);
            }
            return directions;
        }

        protected void addPieces(int level, String ... names) {
            this.pieces.put(level, Arrays.asList(names).stream().map(s -> BlueSkies.locate("dungeons/everdawn/poison/" + s)).collect(Collectors.toList()));
        }

        public boolean equals(Segment segment) {
            return this.rotation == segment.rotation && this.getClass() == segment.getClass();
        }

        protected abstract void initPieces();
    }
}

