/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.forge.energy;

import earth.terrarium.botarium.api.Serializable;
import earth.terrarium.botarium.api.energy.StatefulEnergyContainer;
import earth.terrarium.botarium.forge.AutoSerializable;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ForgeEnergyContainer(StatefulEnergyContainer<BlockEntity> container, BlockEntity entity) implements IEnergyStorage,
AutoSerializable,
ICapabilityProvider
{
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction arg) {
        LazyOptional of = LazyOptional.of((NonNullSupplier)(this.container.getContainer(arg) != null ? () -> this : null));
        return capability.orEmpty(ForgeCapabilities.ENERGY, of.cast()).cast();
    }

    public int receiveEnergy(int maxAmount, boolean bl) {
        if (maxAmount <= 0) {
            return 0;
        }
        int inserted = (int)this.container.insertEnergy(Math.min((long)maxAmount, this.container.maxInsert()), bl);
        this.container.update(this.entity);
        return inserted;
    }

    public int extractEnergy(int maxAmount, boolean bl) {
        if (maxAmount <= 0) {
            return 0;
        }
        int extracted = (int)this.container.extractEnergy(Math.min((long)maxAmount, this.container.maxExtract()), bl);
        this.container.update(this.entity);
        return extracted;
    }

    public int getEnergyStored() {
        return (int)this.container.getStoredEnergy();
    }

    public int getMaxEnergyStored() {
        return (int)this.container.getMaxCapacity();
    }

    public boolean canExtract() {
        return this.container.allowsExtraction();
    }

    public boolean canReceive() {
        return this.container.allowsInsertion();
    }

    @Override
    public Serializable getSerializable() {
        return this.container;
    }
}

