/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.screen;

import com.direwolf20.buildinggadgets.client.screen.CopyGUI;
import com.direwolf20.buildinggadgets.client.screen.DestructionGUI;
import com.direwolf20.buildinggadgets.client.screen.MaterialListGUI;
import com.direwolf20.buildinggadgets.client.screen.PasteGUI;
import com.direwolf20.buildinggadgets.common.items.GadgetCopyPaste;
import com.direwolf20.buildinggadgets.common.items.GadgetDestruction;
import com.direwolf20.buildinggadgets.common.items.TemplateItem;
import com.direwolf20.buildinggadgets.common.util.lang.LangUtil;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public enum GuiMod {
    COPY(GadgetCopyPaste::getGadget, stack -> () -> new CopyGUI((ItemStack)stack)),
    PASTE(GadgetCopyPaste::getGadget, stack -> () -> new PasteGUI((ItemStack)stack)),
    DESTRUCTION(GadgetDestruction::getGadget, stack -> () -> new DestructionGUI((ItemStack)stack)),
    MATERIAL_LIST(TemplateItem::getTemplateItem, stack -> () -> new MaterialListGUI((ItemStack)stack));

    private final Function<Player, ItemStack> stackReader;
    private final Function<ItemStack, Supplier<? extends Screen>> clientScreenProvider;

    private GuiMod(Function<Player, ItemStack> stackReader, Function<ItemStack, Supplier<? extends Screen>> clientScreenProvider) {
        this.stackReader = stackReader;
        this.clientScreenProvider = clientScreenProvider;
    }

    public boolean openScreen(Player player) {
        if (this.clientScreenProvider == null) {
            return false;
        }
        ItemStack stack = this.stackReader.apply(player);
        if (stack == null || stack.m_41619_()) {
            return false;
        }
        Screen screen = this.clientScreenProvider.apply(stack).get();
        Minecraft.m_91087_().m_91152_(screen);
        return screen == null;
    }

    public static String getLangKeySingle(String name) {
        return LangUtil.getLangKey("gui", "single", name);
    }
}

