/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tileentities;

import com.direwolf20.buildinggadgets.common.tainted.building.BlockData;
import com.direwolf20.buildinggadgets.common.tileentities.OurTileEntities;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;

public class ConstructionBlockTileEntity
extends BlockEntity {
    private BlockData blockState;
    public static final ModelProperty<BlockState> FACADE_STATE = new ModelProperty();

    public ConstructionBlockTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)OurTileEntities.CONSTRUCTION_BLOCK_TILE_ENTITY.get(), pos, state);
    }

    public void setBlockState(BlockData state) {
        this.blockState = state;
        this.markDirtyClient();
    }

    @NotNull
    public ModelData getModelData() {
        if (this.blockState == null) {
            return super.getModelData();
        }
        BlockState state = this.blockState.getState();
        return ModelData.builder().with(FACADE_STATE, (Object)state).build();
    }

    @Nonnull
    public BlockState m_58900_() {
        return this.getConstructionBlockData().getState();
    }

    @Nonnull
    public BlockData getConstructionBlockData() {
        if (this.blockState == null) {
            return BlockData.AIR;
        }
        return this.blockState;
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.blockState = BlockData.tryDeserialize(nbt.m_128469_("state"), true);
        this.markDirtyClient();
    }

    @Nonnull
    protected void m_183515_(CompoundTag compound) {
        if (this.blockState != null) {
            compound.m_128365_("state", (Tag)this.blockState.serialize(true));
        }
        super.m_183515_(compound);
    }

    private void markDirtyClient() {
        this.m_6596_();
        if (this.m_58904_() != null) {
            BlockState state = this.m_58904_().m_8055_(this.m_58899_());
            this.m_58904_().m_7260_(this.m_58899_(), state, state, 3);
        }
    }

    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag updateTag = super.m_5995_();
        this.m_183515_(updateTag);
        return updateTag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        CompoundTag nbtTag = new CompoundTag();
        this.m_183515_(nbtTag);
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        BlockData oldMimicBlock = this.getConstructionBlockData();
        CompoundTag tagCompound = packet.m_131708_();
        super.onDataPacket(net, packet);
        this.deserializeNBT(tagCompound);
        if (this.f_58857_ != null && this.f_58857_.f_46443_ && !this.getConstructionBlockData().equals(oldMimicBlock)) {
            this.f_58857_.m_151543_(this.m_58899_());
        }
    }
}

